<?php
/**
 * Header CSS - All CSS files loaded in <head>
 * Centralized location for easy CDN URL management
 */

// Note: getCssUrl() function is now defined in functions.php
// Set $cdn_css_url there if you want to enable CDN for CSS files
?>

<!-- External CDN CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css">

<!-- Local CSS (with fonts) -->
<link rel="stylesheet" href="<?php echo $urlPath->assets_css('tabler-icons.min.css'); ?>?v=<?php echo time(); ?>">

<!-- Core CSS Files -->
<link rel="stylesheet" href="<?php echo getCssUrl('styles.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('section-icons.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('swiper-custom.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('swiper-custom-social.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('compact-header.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('category-menu.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('ajax-search.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('quintessential-font.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('animated-placeholder.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('auth-pages.css'); ?>?v=<?php echo time(); ?>">

<!-- Campaign & Category CSS -->
<link rel="stylesheet" href="<?php echo getCssUrl('campaign-styles.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('campaigns-slider.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('categories-slider.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('featured-categories.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('sidebar-campaigns.css'); ?>?v=<?php echo time(); ?>">

<!-- Store & Page CSS -->
<link rel="stylesheet" href="<?php echo getCssUrl('404-page.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('store-cards.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('footer-categories.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('page-content.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('footer-logo.css'); ?>?v=<?php echo time(); ?>">

<!-- System CSS -->
<link rel="stylesheet" href="<?php echo getCssUrl('popup-system.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('push-notifications.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('coupon-filter.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('css-stars.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('site-fixes.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('notification-bell.css'); ?>?v=<?php echo time(); ?>">

<!-- Redesign CSS Files -->
<link rel="stylesheet" href="<?php echo getCssUrl('filter-sidebar-redesign.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('sidenav-redesign.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('categories-slider-redesign.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('homepage-featured-offers.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('campaigns-redesign.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('why-choose-us.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('coupon-modal-redesign.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('product-cards.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('category-products-slider.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('footer-pages.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('contact-us.css'); ?>?v=<?php echo time(); ?>">
<link rel="stylesheet" href="<?php echo getCssUrl('modern-footer.css'); ?>?v=<?php echo time(); ?>">
