<div class="uk-container uk-margin-large-top uk-margin-large-bottom">
    
    <!-- Author Header -->
    <div class="uk-card uk-card-default uk-card-body uk-margin-large-bottom">
        <div class="uk-grid uk-grid-medium" uk-grid>
            <div class="uk-width-auto">
                <div class="uk-cover-container uk-border-circle" style="width: 100px; height: 100px;">
                    <img src="<?php echo SITE_URL; ?>/images/<?php echo $author['user_avatar'] ?: 'default-avatar.png'; ?>" 
                         alt="<?php echo htmlspecialchars($author['user_name']); ?>" 
                         uk-cover>
                    <canvas width="100" height="100"></canvas>
                </div>
            </div>
            <div class="uk-width-expand">
                <h1 class="uk-margin-remove"><?php echo htmlspecialchars($author['user_name']); ?></h1>
                <p class="uk-text-meta uk-margin-small-top">
                    <i class="ti ti-article"></i> <?php echo $totalPosts; ?> <?php echo $totalPosts == 1 ? 'Post' : 'Posts'; ?>
                </p>
                
                <?php if(!empty($author['user_bio'])): ?>
                <p class="uk-margin-top"><?php echo nl2br(htmlspecialchars($author['user_bio'])); ?></p>
                <?php endif; ?>
                
                <!-- Social Media Links -->
                <?php if(!empty($author['user_facebook']) || !empty($author['user_twitter']) || !empty($author['user_instagram']) || !empty($author['user_linkedin']) || !empty($author['user_website'])): ?>
                <div class="uk-margin-top">
                    <strong>Follow:</strong>
                    <?php if(!empty($author['user_facebook'])): ?>
                    <a href="<?php echo htmlspecialchars($author['user_facebook']); ?>" target="_blank" class="uk-icon-button uk-margin-small-left" uk-icon="facebook"></a>
                    <?php endif; ?>
                    <?php if(!empty($author['user_twitter'])): ?>
                    <a href="<?php echo htmlspecialchars($author['user_twitter']); ?>" target="_blank" class="uk-icon-button uk-margin-small-left" uk-icon="twitter"></a>
                    <?php endif; ?>
                    <?php if(!empty($author['user_instagram'])): ?>
                    <a href="<?php echo htmlspecialchars($author['user_instagram']); ?>" target="_blank" class="uk-icon-button uk-margin-small-left" uk-icon="instagram"></a>
                    <?php endif; ?>
                    <?php if(!empty($author['user_linkedin'])): ?>
                    <a href="<?php echo htmlspecialchars($author['user_linkedin']); ?>" target="_blank" class="uk-icon-button uk-margin-small-left" uk-icon="linkedin"></a>
                    <?php endif; ?>
                    <?php if(!empty($author['user_website'])): ?>
                    <a href="<?php echo htmlspecialchars($author['user_website']); ?>" target="_blank" class="uk-icon-button uk-margin-small-left" uk-icon="world"></a>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Posts by Author -->
    <h2 class="uk-heading-line"><span>Posts by <?php echo htmlspecialchars($author['user_name']); ?></span></h2>

    <?php if(empty($posts)): ?>
    <div class="uk-card uk-card-default uk-card-body uk-text-center">
        <p class="uk-text-muted">No posts found.</p>
    </div>
    <?php else: ?>
    <div class="uk-grid uk-grid-medium uk-child-width-1-3@m uk-child-width-1-2@s" uk-grid>
        <?php foreach($posts as $post): ?>
        <div>
            <div class="uk-card uk-card-default">
                <?php if($post['post_featured_image']): ?>
                <div class="uk-card-media-top">
                    <a href="<?php echo SITE_URL; ?>/Post/<?php echo $post['post_slug']; ?>">
                        <img src="<?php echo getImageUrl($post['post_featured_image_cdn_url'], $post['post_use_cdn'], $post['post_featured_image']); ?>" 
                             alt="<?php echo htmlspecialchars($post['post_title']); ?>"
                             style="width: 100%; height: 180px; object-fit: cover;">
                    </a>
                </div>
                <?php endif; ?>
                <div class="uk-card-body">
                    <?php if($post['blog_cat_name']): ?>
                    <span class="uk-label uk-label-warning"><?php echo htmlspecialchars($post['blog_cat_name']); ?></span>
                    <?php endif; ?>
                    <h3 class="uk-card-title uk-margin-small-top" style="font-size: 18px;">
                        <a href="<?php echo SITE_URL; ?>/Post/<?php echo $post['post_slug']; ?>" class="uk-link-reset">
                            <?php echo htmlspecialchars($post['post_title']); ?>
                        </a>
                    </h3>
                    <p class="uk-text-small uk-text-muted uk-margin-small">
                        <i class="ti ti-calendar"></i> <?php echo date('M d, Y', strtotime($post['published_at'])); ?>
                        <span class="uk-margin-small-left"><i class="ti ti-eye"></i> <?php echo number_format($post['post_views']); ?></span>
                    </p>
                    <p class="uk-text-small"><?php echo htmlspecialchars(substr(strip_tags($post['post_excerpt'] ?: $post['post_content']), 0, 100)) . '...'; ?></p>
                    <a href="<?php echo SITE_URL; ?>/Post/<?php echo $post['post_slug']; ?>" class="uk-button uk-button-text uk-text-primary">
                        Read More <i class="ti ti-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <!-- Pagination -->
    <?php if($totalPages > 1): ?>
    <ul class="uk-pagination uk-flex-center uk-margin-large-top">
        <?php if($currentPage > 1): ?>
        <li><a href="?page=<?php echo $currentPage - 1; ?>"><span uk-pagination-previous></span></a></li>
        <?php endif; ?>
        
        <?php for($i = 1; $i <= $totalPages; $i++): ?>
        <li class="<?php echo ($i == $currentPage) ? 'uk-active' : ''; ?>">
            <a href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
        </li>
        <?php endfor; ?>
        
        <?php if($currentPage < $totalPages): ?>
        <li><a href="?page=<?php echo $currentPage + 1; ?>"><span uk-pagination-next></span></a></li>
        <?php endif; ?>
    </ul>
    <?php endif; ?>
    <?php endif; ?>

</div>
