<?php

require "core.php";

$slugItem = clearGetData(getSlugItem());

if(empty($slugItem) && !isset($slugItem)){

	header('Location: '. $urlPath->home());
}

// Get ID By Slug
$itemDetails = getStoreBySlug($connect, $slugItem);

if(empty($itemDetails)){

	header('Location: '. $urlPath->home());
	
}

$getResults = getCouponsByStore($connect, $site_config['page_limit'], $itemDetails['store_id']);

$items = $getResults['items'];
$total = $getResults['total'];

$numPages = numTotalPages($total, $site_config['page_limit']);

// Get campaigns for this store
$storeCampaigns = getCampaignsByStore($connect, $itemDetails['store_id']);

// Seo Title
$titleSeoHeader = getSeoTitle(empty($itemDetails['store_seotitle']) ? $itemDetails['store_title'] : $itemDetails['store_seotitle']);

// Seo Description
$descriptionSeoHeader = getSeoDescription($translation['tr_3'], $itemDetails['store_description'], $itemDetails['store_seodescription']);

// Canonical URL
$canonicalUrl = SITE_URL . '/store/' . $itemDetails['store_slug'];

// Page Title
$pageTitle = $itemDetails['store_title'];

include './header.php';
require './views/single-store.view.php';
include './footer.php';

?>