<?php require './sections/views/sidebar-ad.view.php'; ?>

<div class="widget">
        <form class="searchForm">
            <div class="uk-margin">
                <div class="uk-inline uk-width-1-1 ajax-search-container">
                    <span class="uk-form-icon uk-form-icon-flip" uk-icon="icon: search"></span>

                    <?php if(!getSearchQuery() && empty(getSearchQuery())): ?>
                    <input class="uk-input uk-border-rounded uk-form-large ajax-search-input" name="query" placeholder="<?php echo echoOutput($translation['tr_137']); ?>" type="search" autocomplete="off">
                    <?php endif; ?>

                    <?php if(getSearchQuery() && !empty(getSearchQuery())): ?>
                    <input class="uk-input uk-border-rounded uk-form-large ajax-search-input" name="query" value="<?php echo echoOutput(getSearchQuery()); ?>" placeholder="<?php echo echoOutput($translation['tr_137']); ?>" type="search" autocomplete="off">
                    <?php endif; ?>

                    <div class="ajax-search-results"></div>
                </div>
            </div>
        </form>
        </div>

            <?php if(!empty($getCategories)): ?>
                <div class="widget">
                <h4 class="widget_heading"><?php echo echoOutput($translation['tr_130']); ?></h4>
                <div class="categories-list">
                    
                <?php foreach ($getCategories as $item): ?>
                    <label class="category-item">
                        <input type="checkbox" class="category-checkbox" data-value="<?php echo echoOutput($item['category_slug']); ?>" <?php echo (getSlugCategory() == $item['category_slug']) ? 'checked' : ''; ?>>
                        <span class="category-name"><?php echo echoOutput($item['category_title']); ?> (<?php echo isset($item['total_items']) ? (int)$item['total_items'] : 0; ?>)</span>
                    </label>
                <?php endforeach ?>
                </div>
                </div>
            <?php endif; ?>

            <?php if(!empty($getStores)): ?>
                <div class="widget">
                <h4 class="widget_heading"><?php echo echoOutput($translation['tr_138']); ?></h4>
                <div class="stores-list">
                    
                <?php foreach ($getStores as $item): ?>
                    <label class="store-item">
                        <input type="checkbox" class="store-checkbox" data-value="<?php echo echoOutput($item['store_slug']); ?>" <?php echo (getSlugStore() == $item['store_slug']) ? 'checked' : ''; ?>>
                        <span class="store-name"><?php echo echoOutput($item['store_title']); ?> (<?php echo isset($item['total_items']) ? (int)$item['total_items'] : 0; ?>)</span>
                    </label>
                <?php endforeach ?>
                </div>

                <?php if(count($getStores) > 15): ?>
                    <div class="uk-margin-small-top">
                    <a class="uk-button uk-button-default uk-width-1-1 uk-border-rounded uk-margin-small-top" href="#stores-modal" uk-toggle>
                    <?php echo echoOutput($translation['tr_116']); ?>
                    </a>
                    </div>
                <?php endif; ?>

                </div>

            <?php endif; ?>
        
            <div class="widget">
                <h4 class="widget_heading"><?php echo echoOutput($translation['tr_198']); ?></h4>
                <ul class="uk-nav-default otherFilters" uk-nav>
                    <li>
                    <label class="uk-text-secondary" data-value="exclusive">
                        <input class="uk-checkbox" type="checkbox" <?php echo (getFilterParam() == 'exclusive') ? 'checked' : NULL ?>><?php echo echoOutput($translation['tr_199']); ?>
                    </label>
                    </li>
                    <li>
                    <label class="uk-text-secondary" data-value="verified">
                        <input class="uk-checkbox" type="checkbox" <?php echo (getFilterParam() == 'verified') ? 'checked' : NULL ?>><?php echo echoOutput($translation['tr_200']); ?>
                    </label>
                    </li>
                </ul>
            </div>

            <?php require './sections/views/sidebar-campaigns.view.php'; ?>

            <?php require './sections/stores-modal.php'; ?>
