<!DOCTYPE html>
<html>
<head>
    <title>SEO Tools</title>
    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-5">
    <h2><i class="fa fa-search"></i> SEO Tools & Sitemap Management</h2>
    
    <?php if(isset($success)): ?>
    <div class="alert alert-success"><?php echo $success; ?></div>
    <?php endif; ?>
    
    <?php if(isset($error)): ?>
    <div class="alert alert-danger"><?php echo $error; ?></div>
    <?php endif; ?>
    
    <div class="row mt-4">
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3><?php echo number_format($totalUrls); ?></h3>
                    <p>Total URLs</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3><?php echo number_format($totalPosts); ?></h3>
                    <p>Blog Posts</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3><?php echo number_format($totalStores); ?></h3>
                    <p>Stores</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3><?php echo number_format($totalCoupons); ?></h3>
                    <p>Coupons</p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-success text-white">
                    <h5>Sitemap Actions</h5>
                </div>
                <div class="card-body">
                    <form method="post" class="mb-2">
                        <input type="hidden" name="action" value="generate_sitemap">
                        <button type="submit" class="btn btn-success btn-block">Generate Sitemap</button>
                    </form>
                    
                    <form method="post" class="mb-2">
                        <input type="hidden" name="action" value="submit_sitemap">
                        <button type="submit" class="btn btn-primary btn-block">Submit to Search Engines</button>
                    </form>
                    
                    <a href="<?php echo SITE_URL; ?>/sitemap.xml" target="_blank" class="btn btn-info btn-block">View Sitemap</a>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    <h5>robots.txt Editor</h5>
                </div>
                <div class="card-body">
                    <form method="post">
                        <input type="hidden" name="action" value="update_robots">
                        <textarea name="robots_content" class="form-control" rows="10" style="font-family: monospace;"><?php echo htmlspecialchars($robotsContent); ?></textarea>
                        <button type="submit" class="btn btn-warning btn-block mt-3">Update robots.txt</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <div class="mt-3">
        <a href="../controller/home.php" class="btn btn-secondary">← Back to Dashboard</a>
    </div>
</div>
</body>
</html>
