<?php require 'sidebar.php'; ?>

<section class="page-container">
  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        
        <div class="section-title">
          <h5><i class="fas fa-bell"></i> Push Notification Settings</h5>
          <p class="text-muted">Configure OneSignal push notifications for store followers</p>
        </div>

        <?php if(isset($setup_needed) && $setup_needed): ?>
        <!-- Setup Instructions -->
        <div class="row">
          <div class="col-12">
            <div class="alert alert-warning">
              <h6><i class="fas fa-exclamation-triangle"></i> Database Setup Required</h6>
              <p>The push notification tables need to be created in your database.</p>
              <p><strong>Please run the SQL file:</strong> <code>push_notification_setup.sql</code></p>
              <p class="mb-0">Import it using phpMyAdmin or your database tool.</p>
            </div>
          </div>
        </div>
        <?php else: ?>

        <div class="row">
          
          <?php if(isset($success)): ?>
          <div class="col-12">
            <div class="alert alert-success alert-dismissible fade show">
              Settings saved successfully!
              <button type="button" class="close" data-dismiss="alert">&times;</button>
            </div>
          </div>
          <?php endif; ?>

          <!-- Statistics Cards -->
          <div class="col-md-4 mb-4">
            <div class="card">
              <div class="card-body text-center">
                <i class="fas fa-users fa-3x text-primary mb-3"></i>
                <h3 class="mb-0"><?php echo number_format($total_followers); ?></h3>
                <p class="text-muted mb-0">Total Followers</p>
              </div>
            </div>
          </div>

          <div class="col-md-4 mb-4">
            <div class="card">
              <div class="card-body text-center">
                <i class="fas fa-paper-plane fa-3x text-success mb-3"></i>
                <h3 class="mb-0"><?php echo number_format($total_notifications); ?></h3>
                <p class="text-muted mb-0">Notifications Sent</p>
              </div>
            </div>
          </div>

          <div class="col-md-4 mb-4">
            <div class="card">
              <div class="card-body text-center">
                <i class="fas fa-check-double fa-3x text-info mb-3"></i>
                <h3 class="mb-0"><?php echo number_format($successful_notifications); ?></h3>
                <p class="text-muted mb-0">Successful Deliveries</p>
              </div>
            </div>
          </div>

          <!-- Configuration Form -->
          <div class="col-md-8 mb-4">
            <div class="card">
              <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-cog"></i> OneSignal Configuration</h6>
              </div>
              <div class="card-body">

                <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">

                  <div class="alert alert-info">
                    <strong>Setup Instructions:</strong><br>
                    1. Create account at <a href="https://onesignal.com" target="_blank">OneSignal.com</a><br>
                    2. Create a Web Push app<br>
                    3. Copy your App ID and REST API Key below
                  </div>

                  <div class="form-group">
                    <label><i class="fas fa-toggle-on"></i> Enable Push Notifications</label>
                    <div class="custom-control custom-switch">
                      <input type="checkbox" class="custom-control-input" id="notification_enabled" name="notification_enabled" <?php echo ($push_settings['notification_enabled'] ?? 0) ? 'checked' : ''; ?>>
                      <label class="custom-control-label" for="notification_enabled">Enable system</label>
                    </div>
                  </div>

                  <div class="form-group">
                    <label><i class="fas fa-key"></i> OneSignal App ID *</label>
                    <input type="text" class="form-control" name="onesignal_app_id" value="<?php echo htmlspecialchars($push_settings['onesignal_app_id'] ?? ''); ?>" placeholder="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx">
                    <small class="form-text text-muted">From OneSignal Dashboard → Settings → Keys & IDs</small>
                  </div>

                  <div class="form-group">
                    <label><i class="fas fa-lock"></i> OneSignal REST API Key *</label>
                    <input type="text" class="form-control" name="onesignal_api_key" value="<?php echo htmlspecialchars($push_settings['onesignal_api_key'] ?? ''); ?>" placeholder="Your REST API Key">
                    <small class="form-text text-muted">From OneSignal Dashboard → Settings → Keys & IDs</small>
                  </div>

                  <div class="form-group">
                    <label><i class="fab fa-safari"></i> Safari Web ID (Optional)</label>
                    <input type="text" class="form-control" name="onesignal_safari_web_id" value="<?php echo htmlspecialchars($push_settings['onesignal_safari_web_id'] ?? ''); ?>" placeholder="web.onesignal.auto.xxxxxxxx">
                    <small class="form-text text-muted">Only for Safari browser support</small>
                  </div>

                  <hr>

                  <h6 class="mb-3"><i class="fas fa-bell-slash"></i> Notification Types</h6>

                  <div class="form-group">
                    <div class="custom-control custom-checkbox">
                      <input type="checkbox" class="custom-control-input" id="welcome_notification" name="welcome_notification" <?php echo ($push_settings['welcome_notification'] ?? 1) ? 'checked' : ''; ?>>
                      <label class="custom-control-label" for="welcome_notification">Welcome notification on first subscription</label>
                    </div>
                  </div>

                  <div class="form-group">
                    <div class="custom-control custom-checkbox">
                      <input type="checkbox" class="custom-control-input" id="new_coupon_notification" name="new_coupon_notification" <?php echo ($push_settings['new_coupon_notification'] ?? 1) ? 'checked' : ''; ?>>
                      <label class="custom-control-label" for="new_coupon_notification">Notify when stores add new coupons</label>
                    </div>
                  </div>

                  <button type="submit" name="save_push_settings" class="btn btn-primary btn-block">
                    <i class="fas fa-save"></i> Save Settings
                  </button>

                </form>

              </div>
            </div>
          </div>

          <!-- Top Followed Stores -->
          <div class="col-md-4 mb-4">
            <div class="card">
              <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-star"></i> Top Followed Stores</h6>
              </div>
              <div class="card-body" style="max-height: 400px; overflow-y: auto;">
                <?php if(!empty($top_stores)): ?>
                  <?php foreach($top_stores as $store): ?>
                  <div class="d-flex align-items-center mb-3">
                    <img src="<?php echo SITE_URL . '/images/' . $store['store_image']; ?>" alt="<?php echo htmlspecialchars($store['store_title']); ?>" style="width: 40px; height: 40px; object-fit: contain; margin-right: 10px;">
                    <div>
                      <strong><?php echo htmlspecialchars($store['store_title']); ?></strong><br>
                      <small class="text-muted"><?php echo number_format($store['followers']); ?> followers</small>
                    </div>
                  </div>
                  <?php endforeach; ?>
                <?php else: ?>
                  <p class="text-muted text-center">No followers yet</p>
                <?php endif; ?>
              </div>
            </div>
          </div>

          <!-- Recent Notifications -->
          <div class="col-12">
            <div class="card">
              <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-history"></i> Recent Notifications</h6>
              </div>
              <div class="card-body">
                <?php if(!empty($recent_notifications)): ?>
                <div class="table-responsive">
                  <table class="table table-hover">
                    <thead>
                      <tr>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Store</th>
                        <th>Title</th>
                        <th>Sent</th>
                        <th>Success</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach($recent_notifications as $notif): ?>
                      <tr>
                        <td><?php echo date('M d, H:i', strtotime($notif['sent_at'])); ?></td>
                        <td><span class="badge badge-info"><?php echo htmlspecialchars($notif['notification_type']); ?></span></td>
                        <td><?php echo htmlspecialchars($notif['store_title'] ?? 'N/A'); ?></td>
                        <td><?php echo htmlspecialchars($notif['title']); ?></td>
                        <td><?php echo number_format($notif['sent_to']); ?></td>
                        <td><span class="text-success"><?php echo number_format($notif['successful']); ?></span></td>
                      </tr>
                      <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
                <?php else: ?>
                  <p class="text-muted text-center">No notifications sent yet</p>
                <?php endif; ?>
              </div>
            </div>
          </div>

        </div>

        <?php endif; // End setup check ?>

      </div>
    </div>
  </div>
</section>

<?php require 'footer.php'; ?>
