<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CueLinks Configuration - Admin Panel</title>
    <link rel="stylesheet" href="../assets/css/uikit.min.css">
    <link rel="stylesheet" href="../assets/css/tabler-icons.min.css">
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        .cuelinks-config-card {
            max-width: 800px;
            margin: 0 auto;
        }
        .config-section {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .info-box {
            background: #e3f2fd;
            border-left: 4px solid #2196f3;
            padding: 15px;
            margin-bottom: 20px;
        }
        .success-box {
            background: #e8f5e9;
            border-left: 4px solid #4caf50;
            padding: 15px;
            margin-bottom: 20px;
        }
        .error-box {
            background: #ffebee;
            border-left: 4px solid #f44336;
            padding: 15px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

<?php require '../views/sidebar.view.php'; ?>

<div class="tas-content">
    <?php require '../views/header.view.php'; ?>

    <div class="uk-container uk-container-large uk-margin-top">
        <div class="cuelinks-config-card">
            <div class="uk-card uk-card-default uk-card-body">
                <h2 class="uk-card-title">
                    <i class="ti ti-link"></i> CueLinks API Configuration
                </h2>

                <?php if ($message): ?>
                <div class="success-box">
                    <i class="ti ti-check"></i> <?php echo htmlspecialchars($message); ?>
                </div>
                <?php endif; ?>

                <?php if ($error): ?>
                <div class="error-box">
                    <i class="ti ti-alert-circle"></i> <?php echo htmlspecialchars($error); ?>
                </div>
                <?php endif; ?>

                <div class="info-box">
                    <h4><i class="ti ti-info-circle"></i> About CueLinks Integration</h4>
                    <p>Connect your CueLinks account to automatically fetch and import coupon offers directly into your website. No manual downloads required!</p>
                    <ul>
                        <li>Automatic coupon synchronization</li>
                        <li>Real-time offer updates</li>
                        <li>Direct API integration</li>
                        <li>Bulk import capabilities</li>
                    </ul>
                </div>

                <form method="POST" class="uk-form-stacked">
                    <div class="config-section">
                        <h3>API Credentials</h3>
                        
                        <div class="uk-margin">
                            <label class="uk-form-label" for="cuelinks_email">
                                <i class="ti ti-mail"></i> CueLinks Email
                            </label>
                            <div class="uk-form-controls">
                                <input 
                                    class="uk-input" 
                                    id="cuelinks_email" 
                                    name="cuelinks_email" 
                                    type="email" 
                                    placeholder="your@email.com"
                                    value="<?php echo htmlspecialchars($settings['cuelinks_email']); ?>"
                                    required>
                                <small class="uk-text-muted">Enter your CueLinks account email</small>
                            </div>
                        </div>

                        <div class="uk-margin">
                            <label class="uk-form-label" for="cuelinks_api_key">
                                <i class="ti ti-key"></i> API Key
                            </label>
                            <div class="uk-form-controls">
                                <input 
                                    class="uk-input" 
                                    id="cuelinks_api_key" 
                                    name="cuelinks_api_key" 
                                    type="text" 
                                    placeholder="Enter your CueLinks API key"
                                    value="<?php echo htmlspecialchars($settings['cuelinks_api_key']); ?>"
                                    required>
                                <small class="uk-text-muted">Get your API key from CueLinks dashboard</small>
                            </div>
                        </div>

                        <div class="uk-margin">
                            <label>
                                <input 
                                    class="uk-checkbox" 
                                    type="checkbox" 
                                    name="cuelinks_enabled"
                                    <?php echo $settings['cuelinks_enabled'] ? 'checked' : ''; ?>>
                                Enable CueLinks Integration
                            </label>
                        </div>
                    </div>

                    <div class="uk-margin">
                        <button class="uk-button uk-button-primary" type="submit">
                            <i class="ti ti-device-floppy"></i> Save Configuration
                        </button>
                        <a href="../controller/cuelinks_fetch.php" class="uk-button uk-button-secondary">
                            <i class="ti ti-download"></i> Fetch Coupons
                        </a>
                    </div>
                </form>

                <div class="info-box" style="margin-top: 30px;">
                    <h4><i class="ti ti-help"></i> How to Get Your API Key</h4>
                    <ol>
                        <li>Log in to your CueLinks account</li>
                        <li>Navigate to Settings → API Settings</li>
                        <li>Generate or copy your API key</li>
                        <li>Paste it in the field above</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="../assets/js/uikit.min.js"></script>
</body>
</html>
