<?php require 'sidebar.php'; ?>  

<!--Page Container-->
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="section-title">
          <h5 class="text-truncate">Campaigns</h5>
        </div>

        <div class="row">

          <div class="col-12 c-col-12">
            <a class="btn btn-primary" href="./new_campaign.php">
              <i class="fa fa-plus add-new-i"></i> <?php echo _ADDITEM; ?>
            </a>
          </div>

          <div class="col-12">
            <div class="block table-block mb-4 c-4">

              <?php if (isset($_SESSION['campaign_success'])): ?>
              <div class="alert alert-success alert-dismissible fade show" role="alert">
                  <?php echo $_SESSION['campaign_success']; unset($_SESSION['campaign_success']); ?>
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                  </button>
              </div>
              <?php endif; ?>

              <?php if (isset($_SESSION['campaign_error'])): ?>
              <div class="alert alert-danger alert-dismissible fade show" role="alert">
                  <?php echo $_SESSION['campaign_error']; unset($_SESSION['campaign_error']); ?>
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                  </button>
              </div>
              <?php endif; ?>

              <div class="row">
                <div class="table-responsive">
                  <table class="table table-striped table-bordered" cellspacing="0" width="100%" style="border-radius: 5px;">
                    <thead>
                      <tr>
                        <th><?php echo _TABLEFIELDID; ?></th>
                        <th><?php echo _TABLEFIELDIMAGE; ?></th>
                        <th><?php echo _TABLEFIELDTITLE; ?></th>
                        <th>Store</th>
                        <th>Order</th>
                        <th><?php echo _TABLEFIELDSTATUS; ?></th>
                        <th><?php echo _TABLEFIELDACTIONS; ?></th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php 
                      if (isset($campaigns)) {
                          foreach ($campaigns as $campaign) {
                              echo '<tr>';
                              echo '<td class="text-center">' . $campaign['campaign_id'] . '</td>';
                              echo '<td class="product text-center"><img src="../../images/' . $campaign['campaign_image'] . '" style="max-width: 120px; height: auto;"></td>';
                              echo '<td>' . htmlspecialchars($campaign['campaign_title']) . '</td>';
                              echo '<td class="text-center">' . ($campaign['store_title'] ? '<span class="badge badge-pill badge-info">' . htmlspecialchars($campaign['store_title']) . '</span>' : '-') . '</td>';
                              echo '<td class="text-center">' . $campaign['campaign_order'] . '</td>';
                              echo '<td class="status text-center">' . ($campaign['campaign_status'] == 1 ? '<span class="badge badge-pill bg-success"><i class="dripicons-checkmark"></i></span>' : '<span class="badge badge-pill bg-danger"><i class="dripicons-cross"></i></span>') . '</td>';
                              echo '<td class="text-center">';
                              echo '<a class="btn btn-small btn-primary" href="./edit_campaign.php?id=' . $campaign['campaign_id'] . '">' . _EDITITEM . '</a> ';
                              echo '<a class="btn btn-small btn-danger btn-delete deleteItem" data-url="./delete_campaign.php?id=' . $campaign['campaign_id'] . '">' . _DELETEITEM . '</a>';
                              echo '</td>';
                              echo '</tr>';
                          }
                      } else {
                          echo '<tr><td colspan="7" class="text-center text-muted">No campaigns found.</td></tr>';
                      }
                      ?>
                    </tbody>
                  </table>

                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
