<div class="auth-wrapper">
    <div class="auth-container otp-container">
        
        <!-- Left Side - Branding -->
        <div class="auth-brand-side">
            <div class="brand-content">
                <a href="<?php echo $urlPath->home(); ?>" class="brand-logo">
                    <img src="<?php echo $urlPath->image($theme['th_logo']); ?>" alt="Logo">
                </a>
                <h1 class="brand-title">Verify Your Email</h1>
                <p class="brand-subtitle">We've sent a verification code to your email address</p>
                
                <div class="brand-features">
                    <div class="feature-item">
                        <span class="feature-icon" uk-icon="icon: check; ratio: 1.2"></span>
                        <span>Secure Authentication</span>
                    </div>
                    <div class="feature-item">
                        <span class="feature-icon" uk-icon="icon: check; ratio: 1.2"></span>
                        <span>Quick Verification</span>
                    </div>
                    <div class="feature-item">
                        <span class="feature-icon" uk-icon="icon: check; ratio: 1.2"></span>
                        <span>Protected Account</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Side - OTP Form -->
        <div class="auth-form-side">
            <div class="auth-close">
                <a onclick="goBack()" uk-icon="icon: close; ratio: 1.5"></a>
            </div>

            <div class="auth-form-content otp-form-content">
                <div class="otp-icon">
                    <svg width="80" height="80" viewBox="0 0 80 80" fill="none">
                        <circle cx="40" cy="40" r="40" fill="#667eea" opacity="0.1"/>
                        <path d="M40 20C28.954 20 20 28.954 20 40C20 51.046 28.954 60 40 60C51.046 60 60 51.046 60 40C60 28.954 51.046 20 40 20ZM40 25C42.761 25 45 27.239 45 30C45 32.761 42.761 35 40 35C37.239 35 35 32.761 35 30C35 27.239 37.239 25 40 25ZM40 55C34.5 55 29.7 52.15 27 47.85C27.075 43.45 35.5 41 40 41C44.475 41 52.925 43.45 53 47.85C50.3 52.15 45.5 55 40 55Z" fill="#667eea"/>
                    </svg>
                </div>

                <h2 class="auth-title">Enter Verification Code</h2>
                <p class="auth-subtitle">We've sent a 6-digit code to your email</p>
                <p class="otp-phone-display" id="displayEmail"></p>

                <form class="auth-form" id="otpVerifyForm">
                    
                    <div class="otp-input-container">
                        <input type="text" maxlength="1" class="otp-input" id="otp1" autofocus>
                        <input type="text" maxlength="1" class="otp-input" id="otp2">
                        <input type="text" maxlength="1" class="otp-input" id="otp3">
                        <input type="text" maxlength="1" class="otp-input" id="otp4">
                        <input type="text" maxlength="1" class="otp-input" id="otp5">
                        <input type="text" maxlength="1" class="otp-input" id="otp6">
                    </div>

                    <div id="otpError" class="alert alert-error" style="display: none;">
                        <span uk-icon="icon: warning"></span>
                        <div>
                            <p id="otpErrorMessage"></p>
                        </div>
                    </div>

                    <div class="otp-timer-section">
                        <div id="timer" class="otp-timer">
                            <span uk-icon="icon: clock"></span>
                            Resend code in <span id="countdown">60</span>s
                        </div>
                        <button type="button" class="resend-btn" id="resendOtpBtn" style="display: none;">
                            <span uk-icon="icon: refresh"></span>
                            Resend Code
                        </button>
                    </div>

                    <button type="submit" class="btn btn-primary btn-block" id="verifyOtpBtn">
                        Verify Code
                        <span uk-icon="icon: check"></span>
                    </button>

                    <div class="auth-footer">
                        <a href="<?php echo $urlPath->signin(); ?>" class="auth-link">
                            <span uk-icon="icon: arrow-left"></span>
                            Back to Sign In
                        </a>
                    </div>
                </form>

            </div>
        </div>

    </div>
</div>

<style>
.otp-container {
    max-width: 900px;
}

.otp-form-content {
    text-align: center;
}

.otp-icon {
    margin: 0 auto 30px;
    width: 80px;
    height: 80px;
}

.otp-phone-display {
    font-size: 18px;
    font-weight: 700;
    color: #667eea;
    margin-bottom: 30px;
}

.otp-timer-section {
    text-align: center;
    margin: 20px 0;
}

.otp-timer {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    color: #6b7280;
}

.resend-btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 10px 20px;
    background: transparent;
    border: 2px solid #667eea;
    border-radius: 12px;
    color: #667eea;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
}

.resend-btn:hover {
    background: #667eea;
    color: #ffffff;
}
</style>

<script>
// OTP Input Auto-focus and Auto-submit
document.addEventListener('DOMContentLoaded', function() {
    const otpInputs = document.querySelectorAll('.otp-input');
    const verifyBtn = document.getElementById('verifyOtpBtn');
    const resendBtn = document.getElementById('resendOtpBtn');
    const timerDiv = document.getElementById('timer');
    const countdownSpan = document.getElementById('countdown');
    const otpError = document.getElementById('otpError');
    const otpErrorMessage = document.getElementById('otpErrorMessage');
    
    // Auto-focus next input
    otpInputs.forEach((input, index) => {
        input.addEventListener('input', function(e) {
            // Only allow numbers
            this.value = this.value.replace(/[^0-9]/g, '');
            
            if (this.value.length === 1 && index < otpInputs.length - 1) {
                otpInputs[index + 1].focus();
            }
            
            // Auto-submit when all filled
            const allFilled = Array.from(otpInputs).every(inp => inp.value.length === 1);
            if (allFilled) {
                setTimeout(() => {
                    document.getElementById('otpVerifyForm').dispatchEvent(new Event('submit'));
                }, 300);
            }
        });
        
        // Handle backspace
        input.addEventListener('keydown', function(e) {
            if (e.key === 'Backspace' && this.value === '' && index > 0) {
                otpInputs[index - 1].focus();
            }
        });
        
        // Handle paste
        input.addEventListener('paste', function(e) {
            e.preventDefault();
            const pastedData = e.clipboardData.getData('text').replace(/[^0-9]/g, '').slice(0, 6);
            pastedData.split('').forEach((char, i) => {
                if (otpInputs[i]) {
                    otpInputs[i].value = char;
                }
            });
            if (pastedData.length === 6) {
                otpInputs[5].focus();
                setTimeout(() => {
                    document.getElementById('otpVerifyForm').dispatchEvent(new Event('submit'));
                }, 300);
            }
        });
    });
    
    // Countdown timer
    let timeLeft = 60;
    const countdown = setInterval(() => {
        timeLeft--;
        countdownSpan.textContent = timeLeft;
        
        if (timeLeft <= 0) {
            clearInterval(countdown);
            timerDiv.style.display = 'none';
            resendBtn.style.display = 'inline-flex';
        }
    }, 1000);
    
    // Resend OTP
    resendBtn.addEventListener('click', function() {
        if (window.authHandler) {
            window.authHandler.resendOTP();
            // Reset timer
            timeLeft = 60;
            timerDiv.style.display = 'inline-flex';
            resendBtn.style.display = 'none';
            countdownSpan.textContent = timeLeft;
            
            const newCountdown = setInterval(() => {
                timeLeft--;
                countdownSpan.textContent = timeLeft;
                
                if (timeLeft <= 0) {
                    clearInterval(newCountdown);
                    timerDiv.style.display = 'none';
                    resendBtn.style.display = 'inline-flex';
                }
            }, 1000);
        }
    });
    
    // Verify OTP Form
    document.getElementById('otpVerifyForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const otp = Array.from(otpInputs).map(input => input.value).join('');
        
        if (otp.length !== 6) {
            otpErrorMessage.textContent = 'Please enter all 6 digits';
            otpError.style.display = 'flex';
            return;
        }
        
        otpError.style.display = 'none';
        verifyBtn.disabled = true;
        verifyBtn.innerHTML = 'Verifying... <span uk-icon="icon: check"></span>';
        
        if (window.authHandler) {
            window.authHandler.verifyOTP(otp)
                .then(() => {
                    // Success handled by auth handler
                })
                .catch(error => {
                    otpErrorMessage.textContent = error.message || 'Invalid OTP. Please try again.';
                    otpError.style.display = 'flex';
                    verifyBtn.disabled = false;
                    verifyBtn.innerHTML = 'Verify Code <span uk-icon="icon: check"></span>';
                    
                    // Clear inputs
                    otpInputs.forEach(input => input.value = '');
                    otpInputs[0].focus();
                });
        }
    });
    
    // Display email from session/localStorage
    const userEmail = localStorage.getItem('verifyEmail') || sessionStorage.getItem('verifyEmail') || '<?php echo isset($_SESSION['pending_user_email']) ? maskEmail($_SESSION['pending_user_email']) : ''; ?>';
    if (userEmail) {
        document.getElementById('displayEmail').textContent = userEmail;
    }
});
</script>
