<?php require './sections/header.php'; ?>

<div class="auth-wrapper">
    <div class="auth-container">
        
        <!-- Left Side - Branding -->
        <div class="auth-brand-side">
            <div class="brand-content">
                <a href="<?php echo $urlPath->home(); ?>" class="brand-logo">
                    <img src="<?php echo $urlPath->image($theme['th_logo']); ?>" alt="Logo">
                </a>
                <h1 class="brand-title">Join Us Today!</h1>
                <p class="brand-subtitle">Create an account and start saving with exclusive deals</p>
                
                <div class="brand-features">
                    <div class="feature-item">
                        <span class="feature-icon" uk-icon="icon: check; ratio: 1.2"></span>
                        <span>Thousands of Deals</span>
                    </div>
                    <div class="feature-item">
                        <span class="feature-icon" uk-icon="icon: check; ratio: 1.2"></span>
                        <span>Daily New Offers</span>
                    </div>
                    <div class="feature-item">
                        <span class="feature-icon" uk-icon="icon: check; ratio: 1.2"></span>
                        <span>100% Free Forever</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Side - Register Form -->
        <div class="auth-form-side">
            <div class="auth-close">
                <a onclick="goBack()" uk-icon="icon: close; ratio: 1.5"></a>
            </div>

            <div class="auth-form-content">
                <h2 class="auth-title">Create Account</h2>
                <p class="auth-subtitle">Choose your preferred sign up method</p>

                <!-- Social Signup Buttons -->
                <?php if((isset($settings['st_google_login']) && $settings['st_google_login'] == 1) || (isset($settings['st_facebook_login']) && $settings['st_facebook_login'] == 1)): ?>
                <div class="social-auth-buttons">
                    <?php if(isset($settings['st_google_login']) && $settings['st_google_login'] == 1): ?>
                    <button class="social-btn google-btn" id="googleSignupBtn">
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M19.8 10.2273C19.8 9.51819 19.7364 8.83637 19.6182 8.18182H10.2V12.05H15.6109C15.3818 13.3 14.6727 14.3591 13.6091 15.0682V17.5773H16.8273C18.7091 15.8364 19.8 13.2727 19.8 10.2273Z" fill="#4285F4"/>
                            <path d="M10.2 20C12.9 20 15.1636 19.1045 16.8273 17.5773L13.6091 15.0682C12.7091 15.6682 11.5636 16.0227 10.2 16.0227C7.59545 16.0227 5.38182 14.2636 4.58636 11.9H1.25455V14.4909C2.90909 17.7591 6.29091 20 10.2 20Z" fill="#34A853"/>
                            <path d="M4.58636 11.9C4.38636 11.3 4.27273 10.6591 4.27273 10C4.27273 9.34091 4.38636 8.7 4.58636 8.1V5.50909H1.25455C0.572727 6.85909 0.2 8.38636 0.2 10C0.2 11.6136 0.572727 13.1409 1.25455 14.4909L4.58636 11.9Z" fill="#FBBC05"/>
                            <path d="M10.2 3.97727C11.6818 3.97727 13.0045 4.48182 14.0364 5.47273L16.8909 2.61818C15.1591 0.986364 12.8955 0 10.2 0C6.29091 0 2.90909 2.24091 1.25455 5.50909L4.58636 8.1C5.38182 5.73636 7.59545 3.97727 10.2 3.97727Z" fill="#EA4335"/>
                        </svg>
                        Continue with Google
                    </button>
                    <?php endif; ?>
                    
                    <?php if(isset($settings['st_facebook_login']) && $settings['st_facebook_login'] == 1): ?>
                    <button class="social-btn facebook-btn" id="facebookSignupBtn">
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M20 10C20 4.47715 15.5229 0 10 0C4.47715 0 0 4.47715 0 10C0 14.9912 3.65684 19.1283 8.4375 19.8785V12.8906H5.89844V10H8.4375V7.79688C8.4375 5.29063 9.93047 3.90625 12.2146 3.90625C13.3084 3.90625 14.4531 4.10156 14.4531 4.10156V6.5625H13.1922C11.95 6.5625 11.5625 7.3334 11.5625 8.125V10H14.3359L13.8926 12.8906H11.5625V19.8785C16.3432 19.1283 20 14.9912 20 10Z" fill="#1877F2"/>
                        </svg>
                        Continue with Facebook
                    </button>
                    <?php endif; ?>
                </div>

                <div class="divider">
                    <span>or</span>
                </div>
                <?php endif; ?>

                <!-- Tab Navigation -->
                <div class="auth-tabs">
                    <button class="tab-btn active" data-tab="email">
                        <span uk-icon="icon: mail"></span>
                        Email
                    </button>
                    <button class="tab-btn" data-tab="mobile">
                        <span uk-icon="icon: receiver"></span>
                        Mobile
                    </button>
                </div>

                <!-- Email Signup Form -->
                <div class="tab-content active" id="email-tab">
                    <form class="auth-form" id="emailSignupForm" action="<?php echo htmlspecialchars($urlPath->signup()); ?>" method="post">
                        
                        <div class="form-group">
                            <label class="form-label">Full Name</label>
                            <div class="input-wrapper">
                                <span class="input-icon" uk-icon="icon: user"></span>
                                <input type="text" name="user_name" class="form-input" placeholder="Enter your name" required>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="form-label">Email Address</label>
                            <div class="input-wrapper">
                                <span class="input-icon" uk-icon="icon: mail"></span>
                                <input type="email" name="user_email" class="form-input" placeholder="Enter your email" required>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="form-label">Password</label>
                            <div class="input-wrapper">
                                <span class="input-icon" uk-icon="icon: lock"></span>
                                <input type="password" name="user_password" class="form-input" placeholder="Create a password" required>
                            </div>
                            <small class="form-hint">Minimum 8 characters</small>
                        </div>

                        <div class="form-group">
                            <label class="checkbox-label">
                                <input type="checkbox" name="ischecked" value="1" required>
                                <span>I agree to the <a href="<?php echo $urlPath->terms(); ?>" target="_blank">Terms</a> and <a href="<?php echo $urlPath->privacy(); ?>" target="_blank">Privacy Policy</a></span>
                            </label>
                        </div>

                        <div id="signup-error-messages" class="alert alert-error" style="display: none;">
                            <span uk-icon="icon: warning"></span>
                            <div id="error-list"></div>
                        </div>

                        <button type="submit" class="btn btn-primary btn-block" id="signupSubmitBtn">
                            Create Account
                            <span uk-icon="icon: arrow-right"></span>
                        </button>
                    </form>
                </div>

                <!-- Mobile Signup Form -->
                <div class="tab-content" id="mobile-tab">
                    <form class="auth-form" id="mobileSignupForm">
                        
                        <div class="form-group">
                            <label class="form-label">Full Name</label>
                            <div class="input-wrapper">
                                <span class="input-icon" uk-icon="icon: user"></span>
                                <input type="text" id="signup_name" class="form-input" placeholder="Enter your name" required>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="form-label">Mobile Number</label>
                            <div class="input-wrapper">
                                <span class="input-icon" uk-icon="icon: receiver"></span>
                                <input type="tel" id="signup_mobile" class="form-input" placeholder="+1234567890" required>
                            </div>
                            <small class="form-hint">Include country code (e.g., +1 for US)</small>
                        </div>

                        <div class="form-group">
                            <label class="checkbox-label">
                                <input type="checkbox" id="mobile_terms" required>
                                <span>I agree to the <a href="<?php echo $urlPath->terms(); ?>" target="_blank">Terms</a> and <a href="<?php echo $urlPath->privacy(); ?>" target="_blank">Privacy Policy</a></span>
                            </label>
                        </div>

                        <div id="recaptcha-container-signup"></div>

                        <button type="submit" class="btn btn-primary btn-block" id="sendSignupOtpBtn">
                            Send OTP
                            <span uk-icon="icon: arrow-right"></span>
                        </button>
                    </form>
                </div>

                <div class="auth-footer">
                    Already have an account? <a href="<?php echo $urlPath->signin(); ?>" class="auth-link">Sign In</a>
                </div>
            </div>
        </div>

    </div>
</div>

<?php require './sections/footer.php'; ?>

<script>
// Tab Switching
document.addEventListener('DOMContentLoaded', function() {
    const tabBtns = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');
    
    tabBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            const tabName = this.dataset.tab;
            
            tabBtns.forEach(b => b.classList.remove('active'));
            tabContents.forEach(c => c.classList.remove('active'));
            
            this.classList.add('active');
            document.getElementById(tabName + '-tab').classList.add('active');
        });
    });
    
    // Handle Email Signup Form Submission
    const emailSignupForm = document.getElementById('emailSignupForm');
    if (emailSignupForm) {
        emailSignupForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const submitBtn = document.getElementById('signupSubmitBtn');
            const errorDiv = document.getElementById('signup-error-messages');
            const errorList = document.getElementById('error-list');
            
            // Disable submit button
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<span uk-spinner="ratio: 0.6"></span> Creating Account...';
            
            // Hide previous errors
            errorDiv.style.display = 'none';
            errorList.innerHTML = '';
            
            // Get form data
            const formData = new FormData(emailSignupForm);
            
            // Submit via AJAX
            fetch('controllers/signup.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(text => {
                try {
                    return JSON.parse(text);
                } catch (e) {
                    throw new Error('Invalid server response');
                }
            })
            .then(data => {
                if (data.success) {
                    // Show success message
                    UIkit.notification({
                        message: '<span uk-icon="icon: check"></span> Welcome! Your account has been created successfully!',
                        status: 'success',
                        pos: 'top-center',
                        timeout: 2000
                    });
                    
                    // Redirect after 1 second
                    setTimeout(() => {
                        window.location.href = data.redirect;
                    }, 1000);
                } else {
                    // Show errors
                    if (data.errors && data.errors.length > 0) {
                        errorList.innerHTML = data.errors.map(error => `<p>${error}</p>`).join('');
                        errorDiv.style.display = 'block';
                    }
                    
                    // Re-enable submit button
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = 'Create Account <span uk-icon="icon: arrow-right"></span>';
                    
                    // Reset reCAPTCHA if it exists
                    if (typeof grecaptcha !== 'undefined') {
                        grecaptcha.reset();
                    }
                }
            })
            .catch(error => {
                errorList.innerHTML = '<p>Registration failed. Please try again.</p>';
                errorDiv.style.display = 'block';
                
                // Re-enable submit button
                submitBtn.disabled = false;
                submitBtn.innerHTML = 'Create Account <span uk-icon="icon: arrow-right"></span>';
                
                // Reset reCAPTCHA if it exists
                if (typeof grecaptcha !== 'undefined') {
                    grecaptcha.reset();
                }
            });
        });
    }
});
</script>
