<?php
/**
 * Optimized Header JS - Reduces Render-Blocking JavaScript
 * 
 * Strategy:
 * 1. Load critical JS (jQuery, UIKit) normally (needed for page functionality)
 * 2. Defer non-critical JS using async/defer attributes
 * 3. Preload critical scripts
 */

// Set your CDN base URL here (leave empty to use local files)
$cdn_js_url = ''; // Example: 'https://cdn.example.com/js'

// Helper function to get JS URL
function getHeaderJsUrl($filename) {
    global $cdn_js_url, $urlPath;
    if (!empty($cdn_js_url)) {
        return $cdn_js_url . '/' . $filename;
    }
    return $urlPath->assets_js($filename);
}
?>

<!-- Preload Critical JavaScript -->
<link rel="preload" href="<?php echo getHeaderJsUrl('jquery.js'); ?>" as="script">
<link rel="preload" href="<?php echo getHeaderJsUrl('uikit.js'); ?>" as="script">

<!-- Critical JS - Load Immediately (Required for page functionality) -->
<script src="<?php echo getHeaderJsUrl('jquery.js'); ?>"></script>
<script src="<?php echo getHeaderJsUrl('uikit.js'); ?>"></script>
<script src="<?php echo getHeaderJsUrl('uikit-icons.js'); ?>"></script>

<!-- Non-Critical JS - Defer Loading -->
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js" defer></script>
<script src="<?php echo getHeaderJsUrl('swiper-init.js'); ?>" defer></script>
<script src="<?php echo getHeaderJsUrl('sticky-header.js'); ?>" defer></script>
<script src="<?php echo getHeaderJsUrl('scroll-to-top.js'); ?>" defer></script>
<script src="<?php echo getHeaderJsUrl('ajax-search.js'); ?>" defer></script>
<script src="<?php echo getHeaderJsUrl('animated-placeholder.js'); ?>" defer></script>
<script src="<?php echo getHeaderJsUrl('popup-system.js'); ?>" defer></script>
<script src="<?php echo getHeaderJsUrl('push-notifications.js'); ?>" defer></script>
<script src="<?php echo getHeaderJsUrl('coupon-filter.js'); ?>" defer></script>
