<?php
/**
 * Optimized Header CSS - Fixes Render-Blocking Resources
 * 
 * Strategy:
 * 1. Inline critical CSS for above-the-fold content
 * 2. Preload critical external CSS
 * 3. Defer non-critical CSS using media="print" trick
 * 4. Load remaining CSS asynchronously
 */
?>

<!-- Critical CSS Inline (Above-the-fold styles) -->
<style>
/* Critical styles for initial page render */
body{margin:0;padding:0;font-family:'Manrope',sans-serif;background:#f8f9fa;color:#333}
.uk-container{max-width:1200px;margin:0 auto;padding:0 15px}
header{background:#fff;box-shadow:0 2px 4px rgba(0,0,0,.1);position:sticky;top:0;z-index:1000}
.uk-navbar{display:flex;align-items:center;justify-content:space-between;padding:15px 0}
#preloader{position:fixed;top:0;left:0;width:100%;height:100%;background:#fff;z-index:9999;display:flex;align-items:center;justify-content:center}
.spinner{width:50px;height:50px}
.modern-spinner{display:flex;gap:8px}
.spinner-circle{width:12px;height:12px;background:#007bff;border-radius:50%;animation:bounce 1.4s infinite ease-in-out both}
.spinner-circle:nth-child(1){animation-delay:-0.32s}
.spinner-circle:nth-child(2){animation-delay:-0.16s}
@keyframes bounce{0%,80%,100%{transform:scale(0)}40%{transform:scale(1)}}
.uk-button{display:inline-block;padding:10px 20px;background:#007bff;color:#fff;border:none;border-radius:4px;cursor:pointer;text-decoration:none}
.uk-card{background:#fff;border-radius:8px;box-shadow:0 2px 8px rgba(0,0,0,.1);padding:20px;margin-bottom:20px}
</style>

<!-- Preload Critical Resources -->
<link rel="preload" href="https://assets.alonedeals.com/assets/css/styles.css" as="style">
<link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" as="style">
<link rel="preload" href="https://fonts.googleapis.com/css2?family=Manrope:wght@300;400;500;600;700;800&family=Quintessential&display=swap" as="style">

<!-- Critical CSS - Load Immediately -->
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/styles.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer">

<!-- Defer Non-Critical CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/tabler-icons.min.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/section-icons.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/swiper-custom.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/swiper-custom-social.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/compact-header.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/category-menu.css?v=<?php echo time(); ?>" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/ajax-search.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/quintessential-font.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/animated-placeholder.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/auth-pages.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/campaign-styles.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/campaigns-slider.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/categories-slider.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/featured-categories.css?v=<?php echo time(); ?>" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/sidebar-campaigns.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/404-page.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/store-cards.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/footer-categories.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/page-content.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/footer-logo.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/popup-system.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/push-notifications.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/coupon-filter.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/css-stars.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/site-fixes.css?v=<?php echo time(); ?>" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/notification-bell.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/filter-sidebar-redesign.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/sidenav-redesign.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/categories-slider-redesign.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/homepage-featured-offers.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/campaigns-redesign.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/why-choose-us.css" media="print" onload="this.media='all'">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/coupon-modal-redesign.css" media="print" onload="this.media='all'">

<!-- Fallback for browsers that don't support onload -->
<noscript>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/tabler-icons.min.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/section-icons.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/swiper-custom.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/swiper-custom-social.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/compact-header.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/category-menu.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/ajax-search.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/quintessential-font.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/animated-placeholder.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/auth-pages.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/campaign-styles.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/campaigns-slider.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/categories-slider.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/featured-categories.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/sidebar-campaigns.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/404-page.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/store-cards.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/footer-categories.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/page-content.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/footer-logo.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/popup-system.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/push-notifications.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/coupon-filter.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/css-stars.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/site-fixes.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/notification-bell.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/filter-sidebar-redesign.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/sidenav-redesign.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/categories-slider-redesign.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/homepage-featured-offers.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/campaigns-redesign.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/why-choose-us.css">
<link rel="stylesheet" href="https://assets.alonedeals.com/assets/css/coupon-modal-redesign.css">
</noscript>

<!-- Polyfill for older browsers -->
<script>
!function(e){"use strict";var t=function(t,n,o){var i,r=e.document,a=r.createElement("link");if(n)i=n;else{var l=(r.body||r.getElementsByTagName("head")[0]).childNodes;i=l[l.length-1]}var d=r.styleSheets;a.rel="stylesheet",a.href=t,a.media="only x",function e(t){if(r.body)return t();setTimeout(function(){e(t)})}(function(){i.parentNode.insertBefore(a,n?i:i.nextSibling)});var s=function(e){for(var t=a.href,n=d.length;n--;)if(d[n].href===t)return e();setTimeout(function(){s(e)})};return a.addEventListener&&a.addEventListener("load",o),a.onloadcssdefined=s,s(o),a};"undefined"!=typeof exports?exports.loadCSS=t:e.loadCSS=t}("undefined"!=typeof global?global:this);
</script>
