<?php
/**
 * AVIF Image Support Update Script
 * Run this once to add AVIF support to all image upload controllers
 */

$files = [
    'admin/controller/edit_slider.php',
    'admin/controller/new_slider.php',
    'admin/controller/edit_store.php',
    'admin/controller/new_store.php',
    'admin/controller/edit_coupon.php',
    'admin/controller/new_coupon.php',
    'admin/controller/edit_category.php',
    'admin/controller/new_category.php',
];

$updated = 0;
$failed = 0;

foreach ($files as $file) {
    if (!file_exists($file)) {
        echo "❌ File not found: $file\n";
        $failed++;
        continue;
    }
    
    $content = file_get_contents($file);
    $original = $content;
    
    // Update AVIF support - multiple patterns
    $patterns = [
        "/array\('jpg',\s*'jpeg',\s*'png',\s*'gif'\)/i" => "array('jpg', 'jpeg', 'png', 'gif', 'webp', 'avif')",
        "/array\('jpg',\s*'jpeg',\s*'png',\s*'gif',\s*'webp'\)/i" => "array('jpg', 'jpeg', 'png', 'gif', 'webp', 'avif')",
    ];
    
    foreach ($patterns as $pattern => $replacement) {
        $content = preg_replace($pattern, $replacement, $content);
    }
    
    if ($content !== $original) {
        file_put_contents($file, $content);
        echo "✅ Updated: $file\n";
        $updated++;
    } else {
        echo "⚠️  No changes needed: $file\n";
    }
}

echo "\n=== Summary ===\n";
echo "Updated: $updated files\n";
echo "Failed: $failed files\n";
echo "\n✅ AVIF support has been added to all image upload controllers!\n";
echo "Supported formats: JPG, JPEG, PNG, GIF, WebP, AVIF\n";
?>
