<?php
/**
 * Test SEO Features Integration
 * Visit: http://localhost/test_seo_features.php
 */

require "core.php";
require "includes/image_seo_optimizer.php";
require "includes/internal_linking_engine.php";
require "includes/performance_optimizer.php";

echo "<h1>SEO Features Test - AloneDeals.com</h1>";
echo "<style>body{font-family:Arial;padding:20px;max-width:1200px;margin:0 auto;}h2{color:#6366f1;border-bottom:2px solid #e2e8f0;padding-bottom:10px;margin-top:30px;}.success{color:#10b981;}.error{color:#ef4444;}.info{background:#f1f5f9;padding:15px;border-radius:8px;margin:10px 0;}</style>";

// Test 1: Image SEO Optimizer
echo "<h2>1. Image SEO Optimizer Test</h2>";
try {
    $imageSEO = new ImageSEOOptimizer($connect);
    echo "<p class='success'>✅ ImageSEOOptimizer class loaded successfully</p>";
    
    // Test alt text generation
    $alt = $imageSEO->generateAltText('summer-sale.jpg', [
        'title' => 'Summer Sale 2025',
        'store' => 'Amazon',
        'category' => 'Electronics'
    ]);
    echo "<div class='info'><strong>Generated Alt Text:</strong><br>$alt</div>";
    
    // Test image optimization
    $testHtml = '<img src="test.jpg"><img src="test2.png">';
    $optimized = $imageSEO->optimizeContentImages($testHtml, ['title' => 'Test']);
    echo "<div class='info'><strong>Optimized HTML:</strong><br><pre>" . htmlspecialchars($optimized) . "</pre></div>";
    
} catch (Exception $e) {
    echo "<p class='error'>❌ Error: " . $e->getMessage() . "</p>";
}

// Test 2: Internal Linking Engine
echo "<h2>2. Internal Linking Engine Test</h2>";
try {
    $linkEngine = new InternalLinkingEngine($connect);
    echo "<p class='success'>✅ InternalLinkingEngine class loaded successfully</p>";
    
    // Test related content
    $related = $linkEngine->findRelatedContent(1, 'blog', 'deals coupons amazon', 3);
    echo "<div class='info'><strong>Found Related Content:</strong><br>";
    echo "Total: " . count($related) . " items<br>";
    foreach ($related as $item) {
        echo "- {$item['type']}: {$item['title']}<br>";
    }
    echo "</div>";
    
} catch (Exception $e) {
    echo "<p class='error'>❌ Error: " . $e->getMessage() . "</p>";
}


// Test 3: Performance Optimizer
echo "<h2>3. Performance Optimizer Test</h2>";
try {
    $perfOptimizer = new PerformanceOptimizer();
    echo "<p class='success'>✅ PerformanceOptimizer class loaded successfully</p>";
    
    // Test preconnect links
    $preconnect = $perfOptimizer->generatePreconnectLinks();
    echo "<div class='info'><strong>Preconnect Links Generated:</strong><br><pre>" . htmlspecialchars(substr($preconnect, 0, 300)) . "...</pre></div>";
    
    // Test resource hints
    $hints = $perfOptimizer->generateResourceHints([
        'preload' => [
            ['url' => '/assets/css/main.css', 'type' => 'style'],
            ['url' => '/assets/js/main.js', 'type' => 'script']
        ]
    ]);
    echo "<div class='info'><strong>Resource Hints Generated:</strong><br><pre>" . htmlspecialchars($hints) . "</pre></div>";
    
} catch (Exception $e) {
    echo "<p class='error'>❌ Error: " . $e->getMessage() . "</p>";
}

// Test 4: Database Connection
echo "<h2>4. Database Connection Test</h2>";
try {
    $stmt = $connect->query("SELECT COUNT(*) as total FROM blog_posts");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<p class='success'>✅ Database connected successfully</p>";
    echo "<div class='info'><strong>Blog Posts:</strong> {$result['total']}</div>";
    
    $stmt = $connect->query("SELECT COUNT(*) as total FROM stores");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<div class='info'><strong>Stores:</strong> {$result['total']}</div>";
    
    $stmt = $connect->query("SELECT COUNT(*) as total FROM coupons");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<div class='info'><strong>Coupons:</strong> {$result['total']}</div>";
    
} catch (Exception $e) {
    echo "<p class='error'>❌ Database Error: " . $e->getMessage() . "</p>";
}

// Summary
echo "<h2>✅ Integration Summary</h2>";
echo "<div class='info'>";
echo "<strong>All 3 SEO features are successfully integrated!</strong><br><br>";
echo "✅ Image SEO Optimizer - Active<br>";
echo "✅ Internal Linking Engine - Active<br>";
echo "✅ Performance Optimizer - Active<br><br>";
echo "<strong>Next Steps:</strong><br>";
echo "1. Add .htaccess rules from .htaccess_performance_rules.txt<br>";
echo "2. Visit a blog post to see features in action<br>";
echo "3. Check for 'Related Content' widget at bottom of pages<br>";
echo "4. Test page speed at https://pagespeed.web.dev/<br>";
echo "</div>";

echo "<h2>📚 Documentation</h2>";
echo "<div class='info'>";
echo "Read the complete guide: <strong>SEO_FEATURES_INTEGRATED.md</strong><br>";
echo "Technical details: <strong>FINAL_SEO_FEATURES.md</strong><br>";
echo "</div>";
?>
