<?php
/**
 * Test PHP Error Display
 * Access this file to verify errors are showing
 */

// Enable all errors
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

?>
<!DOCTYPE html>
<html>
<head>
    <title>PHP Error Test</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        .success { background: #d4edda; border: 1px solid #c3e6cb; padding: 15px; margin: 10px 0; border-radius: 5px; }
        .error { background: #f8d7da; border: 1px solid #f5c6cb; padding: 15px; margin: 10px 0; border-radius: 5px; }
        .info { background: #d1ecf1; border: 1px solid #bee5eb; padding: 15px; margin: 10px 0; border-radius: 5px; }
        code { background: #f4f4f4; padding: 2px 5px; border-radius: 3px; }
    </style>
</head>
<body>
    <h1>PHP Error Display Test</h1>
    
    <div class="success">
        <strong>✓ PHP is working!</strong><br>
        PHP Version: <?php echo phpversion(); ?><br>
        Error Reporting: <?php echo error_reporting(); ?><br>
        Display Errors: <?php echo ini_get('display_errors') ? 'ON' : 'OFF'; ?>
    </div>

    <div class="info">
        <strong>Testing Errors:</strong><br>
        Below you should see error messages if error display is enabled.
    </div>

    <h2>Test 1: Undefined Variable</h2>
    <?php
    // This should trigger a notice
    echo "Value: " . $undefined_variable . "<br>";
    ?>

    <h2>Test 2: User Warning</h2>
    <?php
    // This should trigger a warning
    trigger_error("This is a test warning", E_USER_WARNING);
    ?>

    <h2>Test 3: User Notice</h2>
    <?php
    // This should trigger a notice
    trigger_error("This is a test notice", E_USER_NOTICE);
    ?>

    <h2>Test 4: Division by Zero</h2>
    <?php
    // This should trigger a warning
    $result = 10 / 0;
    echo "Result: $result<br>";
    ?>

    <div class="info">
        <strong>If you see error messages above, error display is working!</strong><br>
        If you don't see any errors, error display is disabled.
    </div>

    <h2>PHP Configuration</h2>
    <table border="1" cellpadding="10" style="border-collapse: collapse;">
        <tr>
            <th>Setting</th>
            <th>Value</th>
        </tr>
        <tr>
            <td>display_errors</td>
            <td><?php echo ini_get('display_errors') ? 'ON' : 'OFF'; ?></td>
        </tr>
        <tr>
            <td>display_startup_errors</td>
            <td><?php echo ini_get('display_startup_errors') ? 'ON' : 'OFF'; ?></td>
        </tr>
        <tr>
            <td>error_reporting</td>
            <td><?php echo error_reporting(); ?></td>
        </tr>
        <tr>
            <td>log_errors</td>
            <td><?php echo ini_get('log_errors') ? 'ON' : 'OFF'; ?></td>
        </tr>
        <tr>
            <td>error_log</td>
            <td><?php echo ini_get('error_log') ?: 'Not set'; ?></td>
        </tr>
    </table>

    <p><a href="index.php">← Back to Homepage</a></p>
</body>
</html>
