<?php
/**
 * Static Sitemap Generator
 * Run this script manually to generate sitemap.xml file
 * Usage: php generate_sitemap.php or visit in browser
 */

// Disable all error output
error_reporting(0);
ini_set('display_errors', 0);

// Start output buffering to catch any errors
ob_start();

try {
    require './core.php';
    $connect = connect($database);
    
    // Start building XML
    $xml = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
    $xml .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"' . "\n";
    $xml .= '        xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">' . "\n\n";
    
    // Homepage
    $xml .= "    <url>\n";
    $xml .= "        <loc>" . SITE_URL . "</loc>\n";
    $xml .= "        <lastmod>" . date('Y-m-d') . "</lastmod>\n";
    $xml .= "        <changefreq>daily</changefreq>\n";
    $xml .= "        <priority>1.0</priority>\n";
    $xml .= "    </url>\n\n";
    
    // Static pages
    $staticPages = ['stores', 'categories'];
    foreach ($staticPages as $page) {
        $xml .= "    <url>\n";
        $xml .= "        <loc>" . SITE_URL . "/$page</loc>\n";
        $xml .= "        <lastmod>" . date('Y-m-d') . "</lastmod>\n";
        $xml .= "        <changefreq>weekly</changefreq>\n";
        $xml .= "        <priority>0.9</priority>\n";
        $xml .= "    </url>\n\n";
    }
    
    // Stores
    $storesQuery = "SELECT store_slug FROM stores WHERE store_status = 1 ORDER BY store_id DESC LIMIT 1000";
    $stores = $connect->query($storesQuery)->fetchAll();
    
    foreach ($stores as $store) {
        $xml .= "    <url>\n";
        $xml .= "        <loc>" . SITE_URL . "/store/" . htmlspecialchars($store['store_slug']) . "</loc>\n";
        $xml .= "        <lastmod>" . date('Y-m-d') . "</lastmod>\n";
        $xml .= "        <changefreq>weekly</changefreq>\n";
        $xml .= "        <priority>0.8</priority>\n";
        $xml .= "    </url>\n";
    }
    
    // Categories
    $categoriesQuery = "SELECT category_slug FROM categories WHERE category_status = 1 ORDER BY category_id DESC";
    $categories = $connect->query($categoriesQuery)->fetchAll();
    
    foreach ($categories as $category) {
        $xml .= "    <url>\n";
        $xml .= "        <loc>" . SITE_URL . "/category/" . htmlspecialchars($category['category_slug']) . "</loc>\n";
        $xml .= "        <lastmod>" . date('Y-m-d') . "</lastmod>\n";
        $xml .= "        <changefreq>weekly</changefreq>\n";
        $xml .= "        <priority>0.7</priority>\n";
        $xml .= "    </url>\n";
    }
    
    $xml .= "</urlset>";
    
    // Clear any error output
    ob_end_clean();
    
    // Write to file
    file_put_contents('sitemap.xml', $xml);
    
    echo "✓ Sitemap generated successfully!\n";
    echo "✓ Total URLs: " . (count($stores) + count($categories) + count($staticPages) + 1) . "\n";
    echo "✓ File: sitemap.xml\n";
    echo "✓ Size: " . number_format(strlen($xml)) . " bytes\n\n";
    echo "<a href='sitemap.xml' target='_blank'>View Sitemap</a>\n";
    
} catch (Exception $e) {
    ob_end_clean();
    echo "✗ Error: " . $e->getMessage();
}
?>
