<?php
/**
 * Store Products Section
 * Displays affiliate products for a specific store or category
 */

if (!isset($storeProducts) || empty($storeProducts)) {
    return; // Don't show section if no products
}

// Determine context (store or category)
$contextTitle = isset($itemDetails['store_title']) ? $itemDetails['store_title'] : $itemDetails['category_title'];
?>

<section class="products-section">
    <div class="uk-container">
        <div class="products-section-header">
            <h2 class="products-section-title">
                <i class="ti ti-shopping-bag"></i>
                Recommended Products from <?php echo htmlspecialchars($contextTitle); ?>
            </h2>
        </div>

        <div class="products-grid">
            <?php foreach ($storeProducts as $product): ?>
            <div class="product-card">
                <!-- Discount Badge -->
                <?php if ($product['product_discount_percentage']): ?>
                <div class="product-badge">
                    <?php echo $product['product_discount_percentage']; ?>% OFF
                </div>
                <?php endif; ?>

                <!-- Product Image -->
                <div class="product-image-wrapper">
                    <img src="<?php echo getImageUrl($product['product_image_cdn_url'], $product['product_use_cdn'], $product['product_image']); ?>" 
                         alt="<?php echo htmlspecialchars($product['product_title']); ?>"
                         class="product-image"
                         loading="lazy">
                </div>

                <!-- Product Content -->
                <div class="product-content">
                    <?php if ($product['store_title']): ?>
                    <div class="product-brand"><?php echo htmlspecialchars($product['store_title']); ?></div>
                    <?php endif; ?>

                    <h3 class="product-title"><?php echo htmlspecialchars($product['product_title']); ?></h3>

                    <div class="product-pricing">
                        <div class="product-price-row">
                            <?php if ($product['product_sale_price']): ?>
                            <span class="product-sale-price">₹<?php echo number_format($product['product_sale_price'], 0); ?></span>
                            <?php endif; ?>
                            
                            <?php if ($product['product_original_price'] && $product['product_original_price'] > $product['product_sale_price']): ?>
                            <span class="product-original-price">₹<?php echo number_format($product['product_original_price'], 0); ?></span>
                            <?php endif; ?>
                            
                            <?php if ($product['product_discount_percentage']): ?>
                            <span class="product-discount">(<?php echo $product['product_discount_percentage']; ?>% off)</span>
                            <?php endif; ?>
                        </div>

                        <?php if ($product['product_cashback']): ?>
                        <div class="product-cashback">
                            <i class="ti ti-coin"></i> <?php echo htmlspecialchars($product['product_cashback']); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Buy Button -->
                <div class="product-footer">
                    <a href="<?php echo htmlspecialchars($product['product_affiliate_link']); ?>" 
                       target="_blank" 
                       rel="nofollow noopener"
                       class="product-buy-btn">
                        <i class="ti ti-tag"></i>
                        Get Deal
                    </a>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
