<?php if(!empty($sidebarCampaigns)): ?>
<div class="widget">
    <h4 class="widget_heading">Featured Offers</h4>
    <div class="sidebar-campaigns">
        <?php foreach ($sidebarCampaigns as $campaign): ?>
        <div class="sidebar-campaign-item">
            <a href="<?php echo $campaign['campaign_link'] ? htmlspecialchars($campaign['campaign_link']) : '#'; ?>" 
               class="sidebar-campaign-link"
               <?php if ($campaign['campaign_link']): ?>target="_blank" rel="noopener"<?php endif; ?>>
                <div class="uk-card">
                    <img class="campaign-card-logo" 
                         src="<?php echo getImageUrl($campaign['campaign_image_cdn_url'], $campaign['campaign_use_cdn'], $campaign['campaign_image']); ?>" 
                         alt="<?php echo htmlspecialchars($campaign['campaign_title']); ?>"
                         loading="lazy">
                    <?php if ($campaign['campaign_title']): ?>
                    <h4 class="campaign-card-title"><?php echo htmlspecialchars($campaign['campaign_title']); ?></h4>
                    <?php endif; ?>
                </div>
            </a>
        </div>
        <?php endforeach; ?>
    </div>
</div>
<?php endif; ?>
