<?php
/**
 * Debug Edit Store - Find 500 Error
 * 
 * This script will help identify what's causing the 500 error
 * when editing stores.
 */

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

echo "<h1>Debug Edit Store</h1>";
echo "<pre>";

// Check if we can access the file
$edit_store_file = 'admin/controller/edit_store.php';
if (file_exists($edit_store_file)) {
    echo "✓ edit_store.php exists\n\n";
    
    // Check for syntax errors
    $output = [];
    $return_var = 0;
    exec("php -l $edit_store_file 2>&1", $output, $return_var);
    
    if ($return_var === 0) {
        echo "✓ No syntax errors in edit_store.php\n\n";
    } else {
        echo "✗ SYNTAX ERROR in edit_store.php:\n";
        echo implode("\n", $output) . "\n\n";
    }
} else {
    echo "✗ edit_store.php NOT FOUND\n\n";
}

// Check config
if (file_exists('config.php')) {
    echo "✓ config.php exists\n";
    require 'config.php';
    echo "✓ config.php loaded successfully\n\n";
} else {
    echo "✗ config.php NOT FOUND\n\n";
}

// Check database connection
try {
    require 'admin/functions.php';
    $connect = connect($database);
    echo "✓ Database connection successful\n\n";
} catch (Exception $e) {
    echo "✗ Database connection failed: " . $e->getMessage() . "\n\n";
}

// Check if store ID is provided
if (isset($_GET['id'])) {
    $store_id = $_GET['id'];
    echo "Store ID: $store_id\n\n";
    
    // Try to fetch store
    try {
        $stmt = $connect->prepare("SELECT * FROM stores WHERE store_id = :id");
        $stmt->execute([':id' => $store_id]);
        $store = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($store) {
            echo "✓ Store found:\n";
            echo "  - Title: " . $store['store_title'] . "\n";
            echo "  - Slug: " . $store['store_slug'] . "\n";
            echo "  - Status: " . $store['store_status'] . "\n\n";
        } else {
            echo "✗ Store not found with ID: $store_id\n\n";
        }
    } catch (Exception $e) {
        echo "✗ Error fetching store: " . $e->getMessage() . "\n\n";
    }
} else {
    echo "No store ID provided. Add ?id=STORE_ID to URL\n\n";
}

// Check error log
$error_log = 'error_log';
if (file_exists($error_log)) {
    echo "Recent errors from error_log:\n";
    echo "---\n";
    $lines = file($error_log);
    $recent_lines = array_slice($lines, -20); // Last 20 lines
    echo implode("", $recent_lines);
    echo "---\n\n";
} else {
    echo "No error_log file found\n\n";
}

echo "</pre>";

echo "<h2>Next Steps:</h2>";
echo "<ol>";
echo "<li>If you see syntax errors above, those need to be fixed</li>";
echo "<li>If database connection failed, check config.php</li>";
echo "<li>If store not found, check the store ID</li>";
echo "<li>Check the error_log output above for PHP errors</li>";
echo "<li>Try accessing: <a href='admin/controller/edit_store.php?id=1'>admin/controller/edit_store.php?id=1</a></li>";
echo "</ol>";
?>
