<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Check Functions Files</h1>";

echo "<h2>1. Root functions.php</h2>";
if (file_exists('functions.php')) {
    $content = file_get_contents('functions.php');
    $lines = explode("\n", $content);
    
    echo "<p>File exists: ✓</p>";
    echo "<p>File size: " . strlen($content) . " bytes</p>";
    echo "<p>First 20 lines:</p>";
    echo "<pre>";
    for ($i = 0; $i < min(20, count($lines)); $i++) {
        echo ($i + 1) . ": " . htmlspecialchars($lines[$i]) . "\n";
    }
    echo "</pre>";
    
    // Check if it has admin-specific content
    if (strpos($content, "require_once __DIR__ . '/lang/languages.php'") !== false) {
        echo "<p style='color:red;'><strong>ERROR: Root functions.php contains ADMIN functions!</strong></p>";
        echo "<p>You uploaded the wrong file. This should be admin/functions.php, not root functions.php</p>";
    } else {
        echo "<p style='color:green;'>✓ Root functions.php looks correct</p>";
    }
} else {
    echo "<p style='color:red;'>✗ functions.php NOT FOUND</p>";
}

echo "<hr><h2>2. Admin functions.php</h2>";
if (file_exists('admin/functions.php')) {
    $content = file_get_contents('admin/functions.php');
    $lines = explode("\n", $content);
    
    echo "<p>File exists: ✓</p>";
    echo "<p>File size: " . strlen($content) . " bytes</p>";
    echo "<p>First 20 lines:</p>";
    echo "<pre>";
    for ($i = 0; $i < min(20, count($lines)); $i++) {
        echo ($i + 1) . ": " . htmlspecialchars($lines[$i]) . "\n";
    }
    echo "</pre>";
    
    // Check if it has getProductById
    if (strpos($content, "function getProductById") !== false) {
        echo "<p style='color:green;'>✓ Has getProductById function</p>";
    } else {
        echo "<p style='color:red;'>✗ Missing getProductById function</p>";
    }
} else {
    echo "<p style='color:red;'>✗ admin/functions.php NOT FOUND</p>";
}

echo "<hr><h2>3. Solution</h2>";
echo "<p>If root functions.php has admin content:</p>";
echo "<ol>";
echo "<li>Download the CORRECT root functions.php from your backup or localhost</li>";
echo "<li>Upload it to the ROOT folder (overwrite the wrong one)</li>";
echo "<li>Make sure admin/functions.php is in the ADMIN folder</li>";
echo "</ol>";
?>
