// Scroll to Top Button - Simple jQuery Version
jQuery(document).ready(function($) {
    
    // Add scroll to top button to body
    $('body').append('<button id="scrollToTop" title="Scroll to top"><i class="ti ti-arrow-up"></i></button>');
    
    var scrollBtn = $('#scrollToTop');
    
    // Show/hide on scroll
    $(window).scroll(function() {
        if ($(this).scrollTop() > 300) {
            scrollBtn.fadeIn();
        } else {
            scrollBtn.fadeOut();
        }
    });
    
    // Click to scroll to top
    scrollBtn.click(function() {
        $('html, body').animate({scrollTop: 0}, 600);
        return false;
    });
    
});
