<?php require 'sidebar.php'; ?>

<section class="page-container">
  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        
        <div class="section-title">
          <h5>Firebase Authentication Configuration</h5>
        </div>

        <div class="row">
          <div class="col-12">
            <div class="form-block mb-4">

              <?php if (isset($_SESSION['firebase_success'])): ?>
              <div class="alert alert-success alert-dismissible fade show">
                  <?php echo $_SESSION['firebase_success']; unset($_SESSION['firebase_success']); ?>
                  <button type="button" class="close" data-dismiss="alert">&times;</button>
              </div>
              <?php endif; ?>

              <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
                
                <link rel="stylesheet" href="../assets/css/firebase-auth.css">
                
                <div class="form-row">
                  <div class="form-group col-md-12">
                    <h6 class="mb-3">Firebase Configuration</h6>
                    <p class="text-muted">Get these values from Firebase Console → Project Settings → General</p>
                  </div>
                </div>

                <div class="form-row">
                  <div class="form-group col-md-6">
                    <label>API Key</label>
                    <input type="text" name="config_api_key" class="form-control" 
                           value="<?php echo htmlspecialchars($firebaseConfig['config_api_key'] ?? ''); ?>" 
                           placeholder="AIzaSy...">
                  </div>
                  <div class="form-group col-md-6">
                    <label>Auth Domain</label>
                    <input type="text" name="config_auth_domain" class="form-control" 
                           value="<?php echo htmlspecialchars($firebaseConfig['config_auth_domain'] ?? ''); ?>" 
                           placeholder="your-app.firebaseapp.com">
                  </div>
                </div>

                <div class="form-row">
                  <div class="form-group col-md-6">
                    <label>Project ID</label>
                    <input type="text" name="config_project_id" class="form-control" 
                           value="<?php echo htmlspecialchars($firebaseConfig['config_project_id'] ?? ''); ?>" 
                           placeholder="your-project-id">
                  </div>
                  <div class="form-group col-md-6">
                    <label>Storage Bucket</label>
                    <input type="text" name="config_storage_bucket" class="form-control" 
                           value="<?php echo htmlspecialchars($firebaseConfig['config_storage_bucket'] ?? ''); ?>" 
                           placeholder="your-app.appspot.com">
                  </div>
                </div>

                <div class="form-row">
                  <div class="form-group col-md-4">
                    <label>Messaging Sender ID</label>
                    <input type="text" name="config_messaging_sender_id" class="form-control" 
                           value="<?php echo htmlspecialchars($firebaseConfig['config_messaging_sender_id'] ?? ''); ?>" 
                           placeholder="123456789">
                  </div>
                  <div class="form-group col-md-4">
                    <label>App ID</label>
                    <input type="text" name="config_app_id" class="form-control" 
                           value="<?php echo htmlspecialchars($firebaseConfig['config_app_id'] ?? ''); ?>" 
                           placeholder="1:123:web:abc">
                  </div>
                  <div class="form-group col-md-4">
                    <label>Measurement ID (Optional)</label>
                    <input type="text" name="config_measurement_id" class="form-control" 
                           value="<?php echo htmlspecialchars($firebaseConfig['config_measurement_id'] ?? ''); ?>" 
                           placeholder="G-XXXXXXXXXX">
                  </div>
                </div>

                <div class="form-row">
                  <div class="form-group col-md-12">
                    <div class="custom-control custom-checkbox">
                      <input type="checkbox" class="custom-control-input" id="config_enabled" name="config_enabled" 
                             <?php echo ($firebaseConfig['config_enabled'] ?? 0) ? 'checked' : ''; ?>>
                      <label class="custom-control-label" for="config_enabled">Enable Firebase Authentication</label>
                    </div>
                  </div>
                </div>

                <hr class="my-4">

                <div class="form-row">
                  <div class="form-group col-md-12">
                    <h6 class="mb-3">Authentication Methods</h6>
                    <p class="text-muted">Enable the login methods you want to use</p>
                  </div>
                </div>

                <div class="form-row">
                  <div class="form-group col-md-4">
                    <div class="auth-method-card <?php echo ($settings['st_mobile_otp_login'] ?? 1) ? 'active' : ''; ?>" onclick="toggleSwitch('st_mobile_otp_login')">
                      <div class="auth-method-icon">
                        <i class="fa fa-mobile text-primary"></i>
                      </div>
                      <div class="auth-method-title">Mobile OTP Login</div>
                      <div class="auth-method-description">Phone number + OTP verification</div>
                      <label class="custom-switch">
                        <input type="checkbox" id="st_mobile_otp_login" name="st_mobile_otp_login" 
                               <?php echo ($settings['st_mobile_otp_login'] ?? 1) ? 'checked' : ''; ?>>
                        <span class="switch-slider"></span>
                      </label>
                      <span class="switch-label <?php echo ($settings['st_mobile_otp_login'] ?? 1) ? 'active' : ''; ?>" id="label_st_mobile_otp_login">
                        <?php echo ($settings['st_mobile_otp_login'] ?? 1) ? 'Enabled' : 'Disabled'; ?>
                      </span>
                    </div>
                  </div>
                  
                  <div class="form-group col-md-4">
                    <div class="auth-method-card <?php echo ($settings['st_google_login'] ?? 0) ? 'active' : ''; ?>" onclick="toggleSwitch('st_google_login')">
                      <div class="auth-method-icon">
                        <i class="fa fa-google text-danger"></i>
                      </div>
                      <div class="auth-method-title">Google Sign-In</div>
                      <div class="auth-method-description">Sign in with Google account</div>
                      <label class="custom-switch">
                        <input type="checkbox" id="st_google_login" name="st_google_login" 
                               <?php echo ($settings['st_google_login'] ?? 0) ? 'checked' : ''; ?>>
                        <span class="switch-slider"></span>
                      </label>
                      <span class="switch-label <?php echo ($settings['st_google_login'] ?? 0) ? 'active' : ''; ?>" id="label_st_google_login">
                        <?php echo ($settings['st_google_login'] ?? 0) ? 'Enabled' : 'Disabled'; ?>
                      </span>
                    </div>
                  </div>
                  
                  <div class="form-group col-md-4">
                    <div class="auth-method-card <?php echo ($settings['st_facebook_login'] ?? 0) ? 'active' : ''; ?>" onclick="toggleSwitch('st_facebook_login')">
                      <div class="auth-method-icon">
                        <i class="fa fa-facebook text-primary"></i>
                      </div>
                      <div class="auth-method-title">Facebook Login</div>
                      <div class="auth-method-description">Sign in with Facebook account</div>
                      <label class="custom-switch">
                        <input type="checkbox" id="st_facebook_login" name="st_facebook_login" 
                               <?php echo ($settings['st_facebook_login'] ?? 0) ? 'checked' : ''; ?>>
                        <span class="switch-slider"></span>
                      </label>
                      <span class="switch-label <?php echo ($settings['st_facebook_login'] ?? 0) ? 'active' : ''; ?>" id="label_st_facebook_login">
                        <?php echo ($settings['st_facebook_login'] ?? 0) ? 'Enabled' : 'Disabled'; ?>
                      </span>
                    </div>
                  </div>
                </div>

                <script>
                function toggleSwitch(id) {
                  var checkbox = document.getElementById(id);
                  var card = checkbox.closest('.auth-method-card');
                  var label = document.getElementById('label_' + id);
                  
                  checkbox.checked = !checkbox.checked;
                  
                  if (checkbox.checked) {
                    card.classList.add('active');
                    label.classList.add('active');
                    label.textContent = 'Enabled';
                  } else {
                    card.classList.remove('active');
                    label.classList.remove('active');
                    label.textContent = 'Disabled';
                  }
                }
                </script>

                <div class="alert alert-warning">
                  <strong><i class="fa fa-exclamation-triangle"></i> Important:</strong> 
                  Before enabling Google or Facebook login, make sure you've enabled these authentication methods in your 
                  <a href="https://console.firebase.google.com/" target="_blank">Firebase Console</a> under Authentication → Sign-in method.
                </div>

                <div class="form-row">
                  <div class="form-group col-md-12">
                    <button type="submit" class="btn btn-primary">
                      <i class="fa fa-save"></i> Save Configuration
                    </button>
                  </div>
                </div>

              </form>

              <div class="alert alert-info mt-4">
                <h6>Setup Instructions:</h6>
                <ol class="mb-0">
                  <li>Go to <a href="https://console.firebase.google.com/" target="_blank">Firebase Console</a></li>
                  <li>Create a new project or select existing</li>
                  <li>Enable Authentication → Phone, Google, Facebook</li>
                  <li>Copy config values from Project Settings</li>
                  <li>Paste values above and save</li>
                </ol>
              </div>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
