<?php require 'sidebar.php'; ?>  

<script type="text/javascript">
  $(document).ready(function(){
    $('#table_id').dataTable({
     "bProcessing": true,
     "sAjaxSource": "../controller/get_coupons.php",
     "responsive": true,
     "bPaginate":true,
     "aaSorting": [[1,'desc']],
     "sPaginationType":"full_numbers",
     "iDisplayLength": 10,
     "aoColumns": [
     { mData: 'coupon_id', "width": "4%", "className": "text-center" },
     { "mData": null , "width": "10%", "className": "product text-center",
     "mRender" : function (data) {
      if(data.coupon_image){
        return "<img src='"+IMAGES_FOLDER+data.coupon_image+"' class='product-img product-img-horizontal'/>";
      }else{
        return "<img src='../assets/images/no-image.png' class='product-img product-img-horizontal'/>";
      }
    }
    },
    { mData: 'coupon_title', "width": "18%" },
    { "mData": null, "width": "12%",
     "mRender" : function (data) {
      if (data.store_title) {
        return '<span class="badge badge-primary" style="font-size: 11px; padding: 6px 10px;">' + data.store_title + '</span>';
      } else {
        return '<span class="text-muted" style="font-size: 11px;">No store</span>';
      }
     }
    },
    { mData: 'category_title', "width": "10%" },
    { mData: 'coupon_code', "width": "8%", "className": "text-center" },
    { "mData": null , "width": "6%", "className":"status text-center",
     "mRender" : function (data) {
      if (data.coupon_featured == 1) {
        return '<span class="badge badge-pill bg-success"><i class="dripicons-checkmark"></i></span>';
      }else{
        return '<span class="badge badge-pill bg-warning"><i class="dripicons-cross"></i></span>';
        }
      }
    },
    { "mData": null , "width": "6%", "className":"status text-center",
     "mRender" : function (data) {
      if (data.coupon_verify == 1) {
        return '<span class="badge badge-pill bg-success"><i class="dripicons-checkmark"></i></span>';
      }else{
        return '<span class="badge badge-pill bg-warning"><i class="dripicons-cross"></i></span>';
        }
      }
    },
    { "mData": null , "width": "6%", "className":"status text-center",
     "mRender" : function (data) {
      if (data.coupon_status == 1) {
        return '<span class="label badge-pill bg-success"><?php echo _ENABLED; ?></span>';
      }else if (data.coupon_status == 2) {
        return '<span class="label badge-pill bg-danger"><?php echo _DISABLED; ?></span>';
      }else if (data.coupon_status == 3) {
        return '<span class="label badge-pill bg-warning"><?php echo _PENDING; ?></span>';
      }
      }
    },
    { "mData": null ,
    "width": "12%",
    "className": "text-center",
    'orderable': false,
    'searchable': false,
    "mRender" : function (data) {
      return "<a class='btn btn-small btn-primary' href='../controller/edit_coupon.php?id="+data.coupon_id+"'>"+EDITITEM+"</a> <a class='btn btn-small btn-danger btn-delete deleteItem' data-url='../controller/delete_coupon.php?id="+data.coupon_id+"'>"+DELETEITEM+"</a>";}
    }
    ]
  });
  });
</script>

<!--Page Container-->
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="section-title">
          <h5 class="text-truncate"><?php echo _COUPONS; ?></h5>
        </div>

        <div class="row">

          <div class="col-12 c-col-12">
            <a class="btn btn-primary" href="../controller/new_coupon.php">
              <i class="fa fa-plus add-new-i"></i> <?php echo _ADDITEM; ?>
            </a>
            <button class="btn btn-success" data-toggle="modal" data-target="#importExportModal" style="margin-left: 10px;">
              <i class="ti ti-file-import"></i> Import / Export
            </button>
          </div>

          <div class="col-12">
            <div class="block table-block mb-4 c-4">

              <div class="row">
                <div class="table-responsive">
                  <table id="table_id" class="table table-striped table-bordered" cellspacing="0" width="100%" style="border-radius: 5px;">
                    <thead>
                      <tr>
                        <th><?php echo _TABLEFIELDID; ?></th>
                        <th><?php echo _TABLEFIELDIMAGE; ?></th>
                        <th><?php echo _TABLEFIELDTITLE; ?></th>
                        <th>Store</th>
                        <th><?php echo _TABLEFIELDCATEGORY; ?></th>
                        <th><?php echo _TABLEFIELDCODE; ?></th>
                        <th><?php echo _TABLEFIELDFEATURED; ?></th>
                        <th><?php echo _TABLEFIELDVERIFY; ?></th>
                        <th><?php echo _TABLEFIELDSTATUS; ?></th>
                        <th><?php echo _TABLEFIELDACTIONS; ?></th>
                      </tr>
                    </thead>
                  </table>

                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


<!-- Import/Export Modal -->
<div class="modal fade" id="importExportModal" tabindex="-1" role="dialog" aria-labelledby="importExportModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="importExportModalLabel"><i class="ti ti-file-import"></i> Import / Export Coupons</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-6">
            <div class="card">
              <div class="card-body">
                <h5 class="card-title"><i class="ti ti-download"></i> Export Coupons</h5>
                <p class="card-text">Download all coupons as CSV file.</p>
                <a href="../controller/import_export.php?action=export_coupons" class="btn btn-primary">
                  <i class="ti ti-download"></i> Export Coupons CSV
                </a>
              </div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="card">
              <div class="card-body">
                <h5 class="card-title"><i class="ti ti-upload"></i> Import Coupons</h5>
                <p class="card-text">Upload CSV file to import coupons. Stores will be auto-created.</p>
                <form method="post" action="../controller/import_export.php?action=import_coupons" enctype="multipart/form-data">
                  <div class="form-group">
                    <input type="file" name="csv_file" class="form-control-file" accept=".csv" required>
                    <small class="form-text text-muted">
                      <strong>Format:</strong> Title, Merchant, Description, Coupon Code, URL, Start Date, End Date
                    </small>
                  </div>
                  <button type="submit" class="btn btn-primary">
                    <i class="ti ti-upload"></i> Import Coupons
                  </button>
                </form>
              </div>
            </div>
          </div>
        </div>
        <div class="row mt-3">
          <div class="col-12">
            <div class="alert alert-info">
              <h6>Import Notes:</h6>
              <ul class="mb-0">
                <li>Stores will be automatically created if they don't exist</li>
                <li>Date format: DD-MM-YYYY (e.g., 20-05-2025)</li>
                <li>Categories and images will be set to default</li>
              </ul>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

