<?php require'sidebar.php'; ?>

<section class="page-container">
<div class="page-content-wrapper">

<div class="content sm-gutter">
<div class="container-fluid padding-25 sm-padding-10">

<div class="row">
<div class="col-12">
<div class="section-title d-flex justify-content-between align-items-center">
  <h5><i class="fas fa-ban"></i> Banned IP Addresses</h5>
  <a href="./ban_ip.php" class="btn btn-danger">Ban New IP</a>
</div>
</div>
</div>

<?php if(isset($_GET['success'])): ?>
<div class="alert alert-success alert-dismissible fade show">
<button type="button" class="close" data-dismiss="alert">&times;</button>
<?php if($_GET['success'] == 'banned'): ?>
IP address has been banned successfully.
<?php elseif($_GET['success'] == 'unbanned'): ?>
IP address has been unbanned successfully.
<?php endif; ?>
</div>
<?php endif; ?>

<div class="row">
<div class="col-md-12">
<div class="card">
<div class="card-body">
<div class="table-responsive">
<table class="table table-hover">
<thead>
<tr>
<th>IP Address</th>
<th>Reason</th>
<th>Ban Type</th>
<th>Expires At</th>
<th>Banned By</th>
<th>Banned At</th>
<th>Actions</th>
</tr>
</thead>
<tbody>
<?php foreach($banned_ips as $ban): ?>
<tr>
<td><code><?php echo htmlspecialchars($ban['ip_address']); ?></code></td>
<td><?php echo htmlspecialchars($ban['reason'] ?? 'No reason provided'); ?></td>
<td>
<?php if($ban['is_permanent']): ?>
<span class="badge badge-danger">Permanent</span>
<?php else: ?>
<span class="badge badge-warning">Temporary</span>
<?php endif; ?>
</td>
<td>
<?php if($ban['is_permanent']): ?>
Never
<?php elseif($ban['expires_at']): ?>
<?php echo date('M d, Y H:i', strtotime($ban['expires_at'])); ?>
<?php else: ?>
-
<?php endif; ?>
</td>
<td><?php echo htmlspecialchars($ban['banned_by_name'] ?? 'System'); ?></td>
<td><?php echo date('M d, Y H:i', strtotime($ban['banned_at'])); ?></td>
<td>
<a href="?unban=<?php echo $ban['ban_id']; ?>" class="btn btn-success btn-sm" onclick="return confirm('Unban this IP address?')">Unban</a>
</td>
</tr>
<?php endforeach; ?>
<?php if(empty($banned_ips)): ?>
<tr><td colspan="7" class="text-center">No banned IP addresses</td></tr>
<?php endif; ?>
</tbody>
</table>
</div>
</div>
</div>
</div>
</div>

</div>
</div>

</section>
