<?php
// Suppress deprecation warnings
error_reporting(E_ALL & ~E_DEPRECATED & ~E_STRICT);

session_start();

require '../../config.php';
require '../admin_config.php';
require '../functions.php';
require '../../includes/advanced_seo_system.php';
require '../views/header.view.php';

if (isset($_SESSION['user_email'])){

$connect = connect($database);
if(!$connect){
    header('Location: ./error.php');
}

$check_access = check_access($connect);

if ($check_access['user_role'] == 1){
    
    // Initialize SEO System
    $seo = new AdvancedSEOSystem($connect, SITE_URL);
    
    // Handle content analysis
    $analysis = null;
    $selectedType = '';
    $selectedId = '';
    
    if (isset($_POST['analyze'])) {
        $contentType = $_POST['content_type'];
        $contentId = $_POST['content_id'];
        $targetKeyword = $_POST['target_keyword'] ?? '';
        
        $selectedType = $contentType;
        $selectedId = $contentId;
        
        // Get content based on type
        if ($contentType == 'blog') {
            $stmt = $connect->prepare("SELECT post_title, post_content FROM blog_posts WHERE post_id = ?");
            $stmt->execute([$contentId]);
            $content = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($content) {
                $analysis = $seo->analyzeContent(
                    $content['post_title'],
                    $content['post_content'],
                    $targetKeyword
                );
            }
        } elseif ($contentType == 'page') {
            $stmt = $connect->prepare("SELECT page_title, page_content FROM pages WHERE page_id = ?");
            $stmt->execute([$contentId]);
            $content = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($content) {
                $analysis = $seo->analyzeContent(
                    $content['page_title'],
                    $content['page_content'],
                    $targetKeyword
                );
            }
        } elseif ($contentType == 'coupon') {
            $stmt = $connect->prepare("SELECT coupon_title, coupon_description FROM coupons WHERE coupon_id = ?");
            $stmt->execute([$contentId]);
            $content = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($content) {
                $analysis = $seo->analyzeContent(
                    $content['coupon_title'],
                    $content['coupon_description'],
                    $targetKeyword
                );
            }
        }
    }
    
    // Get all blog posts
    $blogPosts = $connect->query("SELECT post_id, post_title FROM blog_posts ORDER BY created_at DESC LIMIT 50")->fetchAll(PDO::FETCH_ASSOC);
    
    // Get all pages
    $pages = $connect->query("SELECT page_id, page_title FROM pages ORDER BY page_title")->fetchAll(PDO::FETCH_ASSOC);
    
    // Get all coupons
    $coupons = $connect->query("SELECT coupon_id, coupon_title FROM coupons ORDER BY coupon_created DESC LIMIT 50")->fetchAll(PDO::FETCH_ASSOC);
    
    // Get overall site stats
    $siteStats = [
        'total_posts' => $connect->query("SELECT COUNT(*) FROM blog_posts")->fetchColumn(),
        'total_pages' => $connect->query("SELECT COUNT(*) FROM pages")->fetchColumn(),
        'total_coupons' => $connect->query("SELECT COUNT(*) FROM coupons")->fetchColumn(),
        'published_posts' => $connect->query("SELECT COUNT(*) FROM blog_posts WHERE post_status = 'published'")->fetchColumn()
    ];
    
    require '../views/seo_analyzer.view.php';
	
}else{
	header('Location:'.SITE_URL);
}

require '../views/footer.view.php';

}else{
	header('Location: ./login.php');	
}

?>
