<?php
session_start();
if (isset($_SESSION['user_email'])){

	require '../../config.php';
	require '../functions.php';

	$connect = connect($database);

	if (empty($_GET["id"])) {
		header('Location: ../products.php');
		exit;
	}

	$check_access = check_access($connect);

	if ($check_access['user_role'] == 1 || $check_access['user_role'] == 2){

		$product_id = (int)$_GET['id'];
		
		// Get product image before deleting
		$product = getProductById($connect, $product_id);
		
		// Delete from database
		$statement = $connect->prepare("DELETE FROM products WHERE product_id = :product_id");
		$statement->execute(array(':product_id' => $product_id));
		
		// Delete image file if exists
		if ($product && !empty($product['product_image'])) {
			$image_path = '../../images/' . $product['product_image'];
			if (file_exists($image_path)) {
				unlink($image_path);
			}
		}

		header('Location: ../products.php');
		exit;

	} else {
		header('Location:'.SITE_URL);
	}

} else {
	header('Location: ../login.php');		
}
?>
