# Affiliate Products Feature - Implementation Guide

## ✅ What's Been Created

### 1. Database
- **File:** `admin/sql/create_products_table.sql`
- **Action:** Run this SQL in your database to create the `products` table

### 2. Functions
- **File:** `functions.php` (appended)
- **Functions added:**
  - `getProductsByStore()` - Get products for a specific store
  - `getProductsByCategory()` - Get products for a category
  - `getFeaturedProducts()` - Get featured products
  - `getProductById()` - Get single product
  - `countProductsByStore()` - Count products

### 3. Frontend Display
- **File:** `sections/views/store-products.view.php`
- **File:** `assets/css/product-cards.css`
- Beautiful product cards with image, price, discount, cashback

## 🔧 What You Need to Do Next

### Step 1: Run the SQL
```sql
-- Run this in your database
admin/sql/create_products_table.sql
```

### Step 2: Add CSS to Header
In `views/includes/header-css.php`, add:
```html
<link rel="stylesheet" href="<?php echo getCssUrl('product-cards.css'); ?>?v=<?php echo time(); ?>">
```

### Step 3: Update Store Page
In `views/single-store.view.php`, add this AFTER the coupons section:

```php
<?php
// Get products for this store
$storeProducts = getProductsByStore($connect, $itemDetails['store_id'], 12);
if (!empty($storeProducts)) {
    require './sections/views/store-products.view.php';
}
?>
```

### Step 4: Create Admin Panel (I'll do this next)
You'll need:
- Products list page
- Add product page
- Edit product page
- Delete product functionality

## 📊 Database Structure

```
products table:
- product_id (Primary Key)
- product_title (Product name)
- product_description (Optional description)
- product_image (Local image)
- product_image_cdn_url (CDN URL - optional)
- product_use_cdn (Use CDN: 1/0)
- product_store (Store ID - required)
- product_category (Category ID - optional)
- product_affiliate_link (Buy link - required)
- product_original_price (MRP)
- product_sale_price (Selling price)
- product_discount_percentage (% off)
- product_cashback (e.g., "After Cashback of ₹47")
- product_featured (Show in featured: 1/0)
- product_status (Active: 1, Inactive: 0)
- product_order (Display order)
- product_created (Timestamp)
- product_updated (Timestamp)
```

## 🎨 How It Looks

Products will display in a grid below coupons on store pages:
- Product image (with CDN support)
- Brand name
- Product title (2 lines max)
- Original price (strikethrough)
- Sale price (large, bold)
- Discount percentage (green)
- Cashback info (blue badge)
- "Buy Now" button (gradient purple)

## 🔗 Features

✅ CDN image support (just like stores/campaigns)
✅ Store-specific products
✅ Category filtering
✅ Featured products
✅ Discount calculation
✅ Cashback display
✅ Responsive design
✅ Lazy loading images
✅ Affiliate link tracking (nofollow, noopener)

## 📱 Responsive

- Desktop: 4-5 products per row
- Tablet: 3 products per row
- Mobile: 2 products per row

## 🚀 Next Steps

1. Run the SQL to create the table
2. Add CSS to header
3. Update store page to show products
4. I'll create the admin panel for you to manage products

Want me to create the admin panel now?
