<?php include './sections/page-title.php'; ?>

<div class="uk-container">

<!-- All Stores Heading with Icon -->
<div class="uk-text-center uk-margin-large-top uk-margin-medium-bottom">
    <div style="display: inline-flex; align-items: center; gap: 12px; padding: 15px 30px; background: linear-gradient(135deg, #ed174f 0%, #ff4d7d 100%); border-radius: 50px; box-shadow: 0 4px 15px rgba(237, 23, 79, 0.3);">
        <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
            <polyline points="9 22 9 12 15 12 15 22"></polyline>
        </svg>
        <h1 style="margin: 0; color: white; font-size: 28px; font-weight: 700; letter-spacing: 0.5px;">All Stores</h1>
    </div>
</div>

<div uk-grid>

<div class="uk-width-1-1 uk-width-expand@m">

    <div class="uk-flex uk-flex-center uk-grid-small" uk-grid>
        <?php foreach ($arrayLetters as $char): ?>
            <a class="uk-link-text" href="#section-<?php echo echoOutput($char); ?>" uk-scroll><?php echo echoOutput($char); ?></a>
        <?php endforeach; ?>
            <a class="uk-link-text" href="#section-09" uk-scroll>0-9</a>
    </div>

    <div class="uk-margin-medium-top uk-margin-bottom">

        <?php foreach ($arrayLetters as $char): ?>
        <h3 class="uk-heading-line uk-text-bold uk-margin-large-top" id="section-<?php echo echoOutput($char); ?>"><span><?php echo echoOutput($char); ?></span></h3>

        <div class="uk-child-width-1-2 uk-child-width-1-3@s uk-child-width-1-4@m uk-child-width-1-5@l uk-grid-match uk-margin-medium-bottom" uk-grid="margin: uk-margin-medium">
            <?php $getStores = getStoresByLetter($connect, $char); ?>
            <?php foreach($getStores as $item): ?>
                
                <div>
                    <a href="<?php echo $urlPath->store($item['store_slug']); ?>" class="uk-link-reset">
                        <div class="store-card">
                            <img class="store-card-logo" src="<?php echo getImageUrl($item['store_image_cdn_url'], $item['store_use_cdn'], $item['store_image']); ?>" alt="<?php echo echoOutput($item['store_title']); ?>">
                            <h4 class="store-card-title"><?php echo echoOutput($item['store_title']); ?></h4>
                            <!-- Animated OPEN Sign with Count -->
                            <div class="store-open-sign">
                                <span class="store-open-sign-text"><?php echo (int)$item['coupon_count']; ?></span>
                            </div>
                        </div>
                    </a>
                </div>

            <?php endforeach; ?>
        </div>
    <?php endforeach; ?>

    <h3 class="uk-heading-line uk-text-bold uk-margin-large-top" id="section-09"><span>0-9</span></h3>
    <div class="uk-child-width-1-2 uk-child-width-1-3@s uk-child-width-1-4@m uk-child-width-1-5@l uk-grid-match uk-margin-medium-bottom" uk-grid="margin: uk-margin-medium">
            <?php $getStores = getStoresByLetter($connect); ?>
            <?php foreach($getStores as $item): ?>
                
                <div>
                    <a href="<?php echo $urlPath->store($item['store_slug']); ?>" class="uk-link-reset">
                        <div class="store-card">
                            <img class="store-card-logo" src="<?php echo getImageUrl($item['store_image_cdn_url'], $item['store_use_cdn'], $item['store_image']); ?>" alt="<?php echo echoOutput($item['store_title']); ?>">
                            <h4 class="store-card-title"><?php echo echoOutput($item['store_title']); ?></h4>
                            <!-- Animated OPEN Sign with Count -->
                            <div class="store-open-sign">
                                <span class="store-open-sign-text"><?php echo (int)$item['coupon_count']; ?></span>
                            </div>
                        </div>
                    </a>
                </div>

            <?php endforeach; ?>
        </div>
    </div>

    <div class="uk-position-fixed uk-position-bottom-right uk-padding">
    <a href="#" uk-totop uk-scroll></a>
    </div>

</div>

    <?php if (isset($itemDetails['page_ad_sidebar']) && $itemDetails['page_ad_sidebar'] == 1): ?>
<?php if(!empty($sidebarAd)): ?>
    <div class="uk-width-1-1 uk-width-1-4@m uk-text-center">
    <?php require './sections/views/sidebar-ad.view.php'; ?>
    </div>
<?php endif; ?>
<?php endif; ?>


</div>
</div>
