# PWA Icons Directory

This directory contains all the icons and images required for the Progressive Web App (PWA).

## Required Files:

### App Icons (Required)
- icon-72x72.png
- icon-96x96.png
- icon-128x128.png
- icon-144x144.png
- icon-152x152.png
- icon-192x192.png
- icon-384x384.png
- icon-512x512.png

### Badge Icon (Optional)
- badge-72x72.png

### Shortcut Icons (Optional)
- shortcut-stores.png (96x96)
- shortcut-coupons.png (96x96)

### Action Icons (Optional)
- action-view.png (96x96)
- action-close.png (96x96)

### Screenshots (Optional but Recommended)
- screenshot-mobile.png (540x720)
- screenshot-desktop.png (1280x720)

## How to Generate Icons:

1. **Use Online Tool (Easiest)**
   - Go to: https://www.pwabuilder.com/imageGenerator
   - Upload your logo (512x512px minimum)
   - Download generated icons
   - Extract and place in this folder

2. **Use Photoshop/GIMP**
   - Create square logo (512x512px)
   - Resize to each required size
   - Export as PNG with transparency

3. **Use ImageMagick (Command Line)**
   ```bash
   convert logo.png -resize 72x72 icon-72x72.png
   convert logo.png -resize 96x96 icon-96x96.png
   # ... and so on for each size
   ```

## Icon Guidelines:

- Use PNG format with transparency
- Square aspect ratio (1:1)
- Minimum 512x512px for source
- Simple, recognizable design
- Works well at small sizes
- Consistent with brand colors

## Testing:

After adding icons:
1. Clear browser cache
2. Reload your website
3. Check DevTools > Application > Manifest
4. Verify all icons load correctly
