<?php
/**
 * Clear Server Cache Script
 * Run this file once after uploading new CSS/JS files
 */

// Clear OPcache if available
if (function_exists('opcache_reset')) {
    opcache_reset();
    echo "✓ OPcache cleared<br>";
} else {
    echo "✗ OPcache not available<br>";
}

// Clear APCu cache if available
if (function_exists('apcu_clear_cache')) {
    apcu_clear_cache();
    echo "✓ APCu cache cleared<br>";
} else {
    echo "✗ APCu not available<br>";
}

// Clear file stat cache
clearstatcache(true);
echo "✓ File stat cache cleared<br>";

// Output cache busting timestamp
echo "<br><strong>Cache Busting Timestamp:</strong> " . time() . "<br>";
echo "<br><strong>Instructions:</strong><br>";
echo "1. Clear your browser cache (Ctrl+Shift+Delete)<br>";
echo "2. Hard refresh the page (Ctrl+F5 or Cmd+Shift+R)<br>";
echo "3. If using Cloudflare or CDN, purge cache there too<br>";
echo "<br><strong>Status:</strong> Cache clearing completed!<br>";
echo "<br><a href='index.php'>Go to Homepage</a>";
?>
