/**
 * Footer Categories Collapse/Expand Functionality
 */

document.addEventListener('DOMContentLoaded', function() {
    const categoryToggles = document.querySelectorAll('.footer-category-toggle');
    
    categoryToggles.forEach(toggle => {
        toggle.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            const categoryItem = this.closest('.footer-category-item');
            const subcategories = categoryItem.querySelector('.footer-subcategories');
            
            // Toggle active class on button
            this.classList.toggle('active');
            
            // Toggle active class on subcategories list
            if (subcategories) {
                subcategories.classList.toggle('active');
            }
        });
    });
});
