<?php 
// Get user information for sidebar
$user = get_user_information($connect);
$user = $user[0];

require 'sidebar.view.php'; 
?>

<style>
.modern-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 32px;
    border-radius: 12px;
    color: white;
    margin-bottom: 24px;
    box-shadow: 0 4px 16px rgba(102, 126, 234, 0.3);
}

.modern-header h1 {
    font-size: 28px;
    font-weight: 700;
    margin: 0 0 8px 0;
}

.modern-header p {
    margin: 0;
    opacity: 0.9;
    font-size: 14px;
}

.filter-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
    margin-bottom: 24px;
}

.filter-card h6 {
    font-weight: 700;
    color: #1f2937;
    margin-bottom: 16px;
    font-size: 16px;
}

.filter-group {
    margin-bottom: 16px;
}

.filter-group label {
    font-size: 13px;
    font-weight: 600;
    color: #6b7280;
    margin-bottom: 6px;
    display: block;
}

.filter-btn {
    width: 100%;
    padding: 10px;
    border-radius: 8px;
    border: 2px solid #e5e7eb;
    background: white;
    font-weight: 600;
    transition: all 0.2s;
    margin-bottom: 8px;
}

.filter-btn:hover {
    border-color: #667eea;
    background: #f0f1ff;
    color: #667eea;
}

.filter-btn.active {
    border-color: #667eea;
    background: #667eea;
    color: white;
}

.action-bar {
    background: white;
    border-radius: 12px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
    margin-bottom: 24px;
}

.table-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
}

.modern-table {
    border-radius: 8px;
    overflow: hidden;
}

.modern-table thead {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.modern-table thead th {
    border: none;
    padding: 16px 12px;
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.modern-table tbody td {
    padding: 16px 12px;
    vertical-align: middle;
    border-bottom: 1px solid #f3f4f6;
}

.modern-table tbody tr:hover {
    background: #f9fafb;
}

.store-img {
    width: 60px;
    height: 60px;
    object-fit: cover;
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.badge-modern {
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.btn-modern {
    padding: 8px 16px;
    border-radius: 8px;
    font-weight: 600;
    font-size: 13px;
    transition: all 0.2s;
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

.stats-mini {
    display: flex;
    gap: 16px;
    margin-top: 16px;
}

.stat-mini {
    flex: 1;
    background: rgba(255,255,255,0.2);
    padding: 12px;
    border-radius: 8px;
    text-align: center;
}

.stat-mini-value {
    font-size: 24px;
    font-weight: 700;
    margin-bottom: 4px;
}

.stat-mini-label {
    font-size: 12px;
    opacity: 0.9;
}
</style>

<section class="page-container">
  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        
        <!-- Modern Header -->
        <div class="modern-header">
          <div class="d-flex justify-content-between align-items-start">
            <div>
              <h1><i class="dripicons-store"></i> Stores Management</h1>
              <p>Manage all your stores, categories, and featured items</p>
            </div>
            <div class="stats-mini">
              <div class="stat-mini">
                <div class="stat-mini-value" id="totalStores">-</div>
                <div class="stat-mini-label">Total</div>
              </div>
              <div class="stat-mini">
                <div class="stat-mini-value" id="activeStores">-</div>
                <div class="stat-mini-label">Active</div>
              </div>
              <div class="stat-mini">
                <div class="stat-mini-value" id="featuredStores">-</div>
                <div class="stat-mini-label">Featured</div>
              </div>
            </div>
          </div>
        </div>

        <div class="row">
          <!-- Sidebar Filters -->
          <div class="col-lg-3 mb-4">
            <div class="filter-card">
              <h6><i class="fa fa-filter"></i> Filters</h6>
              
              <div class="filter-group">
                <label>Status</label>
                <button class="filter-btn active" data-filter="all">
                  <i class="fa fa-list"></i> All Stores
                </button>
                <button class="filter-btn" data-filter="active">
                  <i class="fa fa-check-circle"></i> Active Only
                </button>
                <button class="filter-btn" data-filter="inactive">
                  <i class="fa fa-times-circle"></i> Inactive Only
                </button>
              </div>

              <div class="filter-group">
                <label>Featured</label>
                <button class="filter-btn" data-filter="featured">
                  <i class="fa fa-star"></i> Featured Only
                </button>
              </div>

              <div class="filter-group">
                <label>Search</label>
                <input type="text" id="searchStore" class="form-control" placeholder="Search stores...">
              </div>

              <hr>

              <div class="filter-group">
                <button class="btn btn-primary btn-block" onclick="location.href='../controller/new_store.php'">
                  <i class="fa fa-plus"></i> Add New Store
                </button>
                <button class="btn btn-success btn-block" data-toggle="modal" data-target="#importExportModal">
                  <i class="ti ti-file-import"></i> Import / Export
                </button>
              </div>
            </div>

            <!-- Quick Stats -->
            <div class="filter-card">
              <h6><i class="fa fa-chart-bar"></i> Quick Stats</h6>
              <div style="font-size: 13px; color: #6b7280;">
                <div class="d-flex justify-content-between mb-2">
                  <span>With Categories:</span>
                  <strong id="storesWithCats">-</strong>
                </div>
                <div class="d-flex justify-content-between mb-2">
                  <span>Without Categories:</span>
                  <strong id="storesWithoutCats">-</strong>
                </div>
              </div>
            </div>
          </div>

          <!-- Main Content -->
          <div class="col-lg-9">
            <!-- Action Bar -->
            <div class="action-bar">
              <div class="d-flex justify-content-between align-items-center">
                <div>
                  <span style="font-weight: 600; color: #1f2937;">
                    <span id="displayCount">0</span> stores found
                  </span>
                </div>
                <div>
                  <select id="bulkAction" class="form-control form-control-sm" style="display: inline-block; width: auto; margin-right: 8px;">
                    <option value="">Bulk Actions</option>
                    <option value="activate">Activate Selected</option>
                    <option value="deactivate">Deactivate Selected</option>
                    <option value="feature">Feature Selected</option>
                    <option value="unfeature">Unfeature Selected</option>
                    <option value="delete">Delete Selected</option>
                  </select>
                  <button class="btn btn-sm btn-primary" onclick="applyBulkAction()">
                    Apply
                  </button>
                </div>
              </div>
            </div>

            <!-- Table -->
            <div class="table-card">
              <div class="table-responsive">
                <table id="table_id" class="table modern-table" cellspacing="0" width="100%">
                  <thead>
                    <tr>
                      <th><input type="checkbox" id="selectAll"></th>
                      <th>ID</th>
                      <th>Image</th>
                      <th>Title</th>
                      <th>Categories</th>
                      <th>Featured</th>
                      <th>Status</th>
                      <th>Actions</th>
                    </tr>
                  </thead>
                </table>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>

<!-- Import/Export Modal -->
<div class="modal fade" id="importExportModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
      <div class="modal-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
        <h5 class="modal-title"><i class="ti ti-file-import"></i> Import / Export Stores</h5>
        <button type="button" class="close text-white" data-dismiss="modal">
          <span>&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-6">
            <div class="card">
              <div class="card-body">
                <h5 class="card-title"><i class="ti ti-download"></i> Export Stores</h5>
                <p class="card-text">Download all stores as CSV file.</p>
                <a href="../controller/import_export.php?action=export_stores" class="btn btn-primary">
                  <i class="ti ti-download"></i> Export Stores CSV
                </a>
              </div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="card">
              <div class="card-body">
                <h5 class="card-title"><i class="ti ti-upload"></i> Import Stores</h5>
                <p class="card-text">Upload CSV file to import stores.</p>
                <form method="post" action="../controller/import_export.php?action=import_stores" enctype="multipart/form-data">
                  <div class="form-group">
                    <input type="file" name="csv_file" class="form-control-file" accept=".csv" required>
                  </div>
                  <button type="submit" class="btn btn-primary">
                    <i class="ti ti-upload"></i> Import Stores
                  </button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
$(document).ready(function(){
  var table = $('#table_id').DataTable({
   "bProcessing": true,
   "sAjaxSource": "../controller/get_stores.php",
   "responsive": true,
   "bPaginate":true,
   "sPaginationType":"full_numbers",
   "iDisplayLength": 10,
   "aoColumns": [
   { "mData": null, "width": "3%", "className": "text-center", "orderable": false,
     "mRender": function(data) {
       return '<input type="checkbox" class="row-select" data-id="'+data.store_id+'">';
     }
   },
   { mData: 'store_id', "width": "5%", "className": "text-center" },
   { "mData": null , "width": "8%", "className": "text-center",
   "mRender" : function (data) {
    return "<img src='"+IMAGES_FOLDER+data.store_image+"' class='store-img'/>";}
  },
  { mData: 'store_title', "width": "25%" },
  { "mData": null, "width": "20%",
   "mRender" : function (data) {
    if (data.categories && data.categories.trim() !== '') {
      const cats = data.categories.split(' | ');
      let badges = '';
      cats.forEach(function(cat) {
        badges += '<span class="badge badge-info badge-modern" style="margin: 2px;">' + cat + '</span> ';
      });
      return badges;
    } else {
      return '<span class="text-muted" style="font-size: 11px;">No categories</span>';
    }
   }
  },
  { "mData": null , "width": "8%", "className":"text-center",
   "mRender" : function (data) {
    if (data.store_featured == 1) {
      return '<span class="badge badge-warning badge-modern"><i class="fa fa-star"></i> Featured</span>';
    }else{
      return '<span class="badge badge-secondary badge-modern">Regular</span>';
      }
    }
  },
  { "mData": null , "width": "8%", "className":"text-center",
   "mRender" : function (data) {
    if (data.store_status == 1) {
      return '<span class="badge badge-success badge-modern"><i class="fa fa-check"></i> Active</span>';
    }else{
      return '<span class="badge badge-danger badge-modern"><i class="fa fa-times"></i> Inactive</span>';
      }
    }
  },
  { "mData": null ,
  "width": "15%",
  "className": "text-center",
  'orderable': false,
  'searchable': false,
  "mRender" : function (data) {
    return "<a class='btn btn-sm btn-primary btn-modern' href='../controller/edit_store.php?id="+data.store_id+"'><i class='fa fa-edit'></i> Edit</a> <a class='btn btn-sm btn-danger btn-modern deleteItem' data-url='../controller/delete_store.php?id="+data.store_id+"'><i class='fa fa-trash'></i></a>";}
  }
  ],
  "drawCallback": function() {
    updateStats();
  }
});

// Search functionality
$('#searchStore').on('keyup', function() {
  table.search(this.value).draw();
});

// Filter buttons
$('.filter-btn').on('click', function() {
  $('.filter-btn').removeClass('active');
  $(this).addClass('active');
  
  var filter = $(this).data('filter');
  
  if (filter === 'all') {
    table.columns(6).search('').draw();
  } else if (filter === 'active') {
    table.columns(6).search('Active').draw();
  } else if (filter === 'inactive') {
    table.columns(6).search('Inactive').draw();
  } else if (filter === 'featured') {
    table.columns(5).search('Featured').draw();
  }
});

// Select all checkbox
$('#selectAll').on('change', function() {
  $('.row-select').prop('checked', this.checked);
});

// Update stats
function updateStats() {
  $.get('../controller/get_stores_stats.php', function(data) {
    $('#totalStores').text(data.total || 0);
    $('#activeStores').text(data.active || 0);
    $('#featuredStores').text(data.featured || 0);
    $('#storesWithCats').text(data.with_categories || 0);
    $('#storesWithoutCats').text(data.without_categories || 0);
    $('#displayCount').text(table.page.info().recordsDisplay);
  }, 'json').fail(function() {
    // Fallback if stats endpoint doesn't exist
    $('#displayCount').text(table.page.info().recordsDisplay);
  });
}

updateStats();
});

function applyBulkAction() {
  var action = $('#bulkAction').val();
  if (!action) {
    alert('Please select an action');
    return;
  }
  
  var selected = [];
  $('.row-select:checked').each(function() {
    selected.push($(this).data('id'));
  });
  
  if (selected.length === 0) {
    alert('Please select at least one store');
    return;
  }
  
  if (confirm('Apply ' + action + ' to ' + selected.length + ' store(s)?')) {
    // Implement bulk action logic here
    console.log('Bulk action:', action, 'IDs:', selected);
  }
}
</script>
