<?php 
// Get user information for sidebar
$user = get_user_information($connect);
$user = $user[0];

require 'sidebar.view.php'; 
?>

<style>
.seo-score-circle {
    width: 150px;
    height: 150px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 48px;
    font-weight: 700;
    color: white;
    margin: 0 auto 20px;
    position: relative;
}

.seo-score-circle.grade-a { background: linear-gradient(135deg, #10b981 0%, #059669 100%); }
.seo-score-circle.grade-b { background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%); }
.seo-score-circle.grade-c { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); }
.seo-score-circle.grade-d { background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); }
.seo-score-circle.grade-f { background: linear-gradient(135deg, #991b1b 0%, #7f1d1d 100%); }

.seo-grade {
    position: absolute;
    bottom: -30px;
    left: 50%;
    transform: translateX(-50%);
    font-size: 24px;
    font-weight: 700;
    color: #1f2937;
}

.metric-card {
    background: white;
    border-radius: 12px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
    margin-bottom: 20px;
}

.metric-label {
    font-size: 13px;
    color: #6b7280;
    font-weight: 600;
    margin-bottom: 8px;
}

.metric-value {
    font-size: 24px;
    font-weight: 700;
    color: #1f2937;
}

.issue-item {
    padding: 12px;
    background: #fef2f2;
    border-left: 4px solid #ef4444;
    border-radius: 6px;
    margin-bottom: 12px;
}

.recommendation-item {
    padding: 12px;
    background: #f0fdf4;
    border-left: 4px solid #10b981;
    border-radius: 6px;
    margin-bottom: 12px;
}

.stat-box {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 24px;
    border-radius: 12px;
    text-align: center;
    margin-bottom: 20px;
}

.stat-box h3 {
    font-size: 36px;
    font-weight: 700;
    margin: 0 0 8px 0;
}

.stat-box p {
    margin: 0;
    opacity: 0.9;
    font-size: 14px;
}
</style>

<section class="page-container">
  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><i class="fa fa-search"></i> SEO Content Analyzer</h5>
            </div>
          </div>
        </div>

        <!-- Site Stats -->
        <div class="row mb-4">
          <div class="col-md-3">
            <div class="stat-box">
              <h3><?php echo $siteStats['total_posts']; ?></h3>
              <p>Total Blog Posts</p>
            </div>
          </div>
          <div class="col-md-3">
            <div class="stat-box" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
              <h3><?php echo $siteStats['published_posts']; ?></h3>
              <p>Published Posts</p>
            </div>
          </div>
          <div class="col-md-3">
            <div class="stat-box" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
              <h3><?php echo $siteStats['total_pages']; ?></h3>
              <p>Total Pages</p>
            </div>
          </div>
          <div class="col-md-3">
            <div class="stat-box" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
              <h3><?php echo $siteStats['total_coupons']; ?></h3>
              <p>Total Coupons</p>
            </div>
          </div>
        </div>

        <!-- Analyzer Form -->
        <div class="row">
          <div class="col-lg-4">
            <div class="card">
              <div class="card-header bg-primary text-white">
                <h6 class="mb-0"><i class="fa fa-cog"></i> Analyze Content</h6>
              </div>
              <div class="card-body">
                <form method="post">
                  <div class="form-group">
                    <label>Content Type</label>
                    <select name="content_type" id="contentType" class="form-control" required>
                      <option value="">Select Type</option>
                      <option value="blog" <?php echo $selectedType == 'blog' ? 'selected' : ''; ?>>Blog Post</option>
                      <option value="page" <?php echo $selectedType == 'page' ? 'selected' : ''; ?>>Page</option>
                      <option value="coupon" <?php echo $selectedType == 'coupon' ? 'selected' : ''; ?>>Coupon</option>
                    </select>
                  </div>

                  <div class="form-group" id="blogSelect" style="display: none;">
                    <label>Select Blog Post</label>
                    <select name="content_id" class="form-control">
                      <option value="">Choose a post</option>
                      <?php foreach($blogPosts as $post): ?>
                      <option value="<?php echo $post['post_id']; ?>" <?php echo $selectedType == 'blog' && $selectedId == $post['post_id'] ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($post['post_title']); ?>
                      </option>
                      <?php endforeach; ?>
                    </select>
                  </div>

                  <div class="form-group" id="pageSelect" style="display: none;">
                    <label>Select Page</label>
                    <select name="content_id" class="form-control">
                      <option value="">Choose a page</option>
                      <?php foreach($pages as $page): ?>
                      <option value="<?php echo $page['page_id']; ?>" <?php echo $selectedType == 'page' && $selectedId == $page['page_id'] ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($page['page_title']); ?>
                      </option>
                      <?php endforeach; ?>
                    </select>
                  </div>

                  <div class="form-group" id="couponSelect" style="display: none;">
                    <label>Select Coupon</label>
                    <select name="content_id" class="form-control">
                      <option value="">Choose a coupon</option>
                      <?php foreach($coupons as $coupon): ?>
                      <option value="<?php echo $coupon['coupon_id']; ?>" <?php echo $selectedType == 'coupon' && $selectedId == $coupon['coupon_id'] ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($coupon['coupon_title']); ?>
                      </option>
                      <?php endforeach; ?>
                    </select>
                  </div>

                  <div class="form-group">
                    <label>Target Keyword (Optional)</label>
                    <input type="text" name="target_keyword" class="form-control" placeholder="e.g., best coupons 2025">
                    <small class="form-text text-muted">Leave empty for general analysis</small>
                  </div>

                  <button type="submit" name="analyze" class="btn btn-primary btn-block">
                    <i class="fa fa-search"></i> Analyze SEO
                  </button>
                </form>

                <hr>

                <div class="alert alert-info">
                  <strong>How it works:</strong>
                  <ul class="mb-0" style="font-size: 13px;">
                    <li>Select content type and item</li>
                    <li>Optionally add target keyword</li>
                    <li>Get instant SEO score (0-100)</li>
                    <li>See issues and recommendations</li>
                  </ul>
                </div>
              </div>
            </div>
          </div>

          <div class="col-lg-8">
            <?php if ($analysis): ?>
            <!-- SEO Score -->
            <div class="card mb-4">
              <div class="card-header bg-success text-white">
                <h6 class="mb-0"><i class="fa fa-chart-line"></i> SEO Analysis Results</h6>
              </div>
              <div class="card-body text-center">
                <div class="seo-score-circle grade-<?php echo strtolower(substr($analysis['grade'], 0, 1)); ?>">
                  <?php echo $analysis['score']; ?>
                  <span class="seo-grade"><?php echo $analysis['grade']; ?></span>
                </div>
                <h4 class="mt-4">
                  <?php 
                  if ($analysis['score'] >= 80) echo "Excellent! 🎉";
                  elseif ($analysis['score'] >= 60) echo "Good, but can improve 👍";
                  elseif ($analysis['score'] >= 40) echo "Needs improvement ⚠️";
                  else echo "Critical issues ❌";
                  ?>
                </h4>
              </div>
            </div>

            <!-- Metrics -->
            <div class="card mb-4">
              <div class="card-header bg-info text-white">
                <h6 class="mb-0"><i class="fa fa-chart-bar"></i> Content Metrics</h6>
              </div>
              <div class="card-body">
                <div class="row">
                  <div class="col-md-4">
                    <div class="metric-card">
                      <div class="metric-label">Title Length</div>
                      <div class="metric-value"><?php echo $analysis['metrics']['title_length']; ?> chars</div>
                      <small class="text-muted">Optimal: 50-60</small>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="metric-card">
                      <div class="metric-label">Word Count</div>
                      <div class="metric-value"><?php echo $analysis['metrics']['word_count']; ?></div>
                      <small class="text-muted">Minimum: 300</small>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="metric-card">
                      <div class="metric-label">Keyword Density</div>
                      <div class="metric-value"><?php echo number_format($analysis['metrics']['keyword_density'], 2); ?>%</div>
                      <small class="text-muted">Optimal: 0.5-2.5%</small>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="metric-card">
                      <div class="metric-label">H1 Tags</div>
                      <div class="metric-value"><?php echo $analysis['metrics']['h1_count']; ?></div>
                      <small class="text-muted">Should be: 1</small>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="metric-card">
                      <div class="metric-label">H2 Tags</div>
                      <div class="metric-value"><?php echo $analysis['metrics']['h2_count']; ?></div>
                      <small class="text-muted">Minimum: 2</small>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="metric-card">
                      <div class="metric-label">Internal Links</div>
                      <div class="metric-value"><?php echo $analysis['metrics']['internal_links']; ?></div>
                      <small class="text-muted">Minimum: 2</small>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Issues -->
            <?php if (!empty($analysis['issues'])): ?>
            <div class="card mb-4">
              <div class="card-header bg-danger text-white">
                <h6 class="mb-0"><i class="fa fa-exclamation-triangle"></i> Issues Found (<?php echo count($analysis['issues']); ?>)</h6>
              </div>
              <div class="card-body">
                <?php foreach($analysis['issues'] as $issue): ?>
                <div class="issue-item">
                  <i class="fa fa-times-circle text-danger"></i> <?php echo htmlspecialchars($issue); ?>
                </div>
                <?php endforeach; ?>
              </div>
            </div>
            <?php endif; ?>

            <!-- Recommendations -->
            <?php if (!empty($analysis['recommendations'])): ?>
            <div class="card mb-4">
              <div class="card-header bg-success text-white">
                <h6 class="mb-0"><i class="fa fa-lightbulb"></i> Recommendations (<?php echo count($analysis['recommendations']); ?>)</h6>
              </div>
              <div class="card-body">
                <?php foreach($analysis['recommendations'] as $rec): ?>
                <div class="recommendation-item">
                  <i class="fa fa-check-circle text-success"></i> <?php echo htmlspecialchars($rec); ?>
                </div>
                <?php endforeach; ?>
              </div>
            </div>
            <?php endif; ?>

            <?php else: ?>
            <!-- Empty State -->
            <div class="card">
              <div class="card-body text-center py-5">
                <i class="fa fa-search" style="font-size: 64px; color: #e5e7eb; margin-bottom: 20px;"></i>
                <h4>No Analysis Yet</h4>
                <p class="text-muted">Select content from the left panel and click "Analyze SEO" to get started.</p>
              </div>
            </div>
            <?php endif; ?>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>

<script>
document.getElementById('contentType').addEventListener('change', function() {
    var type = this.value;
    
    // Hide all selects
    document.getElementById('blogSelect').style.display = 'none';
    document.getElementById('pageSelect').style.display = 'none';
    document.getElementById('couponSelect').style.display = 'none';
    
    // Show selected type
    if (type === 'blog') {
        document.getElementById('blogSelect').style.display = 'block';
    } else if (type === 'page') {
        document.getElementById('pageSelect').style.display = 'block';
    } else if (type === 'coupon') {
        document.getElementById('couponSelect').style.display = 'block';
    }
});

// Trigger on page load if type is selected
window.addEventListener('load', function() {
    var type = document.getElementById('contentType').value;
    if (type) {
        document.getElementById('contentType').dispatchEvent(new Event('change'));
    }
});
</script>
