<?php 
// Get user information for sidebar
$user = get_user_information($connect);
$user = $user[0];

require 'sidebar.view.php'; 
?>

<style>
.dashboard-card {
    border-radius: 12px;
    border: none;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
    transition: transform 0.2s, box-shadow 0.2s;
    overflow: hidden;
}

.dashboard-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 4px 16px rgba(0,0,0,0.12);
}

.stat-card {
    padding: 24px;
    border-left: 4px solid;
    background: linear-gradient(135deg, #fff 0%, #f8f9fa 100%);
}

.stat-card.primary { border-left-color: #6366f1; }
.stat-card.success { border-left-color: #10b981; }
.stat-card.warning { border-left-color: #f59e0b; }
.stat-card.info { border-left-color: #3b82f6; }
.stat-card.purple { border-left-color: #8b5cf6; }
.stat-card.pink { border-left-color: #ec4899; }
.stat-card.teal { border-left-color: #14b8a6; }
.stat-card.orange { border-left-color: #f97316; }

.stat-icon {
    width: 56px;
    height: 56px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    color: white;
}

.stat-icon.primary { background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%); }
.stat-icon.success { background: linear-gradient(135deg, #10b981 0%, #059669 100%); }
.stat-icon.warning { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); }
.stat-icon.info { background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%); }
.stat-icon.purple { background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%); }
.stat-icon.pink { background: linear-gradient(135deg, #ec4899 0%, #db2777 100%); }
.stat-icon.teal { background: linear-gradient(135deg, #14b8a6 0%, #0d9488 100%); }
.stat-icon.orange { background: linear-gradient(135deg, #f97316 0%, #ea580c 100%); }

.stat-value {
    font-size: 32px;
    font-weight: 700;
    color: #1f2937;
    margin: 8px 0 4px 0;
}

.stat-label {
    font-size: 14px;
    color: #6b7280;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.stat-change {
    font-size: 13px;
    margin-top: 8px;
}

.stat-change.up { color: #10b981; }
.stat-change.down { color: #ef4444; }

.activity-card {
    padding: 20px;
}

.activity-item {
    padding: 16px;
    border-radius: 8px;
    background: #f9fafb;
    margin-bottom: 12px;
    transition: background 0.2s;
}

.activity-item:hover {
    background: #f3f4f6;
}

.activity-item:last-child {
    margin-bottom: 0;
}

.activity-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 18px;
    color: white;
}

.quick-action-btn {
    padding: 16px;
    border-radius: 10px;
    border: 2px solid #e5e7eb;
    background: white;
    text-align: center;
    transition: all 0.2s;
    text-decoration: none;
    display: block;
    color: #374151;
}

.quick-action-btn:hover {
    border-color: #6366f1;
    background: #f0f1ff;
    color: #6366f1;
    text-decoration: none;
    transform: translateY(-2px);
}

.quick-action-icon {
    font-size: 32px;
    margin-bottom: 8px;
}

.section-header {
    margin-bottom: 24px;
}

.section-title {
    font-size: 20px;
    font-weight: 700;
    color: #1f2937;
    margin: 0;
}

.section-subtitle {
    font-size: 14px;
    color: #6b7280;
    margin: 4px 0 0 0;
}
</style>

<section class="page-container">
  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        
        <!-- Welcome Header -->
        <div class="row mb-4">
          <div class="col-12">
            <div class="section-header">
              <h1 class="section-title">
                <i class="dripicons-view-apps" style="color: #6366f1;"></i> Dashboard Overview
              </h1>
              <p class="section-subtitle">Welcome back! Here's what's happening with your site today.</p>
            </div>
          </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row mb-4">
          <!-- Coupons -->
          <div class="col-md-6 col-lg-3 mb-4">
            <div class="dashboard-card stat-card primary">
              <div class="d-flex justify-content-between align-items-start">
                <div>
                  <div class="stat-label">Total Coupons</div>
                  <div class="stat-value"><?php echo number_format($stats['coupons']); ?></div>
                  <div class="stat-change up">
                    <i class="fa fa-arrow-up"></i> <?php echo $stats['active_coupons']; ?> Active
                  </div>
                </div>
                <div class="stat-icon primary">
                  <i class="dripicons-broadcast"></i>
                </div>
              </div>
            </div>
          </div>

          <!-- Stores -->
          <div class="col-md-6 col-lg-3 mb-4">
            <div class="dashboard-card stat-card success">
              <div class="d-flex justify-content-between align-items-start">
                <div>
                  <div class="stat-label">Total Stores</div>
                  <div class="stat-value"><?php echo number_format($stats['stores']); ?></div>
                  <div class="stat-change up">
                    <i class="fa fa-arrow-up"></i> <?php echo $stats['active_stores']; ?> Active
                  </div>
                </div>
                <div class="stat-icon success">
                  <i class="dripicons-store"></i>
                </div>
              </div>
            </div>
          </div>

          <!-- Blog Posts -->
          <div class="col-md-6 col-lg-3 mb-4">
            <div class="dashboard-card stat-card purple">
              <div class="d-flex justify-content-between align-items-start">
                <div>
                  <div class="stat-label">Blog Posts</div>
                  <div class="stat-value"><?php echo number_format($stats['blog_posts']); ?></div>
                  <div class="stat-change up">
                    <i class="fa fa-arrow-up"></i> <?php echo $stats['published_posts']; ?> Published
                  </div>
                </div>
                <div class="stat-icon purple">
                  <i class="dripicons-article"></i>
                </div>
              </div>
            </div>
          </div>

          <!-- Users -->
          <div class="col-md-6 col-lg-3 mb-4">
            <div class="dashboard-card stat-card info">
              <div class="d-flex justify-content-between align-items-start">
                <div>
                  <div class="stat-label">Total Users</div>
                  <div class="stat-value"><?php echo number_format($stats['users']); ?></div>
                  <div class="stat-change up">
                    <i class="fa fa-arrow-up"></i> <?php echo $stats['subscribers']; ?> Subscribers
                  </div>
                </div>
                <div class="stat-icon info">
                  <i class="dripicons-user-group"></i>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Secondary Stats -->
        <div class="row mb-4">
          <div class="col-md-3 col-sm-6 mb-4">
            <div class="dashboard-card stat-card warning">
              <div class="d-flex justify-content-between align-items-start">
                <div>
                  <div class="stat-label">Categories</div>
                  <div class="stat-value"><?php echo number_format($stats['categories']); ?></div>
                </div>
                <div class="stat-icon warning">
                  <i class="dripicons-tags"></i>
                </div>
              </div>
            </div>
          </div>

          <div class="col-md-3 col-sm-6 mb-4">
            <div class="dashboard-card stat-card pink">
              <div class="d-flex justify-content-between align-items-start">
                <div>
                  <div class="stat-label">Pages</div>
                  <div class="stat-value"><?php echo number_format($stats['pages']); ?></div>
                </div>
                <div class="stat-icon pink">
                  <i class="dripicons-document"></i>
                </div>
              </div>
            </div>
          </div>

          <div class="col-md-3 col-sm-6 mb-4">
            <div class="dashboard-card stat-card teal">
              <div class="d-flex justify-content-between align-items-start">
                <div>
                  <div class="stat-label">Subscribers</div>
                  <div class="stat-value"><?php echo number_format($stats['subscribers']); ?></div>
                </div>
                <div class="stat-icon teal">
                  <i class="dripicons-bell"></i>
                </div>
              </div>
            </div>
          </div>

          <div class="col-md-3 col-sm-6 mb-4">
            <div class="dashboard-card stat-card orange">
              <div class="d-flex justify-content-between align-items-start">
                <div>
                  <div class="stat-label">Active Coupons</div>
                  <div class="stat-value"><?php echo number_format($stats['active_coupons']); ?></div>
                </div>
                <div class="stat-icon orange">
                  <i class="dripicons-checkmark"></i>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Quick Actions -->
        <div class="row mb-4">
          <div class="col-12">
            <div class="section-header">
              <h2 class="section-title">
                <i class="dripicons-rocket" style="color: #6366f1;"></i> Quick Actions
              </h2>
              <p class="section-subtitle">Common tasks and shortcuts</p>
            </div>
          </div>
          
          <div class="col-md-2 col-sm-4 col-6 mb-3">
            <a href="../controller/new_coupon.php" class="quick-action-btn">
              <div class="quick-action-icon"><i class="dripicons-plus" style="color: #6366f1;"></i></div>
              <div style="font-weight: 600;">Add Coupon</div>
            </a>
          </div>

          <div class="col-md-2 col-sm-4 col-6 mb-3">
            <a href="../controller/new_store.php" class="quick-action-btn">
              <div class="quick-action-icon"><i class="dripicons-store" style="color: #10b981;"></i></div>
              <div style="font-weight: 600;">Add Store</div>
            </a>
          </div>

          <div class="col-md-2 col-sm-4 col-6 mb-3">
            <a href="../controller/new_blog.php" class="quick-action-btn">
              <div class="quick-action-icon"><i class="dripicons-article" style="color: #8b5cf6;"></i></div>
              <div style="font-weight: 600;">New Post</div>
            </a>
          </div>

          <div class="col-md-2 col-sm-4 col-6 mb-3">
            <a href="../controller/new_category.php" class="quick-action-btn">
              <div class="quick-action-icon"><i class="dripicons-tags" style="color: #f59e0b;"></i></div>
              <div style="font-weight: 600;">Add Category</div>
            </a>
          </div>

          <div class="col-md-2 col-sm-4 col-6 mb-3">
            <a href="../controller/seo_tools.php" class="quick-action-btn">
              <div class="quick-action-icon"><i class="fa fa-search" style="color: #3b82f6;"></i></div>
              <div style="font-weight: 600;">SEO Tools</div>
            </a>
          </div>

          <div class="col-md-2 col-sm-4 col-6 mb-3">
            <a href="../controller/settings.php" class="quick-action-btn">
              <div class="quick-action-icon"><i class="dripicons-gear" style="color: #6b7280;"></i></div>
              <div style="font-weight: 600;">Settings</div>
            </a>
          </div>
        </div>

        <!-- Recent Activity -->
        <div class="row">
          <!-- Recent Coupons -->
          <div class="col-lg-6 mb-4">
            <div class="dashboard-card activity-card">
              <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0" style="font-weight: 700; color: #1f2937;">
                  <i class="dripicons-broadcast" style="color: #6366f1;"></i> Recent Coupons
                </h5>
                <a href="../controller/coupons.php" class="btn btn-sm btn-outline-primary">View All</a>
              </div>
              
              <?php foreach($recent_coupons as $coupon): ?>
              <div class="activity-item">
                <div class="d-flex align-items-center">
                  <div class="activity-icon primary mr-3">
                    <i class="dripicons-broadcast"></i>
                  </div>
                  <div class="flex-grow-1">
                    <a href="../controller/edit_coupon.php?id=<?php echo $coupon['coupon_id']; ?>" style="font-weight: 600; color: #1f2937;">
                      <?php echo htmlspecialchars($coupon['coupon_title']); ?>
                    </a>
                    <div style="font-size: 13px; color: #6b7280;">
                      <i class="fa fa-clock-o"></i> <?php echo date('M d, Y', strtotime($coupon['coupon_created'])); ?>
                    </div>
                  </div>
                  <span class="badge badge-<?php echo $coupon['coupon_status'] == 1 ? 'success' : 'secondary'; ?>">
                    <?php echo $coupon['coupon_status'] == 1 ? 'Active' : 'Inactive'; ?>
                  </span>
                </div>
              </div>
              <?php endforeach; ?>
            </div>
          </div>

          <!-- Recent Blog Posts -->
          <div class="col-lg-6 mb-4">
            <div class="dashboard-card activity-card">
              <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0" style="font-weight: 700; color: #1f2937;">
                  <i class="dripicons-article" style="color: #8b5cf6;"></i> Recent Blog Posts
                </h5>
                <a href="../controller/blog.php" class="btn btn-sm btn-outline-primary">View All</a>
              </div>
              
              <?php foreach($recent_posts as $post): ?>
              <div class="activity-item">
                <div class="d-flex align-items-center">
                  <div class="activity-icon purple mr-3">
                    <i class="dripicons-article"></i>
                  </div>
                  <div class="flex-grow-1">
                    <a href="../controller/edit_blog.php?id=<?php echo $post['post_id']; ?>" style="font-weight: 600; color: #1f2937;">
                      <?php echo htmlspecialchars($post['post_title']); ?>
                    </a>
                    <div style="font-size: 13px; color: #6b7280;">
                      <i class="fa fa-user"></i> <?php echo htmlspecialchars($post['user_name']); ?> • 
                      <i class="fa fa-clock-o"></i> <?php echo date('M d, Y', strtotime($post['created_at'])); ?>
                    </div>
                  </div>
                  <span class="badge badge-<?php echo $post['post_status'] == 'published' ? 'success' : 'warning'; ?>">
                    <?php echo ucfirst($post['post_status']); ?>
                  </span>
                </div>
              </div>
              <?php endforeach; ?>
            </div>
          </div>

          <!-- Recent Stores -->
          <div class="col-lg-6 mb-4">
            <div class="dashboard-card activity-card">
              <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0" style="font-weight: 700; color: #1f2937;">
                  <i class="dripicons-store" style="color: #10b981;"></i> Recent Stores
                </h5>
                <a href="../controller/stores.php" class="btn btn-sm btn-outline-primary">View All</a>
              </div>
              
              <?php foreach($recent_stores as $store): ?>
              <div class="activity-item">
                <div class="d-flex align-items-center">
                  <div class="activity-icon success mr-3">
                    <i class="dripicons-store"></i>
                  </div>
                  <div class="flex-grow-1">
                    <a href="../controller/edit_store.php?id=<?php echo $store['store_id']; ?>" style="font-weight: 600; color: #1f2937;">
                      <?php echo htmlspecialchars($store['store_title']); ?>
                    </a>
                    <div style="font-size: 13px; color: #6b7280;">
                      <i class="fa fa-tag"></i> Store ID: <?php echo $store['store_id']; ?>
                    </div>
                  </div>
                  <span class="badge badge-<?php echo $store['store_status'] == 1 ? 'success' : 'secondary'; ?>">
                    <?php echo $store['store_status'] == 1 ? 'Active' : 'Inactive'; ?>
                  </span>
                </div>
              </div>
              <?php endforeach; ?>
            </div>
          </div>

          <!-- Recent Users -->
          <div class="col-lg-6 mb-4">
            <div class="dashboard-card activity-card">
              <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0" style="font-weight: 700; color: #1f2937;">
                  <i class="dripicons-user-group" style="color: #3b82f6;"></i> Recent Users
                </h5>
                <a href="../controller/users.php" class="btn btn-sm btn-outline-primary">View All</a>
              </div>
              
              <?php foreach($recent_users as $usr): ?>
              <div class="activity-item">
                <div class="d-flex align-items-center">
                  <div class="activity-icon info mr-3">
                    <i class="dripicons-user"></i>
                  </div>
                  <div class="flex-grow-1">
                    <div style="font-weight: 600; color: #1f2937;">
                      <?php echo htmlspecialchars($usr['user_name']); ?>
                    </div>
                    <div style="font-size: 13px; color: #6b7280;">
                      <i class="fa fa-envelope"></i> <?php echo htmlspecialchars($usr['user_email']); ?> • 
                      <i class="fa fa-clock-o"></i> <?php echo date('M d, Y', strtotime($usr['user_created'])); ?>
                    </div>
                  </div>
                  <span class="badge badge-<?php echo $usr['user_role'] == 1 ? 'danger' : 'info'; ?>">
                    <?php echo $usr['user_role'] == 1 ? 'Admin' : 'User'; ?>
                  </span>
                </div>
              </div>
              <?php endforeach; ?>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>
