<?php require 'sidebar.php'; ?>

<!--Page Container-->
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><i class="fa fa-user-circle"></i> Author Profile</h5>
            </div>
          </div>

          <?php if(isset($success)): ?>
          <div class="col-12">
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              <?php echo $success; ?>
              <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
          </div>
          <?php endif; ?>

          <?php if(isset($error)): ?>
          <div class="col-12">
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
              <?php echo $error; ?>
              <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
          </div>
          <?php endif; ?>

          <div class="col-md-12">
            <div class="form-block mb-4">

              <form method="post" enctype="multipart/form-data">
                <input type="hidden" name="action" value="update_profile">

                <div class="form-row">
                  <div class="form-group col-md-8">
                    <div class="block col-md-12">

                      <div class="alert alert-info">
                        <strong>About Author Profile:</strong> This information will be displayed on your blog posts and author page. 
                        Users can click your name to see all your posts.
                      </div>

                      <label>Display Name</label>
                      <input type="text" class="form-control" value="<?php echo htmlspecialchars($user['user_name']); ?>" disabled>
                      <small class="form-text text-muted">To change your name, go to Settings → Profile</small>

                      <label class="mt-3"><i class="fa fa-image"></i> Profile Photo</label>
                      <div class="custom-file">
                        <input type="file" class="custom-file-input" id="avatarUpload" name="user_avatar" accept="image/*" onchange="previewAvatar(this)">
                        <label class="custom-file-label" for="avatarUpload">Choose photo...</label>
                      </div>
                      <small class="form-text text-muted">Upload JPG, PNG, GIF, or WebP (recommended: 400x400px)</small>
                      
                      <!-- Avatar Preview -->
                      <div class="mt-3">
                        <img id="avatarPreview" 
                             src="<?php echo SITE_URL; ?>/images/<?php echo htmlspecialchars($user['user_avatar'] ?? 'avatar.png'); ?>" 
                             alt="Avatar Preview" 
                             style="width: 120px; height: 120px; object-fit: cover; border-radius: 50%; border: 3px solid #ddd;">
                      </div>

                      <label class="mt-3">Author Bio</label>
                      <textarea name="user_bio" class="form-control" rows="4" 
                                placeholder="Write a brief bio about yourself..."><?php echo htmlspecialchars($user['user_bio'] ?? ''); ?></textarea>
                      <small class="form-text text-muted">This will appear in the author box on your blog posts</small>

                      <hr class="mt-4 mb-4">

                      <h6><i class="fa fa-share-alt"></i> Social Media Links</h6>
                      <p class="text-muted">Add your social media profiles (optional)</p>

                      <label><i class="fab fa-facebook"></i> Facebook</label>
                      <input type="url" name="user_facebook" class="form-control" 
                             value="<?php echo htmlspecialchars($user['user_facebook'] ?? ''); ?>" 
                             placeholder="https://facebook.com/yourprofile">

                      <label class="mt-3"><i class="fab fa-twitter"></i> Twitter</label>
                      <input type="url" name="user_twitter" class="form-control" 
                             value="<?php echo htmlspecialchars($user['user_twitter'] ?? ''); ?>" 
                             placeholder="https://twitter.com/yourhandle">

                      <label class="mt-3"><i class="fab fa-instagram"></i> Instagram</label>
                      <input type="url" name="user_instagram" class="form-control" 
                             value="<?php echo htmlspecialchars($user['user_instagram'] ?? ''); ?>" 
                             placeholder="https://instagram.com/yourprofile">

                      <label class="mt-3"><i class="fab fa-linkedin"></i> LinkedIn</label>
                      <input type="url" name="user_linkedin" class="form-control" 
                             value="<?php echo htmlspecialchars($user['user_linkedin'] ?? ''); ?>" 
                             placeholder="https://linkedin.com/in/yourprofile">

                      <label class="mt-3"><i class="fa fa-globe"></i> Website</label>
                      <input type="url" name="user_website" class="form-control" 
                             value="<?php echo htmlspecialchars($user['user_website'] ?? ''); ?>" 
                             placeholder="https://yourwebsite.com">

                    </div>
                  </div>

                  <div class="form-group col-md-4">
                    <div class="block col-md-12">
                      
                      <h6><i class="fa fa-eye"></i> Preview</h6>
                      
                      <div class="card">
                        <div class="card-body text-center">
                          <img src="<?php echo SITE_URL; ?>/images/<?php echo htmlspecialchars($user['user_avatar'] ?? 'avatar.png'); ?>" 
                               alt="<?php echo htmlspecialchars($user['user_name']); ?>"
                               style="width: 100px; height: 100px; object-fit: cover; border-radius: 50%; border: 3px solid #ddd; margin-bottom: 15px;">
                          <h5 class="card-title"><?php echo htmlspecialchars($user['user_name']); ?></h5>
                          <p class="card-text text-muted">
                            <?php echo htmlspecialchars($user['user_bio'] ?? 'No bio added yet.'); ?>
                          </p>
                          
                          <?php if(!empty($user['user_facebook']) || !empty($user['user_twitter']) || !empty($user['user_instagram']) || !empty($user['user_linkedin']) || !empty($user['user_website'])): ?>
                          <div class="mt-3">
                            <strong>Follow:</strong><br>
                            <?php if(!empty($user['user_facebook'])): ?>
                            <a href="<?php echo htmlspecialchars($user['user_facebook']); ?>" target="_blank" class="btn btn-sm btn-primary mt-1">
                              <i class="fab fa-facebook"></i>
                            </a>
                            <?php endif; ?>
                            <?php if(!empty($user['user_twitter'])): ?>
                            <a href="<?php echo htmlspecialchars($user['user_twitter']); ?>" target="_blank" class="btn btn-sm btn-info mt-1">
                              <i class="fab fa-twitter"></i>
                            </a>
                            <?php endif; ?>
                            <?php if(!empty($user['user_instagram'])): ?>
                            <a href="<?php echo htmlspecialchars($user['user_instagram']); ?>" target="_blank" class="btn btn-sm btn-danger mt-1">
                              <i class="fab fa-instagram"></i>
                            </a>
                            <?php endif; ?>
                            <?php if(!empty($user['user_linkedin'])): ?>
                            <a href="<?php echo htmlspecialchars($user['user_linkedin']); ?>" target="_blank" class="btn btn-sm btn-primary mt-1">
                              <i class="fab fa-linkedin"></i>
                            </a>
                            <?php endif; ?>
                            <?php if(!empty($user['user_website'])): ?>
                            <a href="<?php echo htmlspecialchars($user['user_website']); ?>" target="_blank" class="btn btn-sm btn-secondary mt-1">
                              <i class="fa fa-globe"></i>
                            </a>
                            <?php endif; ?>
                          </div>
                          <?php endif; ?>
                        </div>
                      </div>

                      <button type="submit" class="btn btn-primary btn-block mt-3">
                        <i class="fa fa-save"></i> Update Profile
                      </button>

                      <a href="<?php echo SITE_URL; ?>/author/<?php echo $user['user_id']; ?>" target="_blank" class="btn btn-info btn-block mt-2">
                        <i class="fa fa-external-link-alt"></i> View Author Page
                      </a>

                    </div>
                  </div>

                </div>

              </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


<script>
// Preview avatar before upload
function previewAvatar(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        
        reader.onload = function(e) {
            document.getElementById('avatarPreview').src = e.target.result;
        }
        
        reader.readAsDataURL(input.files[0]);
        
        // Update file input label
        var fileName = input.files[0].name;
        var label = input.nextElementSibling;
        label.textContent = fileName;
    }
}

// Bootstrap custom file input
$(document).ready(function() {
    $('.custom-file-input').on('change', function() {
        var fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').addClass("selected").html(fileName);
    });
});
</script>
