<?php

session_start();

require '../../config.php';
require '../admin_config.php';
require '../functions.php';

if (isset($_SESSION['user_email'])){

$connect = connect($database);

$check_access = check_access($connect);

if ($check_access['user_role'] == 1){

if (isset($_GET['id'])){
    
    $popup_id = intval($_GET['id']);
    
    // Toggle status and update timestamp
    $stmt = $connect->prepare("UPDATE popups SET popup_enabled = NOT popup_enabled, popup_updated_at = NOW() WHERE popup_id = ?");
    $stmt->execute([$popup_id]);
    
    // Get new status
    $stmt = $connect->prepare("SELECT popup_enabled FROM popups WHERE popup_id = ?");
    $stmt->execute([$popup_id]);
    $result = $stmt->fetch();
    
    $status = $result['popup_enabled'] ? 'activated' : 'deactivated';
    $_SESSION['popup_success'] = "Popup $status successfully!";
}

header('Location: ./popups.php');

}else{
    header('Location:'.SITE_URL);
}

}else{
    header('Location: ./login.php');
}

?>
