<?php

session_start();

require '../../config.php';
require '../admin_config.php';
require '../functions.php';
require '../views/header.view.php';

if (isset($_SESSION['user_email'])){

$connect = connect($database);
if(!$connect){
    header('Location: ./error.php');
}

$check_access = check_access($connect);

if ($check_access['user_role'] == 1 || $check_access['user_role'] == 2){
    
    // Handle Add/Edit/Delete
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        
        if (isset($_POST['action']) && $_POST['action'] === 'add') {
            $name = cleardata($_POST['blog_cat_name']);
            $slug = !empty($_POST['blog_cat_slug']) ? cleardata($_POST['blog_cat_slug']) : convertSlug($name);
            $description = cleardata($_POST['blog_cat_description']);
            
            $stmt = $connect->prepare("INSERT INTO blog_categories (blog_cat_name, blog_cat_slug, blog_cat_description, blog_cat_status) VALUES (?, ?, ?, 1)");
            $stmt->execute([$name, $slug, $description]);
            
            $_SESSION['success'] = "Category added successfully!";
            header('Location: ./blog_categories.php');
            exit;
        }
        
        if (isset($_POST['action']) && $_POST['action'] === 'edit') {
            $id = intval($_POST['blog_cat_id']);
            $name = cleardata($_POST['blog_cat_name']);
            $slug = cleardata($_POST['blog_cat_slug']);
            $description = cleardata($_POST['blog_cat_description']);
            $status = intval($_POST['blog_cat_status']);
            
            $stmt = $connect->prepare("UPDATE blog_categories SET blog_cat_name = ?, blog_cat_slug = ?, blog_cat_description = ?, blog_cat_status = ? WHERE blog_cat_id = ?");
            $stmt->execute([$name, $slug, $description, $status, $id]);
            
            $_SESSION['success'] = "Category updated successfully!";
            header('Location: ./blog_categories.php');
            exit;
        }
    }
    
    // Handle Delete
    if (isset($_GET['delete'])) {
        $id = intval($_GET['delete']);
        $connect->prepare("DELETE FROM blog_categories WHERE blog_cat_id = ?")->execute([$id]);
        $_SESSION['success'] = "Category deleted successfully!";
        header('Location: ./blog_categories.php');
        exit;
    }
    
    // Get category for editing
    $editCategory = null;
    if (isset($_GET['edit'])) {
        $id = intval($_GET['edit']);
        $stmt = $connect->prepare("SELECT * FROM blog_categories WHERE blog_cat_id = ?");
        $stmt->execute([$id]);
        $editCategory = $stmt->fetch(PDO::FETCH_ASSOC);
    }
    
    // Get all categories with post count
    $categories = $connect->query("SELECT bc.*, COUNT(bp.post_id) as post_count 
                                   FROM blog_categories bc
                                   LEFT JOIN blog_posts bp ON bc.blog_cat_id = bp.post_category
                                   GROUP BY bc.blog_cat_id
                                   ORDER BY bc.blog_cat_name")->fetchAll(PDO::FETCH_ASSOC);
    
    require '../views/blog_categories.view.php';
	
}else{
	header('Location:'.SITE_URL);
}

require '../views/footer.view.php';

}else{
	header('Location: ./login.php');	
}

?>
