<div class="uk-container uk-margin-large-top uk-margin-large-bottom">
    
    <!-- Hero Section -->
    <div class="uk-card uk-card-primary uk-card-body uk-border-rounded uk-margin-large-bottom" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
        <div class="uk-text-center">
            <h1 class="uk-heading-medium uk-margin-remove" style="color: white;">📰 Latest Posts</h1>
            <p class="uk-text-lead" style="color: rgba(255,255,255,0.9);">Discover the latest news, tips, and insights</p>
        </div>
    </div>

    <div class="uk-grid-medium" uk-grid>
        <!-- Main Content -->
        <div class="uk-width-expand@m">
            
            <!-- Featured Post (First Post) -->
            <?php if(!empty($posts) && isset($posts[0])): 
                $featuredPost = $posts[0];
            ?>
            <div class="uk-card uk-card-default uk-margin-large-bottom" style="border-radius: 12px; overflow: hidden; box-shadow: 0 5px 15px rgba(0,0,0,0.08);">
                <div class="uk-grid-collapse uk-child-width-1-2@m" uk-grid>
                    <?php if($featuredPost['post_featured_image']): ?>
                    <div>
                        <a href="<?php echo SITE_URL; ?>/Post/<?php echo $featuredPost['post_slug']; ?>">
                            <img src="<?php echo getImageUrl($featuredPost['post_featured_image_cdn_url'], $featuredPost['post_use_cdn'], $featuredPost['post_featured_image']); ?>" 
                                 alt="<?php echo htmlspecialchars($featuredPost['post_title']); ?>"
                                 style="width: 100%; height: 400px; object-fit: cover;">
                        </a>
                    </div>
                    <?php endif; ?>
                    <div>
                        <div class="uk-card-body uk-flex uk-flex-column uk-flex-between" style="height: 400px;">
                            <div>
                                <?php if($featuredPost['blog_cat_name']): ?>
                                <span class="uk-label" style="background: #667eea;"><?php echo htmlspecialchars($featuredPost['blog_cat_name']); ?></span>
                                <?php endif; ?>
                                <h2 class="uk-margin-small-top" style="font-size: 28px; line-height: 1.3;">
                                    <a href="<?php echo SITE_URL; ?>/Post/<?php echo $featuredPost['post_slug']; ?>" class="uk-link-reset">
                                        <?php echo htmlspecialchars($featuredPost['post_title']); ?>
                                    </a>
                                </h2>
                                <p class="uk-text-muted uk-margin-small">
                                    <?php echo htmlspecialchars(substr(strip_tags($featuredPost['post_excerpt'] ?: $featuredPost['post_content']), 0, 150)) . '...'; ?>
                                </p>
                            </div>
                            <div>
                                <div class="uk-text-small uk-text-muted uk-margin-small-bottom">
                                    <i class="ti ti-calendar"></i> <?php echo date('M d, Y', strtotime($featuredPost['published_at'])); ?>
                                    <span class="uk-margin-small-left"><i class="ti ti-eye"></i> <?php echo number_format($featuredPost['post_views']); ?></span>
                                </div>
                                <a href="<?php echo SITE_URL; ?>/Post/<?php echo $featuredPost['post_slug']; ?>" class="uk-button uk-button-primary uk-border-rounded">
                                    Read More <i class="ti ti-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php 
                // Remove featured post from array
                array_shift($posts);
            endif; 
            ?>

            <!-- Blog Posts Grid -->
            <?php if(empty($posts)): ?>
            <div class="uk-card uk-card-default uk-card-body uk-text-center">
                <p class="uk-text-muted">No more posts found.</p>
            </div>
            <?php else: ?>
            <div class="uk-grid uk-grid-medium uk-child-width-1-2@s uk-child-width-1-3@m" uk-grid>
                <?php foreach($posts as $post): ?>
                <div>
                    <div class="uk-card uk-card-default uk-card-hover" style="border-radius: 12px; overflow: hidden; transition: transform 0.3s ease, box-shadow 0.3s ease;">
                        <?php if($post['post_featured_image']): ?>
                        <div class="uk-card-media-top" style="position: relative; overflow: hidden;">
                            <a href="<?php echo SITE_URL; ?>/Post/<?php echo $post['post_slug']; ?>">
                                <img src="<?php echo getImageUrl($post['post_featured_image_cdn_url'], $post['post_use_cdn'], $post['post_featured_image']); ?>" 
                                     alt="<?php echo htmlspecialchars($post['post_title']); ?>"
                                     style="width: 100%; height: 200px; object-fit: cover; transition: transform 0.3s ease;">
                            </a>
                            <?php if($post['blog_cat_name']): ?>
                            <span class="uk-label uk-position-top-right uk-margin-small-top uk-margin-small-right" style="background: #667eea;">
                                <?php echo htmlspecialchars($post['blog_cat_name']); ?>
                            </span>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                        <div class="uk-card-body">
                            <h3 class="uk-card-title" style="font-size: 18px; line-height: 1.4; margin-bottom: 10px;">
                                <a href="<?php echo SITE_URL; ?>/Post/<?php echo $post['post_slug']; ?>" class="uk-link-reset">
                                    <?php echo htmlspecialchars($post['post_title']); ?>
                                </a>
                            </h3>
                            <p class="uk-text-small uk-text-muted uk-margin-small">
                                <i class="ti ti-calendar"></i> <?php echo date('M d, Y', strtotime($post['published_at'])); ?>
                                <span class="uk-margin-small-left"><i class="ti ti-eye"></i> <?php echo number_format($post['post_views']); ?></span>
                            </p>
                            <p class="uk-text-small" style="color: #666;">
                                <?php echo htmlspecialchars(substr(strip_tags($post['post_excerpt'] ?: $post['post_content']), 0, 80)) . '...'; ?>
                            </p>
                            <a href="<?php echo SITE_URL; ?>/Post/<?php echo $post['post_slug']; ?>" class="uk-button uk-button-text uk-text-primary">
                                Read More <i class="ti ti-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>

            <!-- Pagination -->
            <?php if($totalPages > 1): ?>
            <ul class="uk-pagination uk-flex-center uk-margin-large-top">
                <?php if($currentPage > 1): ?>
                <li><a href="?page=<?php echo $currentPage - 1; ?><?php echo $categoryFilter ? '&category=' . $categoryFilter : ''; ?>"><span uk-pagination-previous></span></a></li>
                <?php endif; ?>
                
                <?php for($i = 1; $i <= $totalPages; $i++): ?>
                <li class="<?php echo ($i == $currentPage) ? 'uk-active' : ''; ?>">
                    <a href="?page=<?php echo $i; ?><?php echo $categoryFilter ? '&category=' . $categoryFilter : ''; ?>"><?php echo $i; ?></a>
                </li>
                <?php endfor; ?>
                
                <?php if($currentPage < $totalPages): ?>
                <li><a href="?page=<?php echo $currentPage + 1; ?><?php echo $categoryFilter ? '&category=' . $categoryFilter : ''; ?>"><span uk-pagination-next></span></a></li>
                <?php endif; ?>
            </ul>
            <?php endif; ?>
            <?php endif; ?>
        </div>

        <!-- Sidebar -->
        <div class="uk-width-1-4@m">
            <!-- Categories Widget -->
            <div class="uk-card uk-card-default uk-card-body uk-margin-bottom" style="border-radius: 12px;">
                <h4 class="uk-card-title" style="border-bottom: 2px solid #667eea; padding-bottom: 10px;">
                    <i class="ti ti-folder"></i> Categories
                </h4>
                <ul class="uk-list uk-list-divider">
                    <li>
                        <a href="<?php echo SITE_URL; ?>/Post" class="uk-link-reset uk-flex uk-flex-between">
                            <span>All Posts</span>
                            <span class="uk-badge" style="background: #667eea;"><?php echo $totalPosts; ?></span>
                        </a>
                    </li>
                    <?php foreach($blogCategories as $cat): ?>
                    <li>
                        <a href="<?php echo SITE_URL; ?>/Post?category=<?php echo $cat['blog_cat_id']; ?>" class="uk-link-reset uk-flex uk-flex-between">
                            <span><?php echo htmlspecialchars($cat['blog_cat_name']); ?></span>
                            <span class="uk-badge"><?php echo $cat['post_count']; ?></span>
                        </a>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>

            <!-- Newsletter Widget -->
            <div class="uk-card uk-card-body uk-margin-bottom" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 12px; color: white;">
                <h4 class="uk-card-title" style="color: white;"><i class="ti ti-mail"></i> Newsletter</h4>
                <p style="color: rgba(255,255,255,0.9);">Get the latest posts delivered to your inbox.</p>
                <form class="uk-form-stacked">
                    <input type="email" class="uk-input uk-border-rounded" placeholder="Your email..." style="background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white;">
                    <button type="submit" class="uk-button uk-button-default uk-width-1-1 uk-margin-small-top uk-border-rounded">Subscribe</button>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.uk-card-hover:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15) !important;
}
.uk-card-hover:hover img {
    transform: scale(1.05);
}
</style>
