<?php
/**
 * Email Configuration Test Script
 * Use this to test if your SMTP settings are working correctly
 */

require 'core.php';

// Check if admin is logged in
if (!isAdmin()) {
    die('Access denied. Admin login required.');
}

?>
<!DOCTYPE html>
<html>
<head>
    <title>Email Configuration Test</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            background: #f5f5f5;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #333;
            border-bottom: 2px solid #667eea;
            padding-bottom: 10px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
            color: #555;
        }
        input[type="email"] {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }
        button {
            background: #667eea;
            color: white;
            padding: 12px 30px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
        }
        button:hover {
            background: #5568d3;
        }
        .result {
            margin-top: 20px;
            padding: 15px;
            border-radius: 4px;
        }
        .success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .info {
            background: #d1ecf1;
            color: #0c5460;
            border: 1px solid #bee5eb;
            margin-bottom: 20px;
        }
        .settings {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 4px;
            margin-top: 20px;
        }
        .settings h3 {
            margin-top: 0;
            color: #333;
        }
        .settings p {
            margin: 5px 0;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>📧 Email Configuration Test</h1>
        
        <div class="info">
            <strong>ℹ️ Information:</strong> This tool will send a test email to verify your SMTP configuration is working correctly.
        </div>

        <?php
        $settings = $connect->query("SELECT * FROM settings")->fetch();
        ?>

        <div class="settings">
            <h3>Current SMTP Settings</h3>
            <p><strong>SMTP Host:</strong> <?php echo htmlspecialchars($settings['st_smtphost']); ?></p>
            <p><strong>SMTP Port:</strong> <?php echo htmlspecialchars($settings['st_smtpport']); ?></p>
            <p><strong>SMTP Email:</strong> <?php echo htmlspecialchars($settings['st_smtpemail']); ?></p>
            <p><strong>SMTP Encryption:</strong> <?php echo htmlspecialchars($settings['st_smtpencrypt']); ?></p>
            <p><strong>Password:</strong> <?php echo !empty($settings['st_smtppassword']) ? '••••••••' : 'Not set'; ?></p>
        </div>

        <form method="POST" action="">
            <div class="form-group">
                <label for="test_email">Test Email Address:</label>
                <input type="email" id="test_email" name="test_email" required 
                       placeholder="Enter email address to receive test email"
                       value="<?php echo isset($_POST['test_email']) ? htmlspecialchars($_POST['test_email']) : ''; ?>">
            </div>
            
            <button type="submit" name="send_test">Send Test Email</button>
        </form>

        <?php
        if (isset($_POST['send_test']) && !empty($_POST['test_email'])) {
            $test_email = filter_var($_POST['test_email'], FILTER_VALIDATE_EMAIL);
            
            if ($test_email) {
                echo '<div class="result">';
                
                try {
                    // Prepare test email content
                    $array_content = array(
                        "{LOGO_URL}" => $urlPath->image($theme['th_logo']),
                        "{SITE_DOMAIN}" => $urlPath->home(),
                        "{SITE_NAME}" => $translation['tr_1'],
                        "{USER_NAME}" => "Test User",
                        "{VERIFICATION_CODE}" => "123456"
                    );
                    
                    // Get 2FA email template
                    $emailTemplate = getEmailTemplate($connect, 3);
                    
                    if ($emailTemplate) {
                        $emailContent = json_decode($emailTemplate['email_content'], true);
                        
                        $result = sendMail(
                            $array_content,
                            $emailContent[0]['message'],
                            $test_email,
                            $emailTemplate['email_fromname'],
                            'Test Email - ' . $emailContent[0]['subject'],
                            $emailTemplate['email_plaintext']
                        );
                        
                        if ($result === 'TRUE') {
                            echo '<div class="success">';
                            echo '<strong>✅ Success!</strong><br>';
                            echo 'Test email sent successfully to: ' . htmlspecialchars($test_email) . '<br>';
                            echo 'Please check your inbox (and spam folder) for the test email.';
                            echo '</div>';
                        } else {
                            echo '<div class="error">';
                            echo '<strong>❌ Error!</strong><br>';
                            echo 'Failed to send email. Error details:<br>';
                            echo '<pre>' . htmlspecialchars($result) . '</pre>';
                            echo '</div>';
                        }
                    } else {
                        echo '<div class="error">';
                        echo '<strong>❌ Error!</strong><br>';
                        echo 'Email template not found. Please run the database_2fa_update.sql file first.';
                        echo '</div>';
                    }
                    
                } catch (Exception $e) {
                    echo '<div class="error">';
                    echo '<strong>❌ Exception!</strong><br>';
                    echo htmlspecialchars($e->getMessage());
                    echo '</div>';
                }
                
                echo '</div>';
            } else {
                echo '<div class="result error">';
                echo '<strong>❌ Invalid Email!</strong><br>';
                echo 'Please enter a valid email address.';
                echo '</div>';
            }
        }
        ?>

        <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #ddd; color: #666; font-size: 14px;">
            <strong>Troubleshooting Tips:</strong>
            <ul>
                <li>For Gmail: Use an App Password, not your regular password</li>
                <li>Check if your hosting provider blocks outgoing SMTP connections</li>
                <li>Verify the SMTP port is not blocked by firewall</li>
                <li>Try both TLS (port 587) and SSL (port 465)</li>
                <li>Check server error logs for detailed error messages</li>
            </ul>
        </div>
    </div>
</body>
</html>
