<?php
require "core.php";

// Check if preview mode
$isPreview = isset($_GET['preview']) && $_GET['preview'] == 1 && isset($_SESSION['user_email']);
$previewId = isset($_GET['preview_id']) ? intval($_GET['preview_id']) : 0;

// Get post slug from URL
$slug = isset($_GET['slug']) ? cleardata($_GET['slug']) : '';

if (empty($slug)) {
    header('Location: ' . SITE_URL . '/Post');
    exit;
}

// Get blog post (include drafts if preview mode)
$statusCondition = $isPreview ? "" : "AND bp.post_status = 'published'";
$stmt = $connect->prepare("SELECT bp.*, bc.blog_cat_name, bc.blog_cat_slug, 
                           u.user_name, u.user_bio, u.user_facebook, u.user_twitter, 
                           u.user_instagram, u.user_linkedin, u.user_website
                           FROM blog_posts bp
                           LEFT JOIN blog_categories bc ON bp.post_category = bc.blog_cat_id
                           LEFT JOIN users u ON bp.post_author = u.user_id
                           WHERE bp.post_slug = :slug $statusCondition");
$stmt->execute([':slug' => $slug]);
$post = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$post) {
    header('Location: ' . SITE_URL . '/Post');
    exit;
}

// Increment view count (not in preview mode)
if (!$isPreview) {
    $connect->prepare("UPDATE blog_posts SET post_views = post_views + 1 WHERE post_id = :id")
            ->execute([':id' => $post['post_id']]);
}

// Get related posts
$relatedPosts = [];
if ($post['post_category']) {
    $stmt = $connect->prepare("SELECT * FROM blog_posts 
                               WHERE post_category = :cat AND post_id != :id AND post_status = 'published'
                               ORDER BY published_at DESC LIMIT 3");
    $stmt->execute([':cat' => $post['post_category'], ':id' => $post['post_id']]);
    $relatedPosts = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// SEO
$titleSeoHeader = getSeoTitle($translation['tr_1'], $post['post_seo_title'] ?: $post['post_title']);
$descriptionSeoHeader = getSeoDescription($translation['tr_3'], $post['post_seo_description'] ?: strip_tags($post['post_excerpt']));
$canonicalUrl = SITE_URL . '/Post/' . $post['post_slug'];
$pageTitle = $post['post_title'];

// Set itemDetails for ad views
$itemDetails = [
    'page_ad_header' => 1,
    'page_ad_footer' => 1,
    'page_footer' => 1
];

include './header.php';
include './sections/header.php';
include './sections/views/header-ad.view.php';

// Show preview banner if in preview mode
if ($isPreview && isset($_SESSION['user_email'])) {
    echo '<div style="background: #ff9800; color: white; padding: 15px; text-align: center; position: sticky; top: 0; z-index: 9999; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">';
    echo '<strong>🔍 PREVIEW MODE</strong> - This is how your post will look on the website';
    echo '<a href="' . SITE_URL . '/admin/controller/edit_blog.php?id=' . $post['post_id'] . '" style="color: white; text-decoration: underline; margin-left: 15px; font-weight: bold;">← Back to Editor</a>';
    echo '</div>';
}

include './views/single-blog.view.php';
include './sections/views/footer-ad.view.php';
include './sections/footer.php';
include './footer.php';
?>
