<?php

session_start();

require '../../config.php';
require '../admin_config.php';
require '../functions.php';
require '../views/header.view.php';

if (isset($_SESSION['user_email'])){

$connect = connect();
if(!$connect){
    header('Location: ./error.php');
}

$check_access = check_access($connect);

if ($check_access['user_role'] == 1 || $check_access['user_role'] == 2){
    
    // Handle form submission
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'update_profile') {
        
        $user_id = $_SESSION['user_id'];
        $user_bio = cleardata($_POST['user_bio']);
        $user_facebook = cleardata($_POST['user_facebook']);
        $user_twitter = cleardata($_POST['user_twitter']);
        $user_instagram = cleardata($_POST['user_instagram']);
        $user_linkedin = cleardata($_POST['user_linkedin']);
        $user_website = cleardata($_POST['user_website']);
        
        $stmt = $connect->prepare("UPDATE users SET 
            user_bio = :bio,
            user_facebook = :facebook,
            user_twitter = :twitter,
            user_instagram = :instagram,
            user_linkedin = :linkedin,
            user_website = :website
            WHERE user_id = :id");
        
        $stmt->execute([
            ':bio' => $user_bio,
            ':facebook' => $user_facebook,
            ':twitter' => $user_twitter,
            ':instagram' => $user_instagram,
            ':linkedin' => $user_linkedin,
            ':website' => $user_website,
            ':id' => $user_id
        ]);
        
        $success = "Author profile updated successfully!";
    }
    
    // Get current user data
    $user_id = $_SESSION['user_id'];
    $stmt = $connect->prepare("SELECT * FROM users WHERE user_id = :id");
    $stmt->execute([':id' => $user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    require '../views/author_profile.view.php';
	
}else{
	header('Location:'.SITE_URL);
}

require '../views/footer.view.php';

}else{
	header('Location: ./login.php');	
}

?>
