# Blog Categories & Preview Features

## ✅ What's New:

### 1. Blog Categories Management
- **Full CRUD** (Create, Read, Update, Delete)
- **Post count** for each category
- **Active/Inactive** status
- **Auto-slug generation**
- **Easy to use interface**

### 2. Preview System
- **Preview before publish** - See how draft posts will look
- **Preview after publish** - Check published posts
- **Live view button** - Opens actual blog post (only for published)
- **Preview banner** - Shows you're in preview mode with back button

### 3. Enhanced Sidebar
- **Blog submenu** with:
  - All Posts
  - Add New
  - Categories

---

## 📋 How to Use:

### Managing Blog Categories:

1. **Access Categories:**
   - Admin → Blog → Categories
   - Or: `http://localhost/alone/admin/controller/blog_categories.php`

2. **Add New Category:**
   - Enter category name (e.g., "Tech News")
   - Slug auto-generates (or enter custom)
   - Add description (optional)
   - Click "Add Category"

3. **Edit Category:**
   - Click edit icon on any category
   - Modify name, slug, description
   - Change status (Active/Inactive)
   - Click "Update Category"

4. **Delete Category:**
   - Click delete icon
   - Confirm deletion
   - Posts won't be deleted, just uncategorized

### Using Preview Feature:

#### From Post Editor:
1. **While Editing:**
   - Click "Preview" button (blue)
   - Opens in new tab showing how post will look
   - Orange banner shows "PREVIEW MODE"
   - Click "Back to Editor" to continue editing

2. **After Publishing:**
   - Click "View Live" button (green)
   - Opens actual published post on your site
   - No preview banner (real page)

#### From Posts List:
1. **Preview Button** (eye icon, blue):
   - Shows preview for any post (draft or published)
   - Opens in new tab

2. **View Live Button** (external link icon, green):
   - Only shows for published posts
   - Opens actual blog post URL

---

## 🎨 Button Colors:

### In Editor:
- **Blue (Save/Update)** - Primary action
- **Blue (Preview)** - See how it looks
- **Green (View Live)** - Open published post

### In Posts List:
- **Blue (Edit)** - Edit post
- **Blue (Preview)** - Preview post
- **Green (View Live)** - Open live post (published only)
- **Red (Delete)** - Delete post

---

## 📁 File Structure:

**New Files:**
- `admin/controller/blog_categories.php` - Categories management
- `admin/controller/blog_preview.php` - Preview handler
- `admin/views/blog_categories.view.php` - Categories UI

**Updated Files:**
- `admin/views/sidebar.view.php` - Added submenu
- `admin/views/blog.editor.view.php` - Added preview buttons
- `admin/views/blog.posts.view.php` - Added preview/live buttons

---

## 🔧 Features Explained:

### 1. Category Management
**Why it's useful:**
- Organize posts by topic
- Filter posts on frontend
- Better SEO and navigation
- Track posts per category

**Default Categories:**
- Tech News
- Shopping Tips
- Deal Alerts
- Product Reviews
- Lifestyle

**You can:**
- Add unlimited categories
- Edit existing ones
- Deactivate without deleting
- See post count for each

### 2. Preview System
**Why it's useful:**
- Check formatting before publishing
- See how images look
- Test links and content
- Review SEO appearance
- Show to team for approval

**Preview vs Live:**
- **Preview**: Works for drafts and published posts
- **Live**: Only for published posts, actual URL

**Preview Banner:**
- Orange bar at top
- Shows "PREVIEW MODE"
- "Back to Editor" link
- Sticky (stays visible when scrolling)

---

## 💡 Workflow Examples:

### Creating a New Post:
1. Admin → Blog → Add New
2. Write title and content
3. Select category
4. Upload featured image
5. Click "Preview" to check
6. If good, change status to "Published"
7. Click "Update Post"
8. Click "View Live" to see on site

### Editing Published Post:
1. Admin → Blog → All Posts
2. Click edit on post
3. Make changes
4. Click "Preview" to check changes
5. Click "Update Post"
6. Click "View Live" to verify

### Managing Categories:
1. Admin → Blog → Categories
2. Add new categories as needed
3. Edit names/descriptions
4. Deactivate unused ones
5. Delete if no longer needed

---

## 🎯 Tips:

### Categories:
- Use clear, descriptive names
- Keep slugs short and SEO-friendly
- Add descriptions for better context
- Don't create too many (5-10 is good)

### Preview:
- Always preview before publishing
- Check on mobile (resize browser)
- Test all links
- Verify images load correctly
- Check formatting and spacing

### Publishing:
- Use "Draft" while writing
- Use "Preview" to review
- Use "Published" when ready
- Use "View Live" to verify

---

## 🚀 Quick Access:

**Admin URLs:**
- All Posts: `/admin/controller/blog.php`
- Add New: `/admin/controller/new_blog.php`
- Categories: `/admin/controller/blog_categories.php`
- Preview: `/admin/controller/blog_preview.php?id=POST_ID`

**Frontend URLs:**
- Blog Home: `/blog`
- Single Post: `/blog/POST-SLUG`
- Category: `/blog?category=CAT_ID`

---

## ✅ Everything is Ready!

You can now:
- ✅ Manage blog categories
- ✅ Preview posts before publishing
- ✅ Preview published posts
- ✅ View live posts
- ✅ Organize content better

**Start using it now!** 🎉
