# Blog Access Guide 🎯

## Frontend URLs

### Direct Access
- **Blog List**: `http://localhost/alone/blog`
- **Single Post**: `http://localhost/alone/single-blog?slug=your-post-slug`
- **Category Filter**: `http://localhost/alone/blog?category=category-slug`

### Using Routes Class (in PHP)
```php
// Blog list page
$urlPath->blog()

// Single blog post
$urlPath->blogPost('your-post-slug')

// Blog category
$urlPath->blogCategory('category-slug')
```

## Add Blog to Navigation Menu

### Method 1: Through Admin Panel (Recommended)
1. Go to **Admin Dashboard**
2. Navigate to **Menus** → **Navigations**
3. Click **Add Navigation** button
4. Fill in the form:
   - **Label**: `Blog` (or any name you want)
   - **Type**: Select `Custom URL`
   - **URL**: `/blog`
   - **Menu**: Select your main menu (usually "Header Menu" or "Main Menu")
   - **Order**: Choose position (e.g., 3 to place it third)
   - **Target**: `_self` (same window)
5. Click **Save**
6. The blog link will now appear in your site navigation

### Method 2: Manual Database Insert
```sql
INSERT INTO navigations (navigation_label, navigation_url, navigation_type, navigation_menu, navigation_order, navigation_target) 
VALUES ('Blog', '/blog', 'custom', 1, 3, '_self');
```
(Change `navigation_menu` to your menu ID and `navigation_order` to desired position)

## Admin Access

### Blog Management
- **All Posts**: `http://localhost/alone/admin/controller/blog.posts.php`
- **Add New Post**: `http://localhost/alone/admin/controller/blog.editor.php`
- **Edit Post**: `http://localhost/alone/admin/controller/edit_blog.php?id=POST_ID`
- **Categories**: `http://localhost/alone/admin/controller/blog_categories.php`

### Quick Access from Admin Sidebar
1. Login to admin dashboard
2. Look for **Blog** in the left sidebar
3. Submenu options:
   - All Posts
   - Add New
   - Categories

## Features Available

### Frontend
✅ Blog listing with pagination
✅ Single post view with comments
✅ Category filtering
✅ Related posts
✅ Recent posts sidebar
✅ Author information
✅ View counter
✅ Tags display
✅ Featured images with CDN support
✅ SEO optimized (meta tags, schema)

### Admin
✅ Rich text editor (Quill)
✅ Featured images
✅ Categories management
✅ Draft/Published status
✅ Featured posts
✅ SEO settings per post
✅ Tags support
✅ Preview before publish
✅ View live post
✅ Inline category creation

## Example Usage in Templates

### Link to Blog in Header/Footer
```php
<a href="<?php echo $urlPath->blog(); ?>">Blog</a>
```

### Link to Specific Post
```php
<a href="<?php echo $urlPath->blogPost($post['post_slug']); ?>">
    <?php echo $post['post_title']; ?>
</a>
```

### Link to Category
```php
<a href="<?php echo $urlPath->blogCategory($category['blog_cat_slug']); ?>">
    <?php echo $category['blog_cat_name']; ?>
</a>
```

## Testing Checklist

- [ ] Access blog list page
- [ ] Click on a blog post
- [ ] Test category filtering
- [ ] Check mobile responsiveness
- [ ] Verify images load correctly
- [ ] Test preview from admin
- [ ] Create a new post
- [ ] Add blog link to navigation menu

## Next Steps

1. **Add to Navigation**: Follow Method 1 above to add blog to your menu
2. **Create Content**: Write your first blog posts
3. **Customize Design**: Edit `views/blog.view.php` and `views/single-blog.view.php` if needed
4. **SEO Setup**: Configure meta titles and descriptions for each post
5. **Share**: Promote your blog posts on social media

## Support

If the blog link doesn't appear in navigation after adding it:
1. Clear browser cache
2. Check if the navigation menu ID is correct
3. Verify the navigation order doesn't conflict with existing items
4. Check database to ensure the record was inserted
