<script>
// Wait for cookieconsent to be available
function initCookieConsent() {
    if (typeof window.cookieconsent !== 'undefined' && window.cookieconsent.initialise) {
        window.cookieconsent.initialise({
            "theme": "classic",
            "content": {
                "message": "<?php echo echoOutput($translation['tr_201']); ?>",
                "dismiss": "<?php echo echoOutput($translation['tr_203']); ?>",
                "link": "<?php echo echoOutput($translation['tr_202']); ?>",
                "href": '<?php echo $urlPath->terms(); ?>'
            }
        });
    } else {
        // Retry after a short delay if cookieconsent is not ready
        setTimeout(initCookieConsent, 100);
    }
}

// Initialize when DOM is ready
if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', initCookieConsent);
} else {
    initCookieConsent();
}
</script>