<script>
// Wait for cookieconsent to be available
function initCookieConsent() {
    if (typeof window.cookieconsent !== 'undefined' && window.cookieconsent.initialise) {
        window.cookieconsent.initialise({
            "palette": {
                "popup": {
                    "background": "#efefef",
                    "text": "#404040"
                },
                "button": {
                    "background": "#8ec760",
                    "text": "#ffffff"
                }
            },
            "theme": "classic",
            "content": {
                "message": "<?php echo echoOutput($translation['tr_115']); ?>",
                "dismiss": "<?php echo echoOutput($translation['tr_117']); ?>",
                "link": "<?php echo echoOutput($translation['tr_114']); ?>",
                "href": '<?php echo $urlPath->terms(); ?>'
            }
        });
    } else {
        // Retry after a short delay if cookieconsent is not ready
        setTimeout(initCookieConsent, 100);
    }
}

// Initialize when DOM is ready
if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', initCookieConsent);
} else {
    initCookieConsent();
}
</script>