<?php require 'sidebar.php'; ?>

<!--Page Container-->
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="section-title">
          <h5 class="text-truncate">Store Image Import from URL</h5>
        </div>

        <?php if (!empty($message)): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
          <i class="fas fa-check-circle"></i> <?php echo $message; ?>
          <button type="button" class="close" data-dismiss="alert" aria-label="Close" title="Close Alert">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <?php endif; ?>

        <?php if (!empty($error_message)): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
          <i class="fas fa-exclamation-circle"></i> <?php echo $error_message; ?>
          <button type="button" class="close" data-dismiss="alert" aria-label="Close" title="Close Alert">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <?php endif; ?>

        <div class="row">
          
          <!-- Single Image Import -->
          <div class="col-md-6">
            <div class="block">
              <div class="block-heading">
                <h3><i class="fas fa-image"></i> Import Single Store Image</h3>
              </div>
              <div class="block-content">
                <form method="post" id="singleImportForm">
                  <input type="hidden" name="action" value="import_single">
                  
                  <div class="form-group">
                    <label>Select Store:</label>
                    <select name="store_id" class="form-control" required>
                      <option value="">Choose a store...</option>
                      <?php foreach ($stores as $store): ?>
                      <option value="<?php echo $store['store_id']; ?>">
                        <?php echo htmlspecialchars($store['store_title']); ?>
                        <?php if (!empty($store['store_image'])): ?>
                        (Has Image)
                        <?php endif; ?>
                      </option>
                      <?php endforeach; ?>
                    </select>
                  </div>
                  
                  <div class="form-group">
                    <label>Image URL:</label>
                    <input type="url" name="image_url" class="form-control" 
                           placeholder="https://example.com/store-logo.png" required>
                    <small class="form-text text-muted">
                      Supported formats: JPG, PNG, GIF, WebP
                    </small>
                  </div>
                  
                  <button type="submit" class="btn btn-primary">
                    <i class="fas fa-download"></i> Import Image
                  </button>
                </form>
              </div>
            </div>
          </div>

          <!-- Bulk Image Import -->
          <div class="col-md-6">
            <div class="block">
              <div class="block-heading">
                <h3><i class="fas fa-images"></i> Bulk Image Import</h3>
              </div>
              <div class="block-content">
                <form method="post" id="bulkImportForm">
                  <input type="hidden" name="action" value="import_bulk">
                  
                  <div class="form-group">
                    <label>Import Data (CSV Format):</label>
                    <textarea name="bulk_data" class="form-control" rows="8" 
                              placeholder="store_id,image_url&#10;1,https://example.com/store1-logo.png&#10;2,https://example.com/store2-logo.png&#10;3,https://example.com/store3-logo.png" required></textarea>
                    <small class="form-text text-muted">
                      Format: store_id,image_url (one per line)<br>
                      Example: 1,https://example.com/store-logo.png
                    </small>
                  </div>
                  
                  <button type="submit" class="btn btn-success">
                    <i class="fas fa-upload"></i> Bulk Import Images
                  </button>
                </form>
              </div>
            </div>
          </div>

        </div>

        <!-- Current Stores -->
        <div class="row">
          <div class="col-12">
            <div class="block">
              <div class="block-heading">
                <h3><i class="fas fa-store"></i> Current Stores</h3>
              </div>
              <div class="block-content">
                <div class="table-responsive">
                  <table class="table table-striped">
                    <thead>
                      <tr>
                        <th>ID</th>
                        <th>Store Name</th>
                        <th>Current Image</th>
                        <th>Status</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach ($stores as $store): ?>
                      <tr>
                        <td><?php echo $store['store_id']; ?></td>
                        <td><?php echo htmlspecialchars($store['store_title']); ?></td>
                        <td>
                          <?php if (!empty($store['store_image'])): ?>
                          <img src="../../images/<?php echo $store['store_image']; ?>" 
                               class="img-thumbnail" style="width: 50px; height: 50px; object-fit: cover;" alt="<?php echo htmlspecialchars($store['store_title']); ?>">
                          <?php else: ?>
                          <span class="text-muted">No Image</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <?php if (!empty($store['store_image'])): ?>
                          <span class="badge badge-success">Has Image</span>
                          <?php else: ?>
                          <span class="badge badge-warning">No Image</span>
                          <?php endif; ?>
                        </td>
                      </tr>
                      <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Instructions -->
        <div class="row">
          <div class="col-12">
            <div class="block">
              <div class="block-heading">
                <h3><i class="fas fa-info-circle"></i> Instructions</h3>
              </div>
              <div class="block-content">
                <div class="row">
                  <div class="col-md-6">
                    <h5>Single Image Import:</h5>
                    <ul>
                      <li>Select a store from the dropdown</li>
                      <li>Enter the image URL</li>
                      <li>Click "Import Image" to download and save</li>
                      <li>Image will be automatically resized and optimized</li>
                    </ul>
                  </div>
                  <div class="col-md-6">
                    <h5>Bulk Image Import:</h5>
                    <ul>
                      <li>Use CSV format: store_id,image_url</li>
                      <li>One entry per line</li>
                      <li>Example: 1,https://example.com/logo.png</li>
                      <li>All images will be processed automatically</li>
                    </ul>
                  </div>
                </div>
                <div class="alert alert-info">
                  <strong>Supported Image Formats:</strong> JPG, JPEG, PNG, GIF, WebP<br>
                  <strong>Maximum File Size:</strong> 5MB per image<br>
                  <strong>Recommended Size:</strong> 300x300 pixels or larger
                </div>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>

<script>
$(document).ready(function() {
    // Form validation
    $('#singleImportForm').on('submit', function(e) {
        var storeId = $('select[name="store_id"]').val();
        var imageUrl = $('input[name="image_url"]').val();
        
        if (!storeId || !imageUrl) {
            e.preventDefault();
            alert('Please select a store and enter an image URL.');
            return false;
        }
        
        // Show loading state
        $(this).find('button[type="submit"]').html('<i class="fas fa-spinner fa-spin"></i> Importing...').prop('disabled', true);
    });
    
    $('#bulkImportForm').on('submit', function(e) {
        var bulkData = $('textarea[name="bulk_data"]').val().trim();
        
        if (!bulkData) {
            e.preventDefault();
            alert('Please enter bulk import data.');
            return false;
        }
        
        // Validate CSV format
        var lines = bulkData.split('\n');
        var isValid = true;
        
        for (var i = 0; i < lines.length; i++) {
            var line = lines[i].trim();
            if (line && !line.match(/^\d+,\s*https?:\/\/.+/)) {
                isValid = false;
                break;
            }
        }
        
        if (!isValid) {
            e.preventDefault();
            alert('Invalid CSV format. Please use: store_id,image_url');
            return false;
        }
        
        // Show loading state
        $(this).find('button[type="submit"]').html('<i class="fas fa-spinner fa-spin"></i> Importing...').prop('disabled', true);
    });
    
    // Auto-fill store ID in bulk import
    $('select[name="store_id"]').on('change', function() {
        var storeId = $(this).val();
        var storeName = $(this).find('option:selected').text();
        
        if (storeId) {
            var currentBulkData = $('textarea[name="bulk_data"]').val();
            if (!currentBulkData) {
                $('textarea[name="bulk_data"]').val(storeId + ',https://example.com/' + storeName.toLowerCase().replace(/\s+/g, '-') + '-logo.png');
            }
        }
    });
});
</script>
