<?php require'sidebar.php'; ?>

<!--Page Container--> 
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><?php echo _ADDITEM; ?></h5>
            </div>
          </div>

          <div class="col-md-12">
            <div class="form-block mb-4">

              <form enctype="multipart/form-data" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post">

                <div class="form-row">
                  <div class="form-group col-md-9">
                    <div class="block col-md-12">

                      <input type="hidden" value="<?php echo $check_access['user_id']; ?>" name="coupon_author">

                      <label class="required"><?php echo _TABLEFIELDTITLE; ?></label>
                      <input type="text" placeholder="Enter coupon title" name="coupon_title" class="form-control" required="">

                      <label><?php echo _TABLEFIELDDESCRIPTION; ?></label>
                      <textarea type="text" class="form-control" name="coupon_description"></textarea>

                      <label><?php echo _TABLEFIELDTAGLINE; ?></label>
                      <input type="text" placeholder="Enter coupon tagline" name="coupon_tagline" class="form-control">

                     <div class="row">

                      <div class="col-4">
                        <label class="required"><?php echo _TABLEFIELDCATEGORY; ?></label>
                        <select class="custom-select form-control" name="coupon_category" id="categories-dropdown" required="">
                            <option value="-" selected>---</option>
                          <?php foreach($categories as $item): ?>
                            <option value="<?php echo $item['category_id']; ?>"><?php echo $item['category_title']; ?></option>
                          <?php endforeach; ?>
                        </select>
                      </div>

                      <div class="col-4">
                        <label><?php echo _TABLEFIELDSUBCATEGORY; ?></label>
                        <select class="custom-select form-control" name="coupon_subcategory" id="subcategories-dropdown">
                            <option value="" selected>---</option>
                        </select>
                      </div>
                      
                    <div class="col-4">
                      <label><?php echo _TABLEFIELDSTORE; ?></label>
                      <select class="custom-select form-control" name="coupon_store">
                            <option value="-" selected>---</option>
                      <?php foreach($stores as $item): ?>
                            <option value="<?php echo $item['store_id']; ?>"><?php echo $item['store_title']; ?></option>
                          <?php endforeach; ?>
                      </select>
                    </div>
                  
                    </div>

                     <div class="row">

                      <div class="col-4">
                        <label><?php echo _TABLEFIELDCODE; ?></label>
                      <input type="text" placeholder="Leave empty to create an OFFER" name="coupon_code" class="form-control" id="new-coupon-code-input">
                      </div>

                      <div class="col-4">
                        <label>Coupon Type</label>
                        <div class="form-control" id="new-coupon-type-display" style="background-color: #f8f9fa; border: 1px solid #dee2e6;">
                          <span class="badge badge-warning">OFFER</span> - Will show "Get Offer" button
                        </div>
                      </div>

                      <div class="col-4">
                        <label><?php echo _TABLEFIELDSTART; ?></label>
                        <div class="input-group">
                            <span class="input-group-addon text-primary"><i class="dripicons-calendar"></i></span>
                            <input class="form-control" name="coupon_start" type="text" id="start-date">
                        </div>
                      </div>

                      <div class="col-4">
                        <label><?php echo _TABLEFIELDEXPIRE; ?></label>
                        <div class="input-group">
                            <span class="input-group-addon text-primary"><i class="dripicons-calendar"></i></span>
                            <input class="form-control" name="coupon_expire" type="text" id="end-date">
                            <a class="input-group-addon text-danger clearexpiry"><i class="dripicons-cross"></i></a>
                        </div>
                      </div>

                    </div>

                   <label class="required"><?php echo _TABLEFIELDURLLINK; ?></label>
                   <input type="text" placeholder="Enter affiliate URL manually or generate one below" name="coupon_link" class="form-control" required="" id="coupon-link-input">

                   <div class="uk-margin mt-3">
                     <button type="button" class="btn btn-secondary btn-sm" id="toggle-coupon-affiliate-section">
                       <i class="fa fa-link"></i> Toggle Affiliate Link Generation
                     </button>
                   </div>

                   <div id="coupon-affiliate-section" style="display: none;" class="row mt-3">
                     <div class="col-6">
                       <label>Affiliate Program</label>
                       <select class="custom-select form-control" name="affiliate_program" id="coupon-affiliate-program-select">
                         <option value="">Select Program</option>
                         <?php
                         $stmt = $connect->prepare("SELECT * FROM affiliate_programs WHERE status = 1 ORDER BY program_name");
                         $stmt->execute();
                         $affiliate_programs = $stmt->fetchAll(PDO::FETCH_ASSOC);
                         foreach($affiliate_programs as $program) {
                             $api_status = empty($program['api_key']) ? ' (API Key Required)' : '';
                             echo '<option value="' . $program['program_name'] . '">' . $program['program_name'] . $api_status . '</option>';
                         }
                         ?>
                       </select>
                     </div>
                     <div class="col-6">
                       <label>&nbsp;</label>
                       <button type="button" class="btn btn-info btn-sm form-control" id="generate-coupon-affiliate-link">
                         <i class="fa fa-link"></i> Generate Affiliate Link
                       </button>
                     </div>
                   </div>

                   <div class="row">

                    <div class="col-4">
                      <label class="control-label"><?php echo _TABLEFIELDFEATURED; ?></label>
                      <select class="custom-select form-control" name="coupon_featured">
                        <option value="0"><?php echo _NOTEXT; ?></option>
                        <option value="1"><?php echo _YESTEXT; ?></option>
                      </select>
                    </div>

                    <div class="col-4">
                      <label class="control-label"><?php echo _TABLEFIELDVERIFY; ?></label>
                      <select class="custom-select form-control" name="coupon_verify">
                        <option value="0"><?php echo _NOTEXT; ?></option>
                        <option value="1"><?php echo _YESTEXT; ?></option>
                      </select>
                    </div>

                    <div class="col-4">
                      <label class="control-label"><?php echo _TABLEFIELDEXCLUSIVE; ?></label>
                      <select class="custom-select form-control" name="coupon_exclusive">
                        <option value="0"><?php echo _NOTEXT; ?></option>
                        <option value="1"><?php echo _YESTEXT; ?></option>
                      </select>
                    </div>


                  </div>

                   <br>

                   <fieldset>
                    <legend><?php echo _SEO; ?></legend>

                    <label class="no-margin-top"><?php echo _SEOTITLE; ?></label>
                    <input type="text" placeholder="Enter SEO title" name="coupon_seotitle" class="form-control">


                    <label><?php echo _SEODESCRIPTION; ?></label>
                    <textarea type="text" class="mceNoEditor form-control" name="coupon_seodescription"></textarea>

                  </fieldset>

                </div>
              </div>
              <div class="form-group col-md-3 sidebar">

               <div class="block col-md-12">
                 <label><?php echo _TABLEFIELDSTATUS; ?></label>

                 <select class="custom-select form-control" name="coupon_status" required="">
                  <option value="1" selected=""><?php echo _ENABLED; ?></option>
                  <option value="2"><?php echo _DISABLED; ?></option>
                  <option value="3"><?php echo _PENDING; ?></option>
                </select>

              </div>

              <div class="block col-md-12">
                <label><?php echo _TABLEFIELDIMAGE; ?></label>

                <div class="new-image" id="image-preview">
                  <label for="image-upload" id="image-label"><?php echo _CHOOSEFILE; ?></label>
                  <input type="file" name="coupon_image" id="image-upload" />
                </div>

                <span class="text-danger recomendedsize"><?php echo _RECOMMENDEDSIZE; ?> <b>650 x 350</b> </span>
                <br/>
              </div>

              <button class="btn btn-primary" type="submit" name="save"><?php echo _SAVECHANGES; ?></button>

            </div>
          </div>

        </form>
      </div>
    </div>
  </div>
  </div>
</div>
</div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle affiliate section for new coupons
    const toggleBtn = document.getElementById('toggle-coupon-affiliate-section');
    const affiliateSection = document.getElementById('coupon-affiliate-section');
    
    if (toggleBtn && affiliateSection) {
        toggleBtn.addEventListener('click', function() {
            if (affiliateSection.style.display === 'none') {
                affiliateSection.style.display = 'block';
                toggleBtn.innerHTML = '<i class="fa fa-link"></i> Hide Affiliate Link Generation';
            } else {
                affiliateSection.style.display = 'none';
                toggleBtn.innerHTML = '<i class="fa fa-link"></i> Show Affiliate Link Generation';
            }
        });
    }

    const generateBtn = document.getElementById('generate-coupon-affiliate-link');
    const couponLinkInput = document.getElementById('coupon-link-input');
    const programSelect = document.getElementById('coupon-affiliate-program-select');

    if (generateBtn) {
        generateBtn.addEventListener('click', function() {
            const couponUrl = couponLinkInput.value.trim();
            const program = programSelect.value;

            if (!couponUrl) {
                alert('Please enter a Coupon URL first');
                return;
            }

            if (!program) {
                alert('Please select an Affiliate Program');
                return;
            }

            // Validate URL
            try {
                new URL(couponUrl);
            } catch (e) {
                alert('Please enter a valid URL (e.g., https://example.com)');
                return;
            }

            // Show loading state
            generateBtn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Generating...';
            generateBtn.disabled = true;

            // Make AJAX request to generate affiliate link
            fetch('../controller/affiliate_link_generator.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `action=generate&program=${encodeURIComponent(program)}&url=${encodeURIComponent(couponUrl)}`
            })
            .then(response => response.json())
            .then(data => {
                 if (data.success) {
                     couponLinkInput.value = data.affiliate_url;
                     alert('Affiliate link generated successfully! You can edit it manually if needed.');
                 } else {
                     alert('Error: ' + data.message);
                 }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error generating affiliate link. Please try again.');
            })
            .finally(() => {
                // Reset button state
                generateBtn.innerHTML = '<i class="fa fa-link"></i> Generate Affiliate Link';
                generateBtn.disabled = false;
            });
        });
    }
});

// Dynamic coupon type display for new coupon
const newCouponCodeInput = document.getElementById('new-coupon-code-input');
const newCouponTypeDisplay = document.getElementById('new-coupon-type-display');

if (newCouponCodeInput && newCouponTypeDisplay) {
    function updateNewCouponType() {
        const codeValue = newCouponCodeInput.value.trim();
        if (codeValue === '') {
            newCouponTypeDisplay.innerHTML = '<span class="badge badge-warning">OFFER</span> - Will show "Get Offer" button';
        } else {
            newCouponTypeDisplay.innerHTML = '<span class="badge badge-success">COUPON</span> - Will show "Get Code" button';
        }
    }
    
    newCouponCodeInput.addEventListener('input', updateNewCouponType);
    newCouponCodeInput.addEventListener('blur', updateNewCouponType);
}
</script>

               <div class="block col-md-12">
                 <label><?php echo _TABLEFIELDSTATUS; ?></label>

                 <select class="custom-select form-control" name="coupon_status" required="">
                  <option value="1" selected=""><?php echo _ENABLED; ?></option>
                  <option value="2"><?php echo _DISABLED; ?></option>
                  <option value="3"><?php echo _PENDING; ?></option>
                </select>

              </div>

              <div class="block col-md-12">
                <label><?php echo _TABLEFIELDIMAGE; ?></label>

                <div class="new-image" id="image-preview">
                  <label for="image-upload" id="image-label"><?php echo _CHOOSEFILE; ?></label>
                  <input type="file" name="coupon_image" id="image-upload" />
                </div>

                <span class="text-danger recomendedsize"><?php echo _RECOMMENDEDSIZE; ?> <b>650 x 350</b> </span>
                <br/>
              </div>

              <button class="btn btn-primary" type="submit" name="save"><?php echo _SAVECHANGES; ?></button>

            </div>
          </div>

        </form>
      </div>
    </div>
  </div>
  </div>
</div>
</div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle affiliate section for new coupons
    const toggleBtn = document.getElementById('toggle-coupon-affiliate-section');
    const affiliateSection = document.getElementById('coupon-affiliate-section');
    
    if (toggleBtn && affiliateSection) {
        toggleBtn.addEventListener('click', function() {
            if (affiliateSection.style.display === 'none') {
                affiliateSection.style.display = 'block';
                toggleBtn.innerHTML = '<i class="fa fa-link"></i> Hide Affiliate Link Generation';
            } else {
                affiliateSection.style.display = 'none';
                toggleBtn.innerHTML = '<i class="fa fa-link"></i> Show Affiliate Link Generation';
            }
        });
    }

    const generateBtn = document.getElementById('generate-coupon-affiliate-link');
    const couponLinkInput = document.getElementById('coupon-link-input');
    const programSelect = document.getElementById('coupon-affiliate-program-select');

    if (generateBtn) {
        generateBtn.addEventListener('click', function() {
            const couponUrl = couponLinkInput.value.trim();
            const program = programSelect.value;

            if (!couponUrl) {
                alert('Please enter a Coupon URL first');
                return;
            }

            if (!program) {
                alert('Please select an Affiliate Program');
                return;
            }

            // Validate URL
            try {
                new URL(couponUrl);
            } catch (e) {
                alert('Please enter a valid URL (e.g., https://example.com)');
                return;
            }

            // Show loading state
            generateBtn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Generating...';
            generateBtn.disabled = true;

            // Make AJAX request to generate affiliate link
            fetch('../controller/affiliate_link_generator.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `action=generate&program=${encodeURIComponent(program)}&url=${encodeURIComponent(couponUrl)}`
            })
            .then(response => response.json())
            .then(data => {
                 if (data.success) {
                     couponLinkInput.value = data.affiliate_url;
                     alert('Affiliate link generated successfully! You can edit it manually if needed.');
                 } else {
                     alert('Error: ' + data.message);
                 }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error generating affiliate link. Please try again.');
            })
            .finally(() => {
                // Reset button state
                generateBtn.innerHTML = '<i class="fa fa-link"></i> Generate Affiliate Link';
                generateBtn.disabled = false;
            });
        });
    }
});

// Dynamic coupon type display for new coupon
const newCouponCodeInput = document.getElementById('new-coupon-code-input');
const newCouponTypeDisplay = document.getElementById('new-coupon-type-display');

if (newCouponCodeInput && newCouponTypeDisplay) {
    function updateNewCouponType() {
        const codeValue = newCouponCodeInput.value.trim();
        if (codeValue === '') {
            newCouponTypeDisplay.innerHTML = '<span class="badge badge-warning">OFFER</span> - Will show "Get Offer" button';
        } else {
            newCouponTypeDisplay.innerHTML = '<span class="badge badge-success">COUPON</span> - Will show "Get Code" button';
        }
    }
    
    newCouponCodeInput.addEventListener('input', updateNewCouponType);
    newCouponCodeInput.addEventListener('blur', updateNewCouponType);
}
</script>

               <div class="block col-md-12">
                 <label><?php echo _TABLEFIELDSTATUS; ?></label>

                 <select class="custom-select form-control" name="coupon_status" required="">
                  <option value="1" selected=""><?php echo _ENABLED; ?></option>
                  <option value="2"><?php echo _DISABLED; ?></option>
                  <option value="3"><?php echo _PENDING; ?></option>
                </select>

              </div>

              <div class="block col-md-12">
                <label><?php echo _TABLEFIELDIMAGE; ?></label>

                <div class="new-image" id="image-preview">
                  <label for="image-upload" id="image-label"><?php echo _CHOOSEFILE; ?></label>
                  <input type="file" name="coupon_image" id="image-upload" />
                </div>

                <span class="text-danger recomendedsize"><?php echo _RECOMMENDEDSIZE; ?> <b>650 x 350</b> </span>
                <br/>
              </div>

              <button class="btn btn-primary" type="submit" name="save"><?php echo _SAVECHANGES; ?></button>

            </div>
          </div>

        </form>
      </div>
    </div>
  </div>
  </div>
</div>
</div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle affiliate section for new coupons
    const toggleBtn = document.getElementById('toggle-coupon-affiliate-section');
    const affiliateSection = document.getElementById('coupon-affiliate-section');
    
    if (toggleBtn && affiliateSection) {
        toggleBtn.addEventListener('click', function() {
            if (affiliateSection.style.display === 'none') {
                affiliateSection.style.display = 'block';
                toggleBtn.innerHTML = '<i class="fa fa-link"></i> Hide Affiliate Link Generation';
            } else {
                affiliateSection.style.display = 'none';
                toggleBtn.innerHTML = '<i class="fa fa-link"></i> Show Affiliate Link Generation';
            }
        });
    }

    const generateBtn = document.getElementById('generate-coupon-affiliate-link');
    const couponLinkInput = document.getElementById('coupon-link-input');
    const programSelect = document.getElementById('coupon-affiliate-program-select');

    if (generateBtn) {
        generateBtn.addEventListener('click', function() {
            const couponUrl = couponLinkInput.value.trim();
            const program = programSelect.value;

            if (!couponUrl) {
                alert('Please enter a Coupon URL first');
                return;
            }

            if (!program) {
                alert('Please select an Affiliate Program');
                return;
            }

            // Validate URL
            try {
                new URL(couponUrl);
            } catch (e) {
                alert('Please enter a valid URL (e.g., https://example.com)');
                return;
            }

            // Show loading state
            generateBtn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Generating...';
            generateBtn.disabled = true;

            // Make AJAX request to generate affiliate link
            fetch('../controller/affiliate_link_generator.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `action=generate&program=${encodeURIComponent(program)}&url=${encodeURIComponent(couponUrl)}`
            })
            .then(response => response.json())
            .then(data => {
                 if (data.success) {
                     couponLinkInput.value = data.affiliate_url;
                     alert('Affiliate link generated successfully! You can edit it manually if needed.');
                 } else {
                     alert('Error: ' + data.message);
                 }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error generating affiliate link. Please try again.');
            })
            .finally(() => {
                // Reset button state
                generateBtn.innerHTML = '<i class="fa fa-link"></i> Generate Affiliate Link';
                generateBtn.disabled = false;
            });
        });
    }
});

// Dynamic coupon type display for new coupon
const newCouponCodeInput = document.getElementById('new-coupon-code-input');
const newCouponTypeDisplay = document.getElementById('new-coupon-type-display');

if (newCouponCodeInput && newCouponTypeDisplay) {
    function updateNewCouponType() {
        const codeValue = newCouponCodeInput.value.trim();
        if (codeValue === '') {
            newCouponTypeDisplay.innerHTML = '<span class="badge badge-warning">OFFER</span> - Will show "Get Offer" button';
        } else {
            newCouponTypeDisplay.innerHTML = '<span class="badge badge-success">COUPON</span> - Will show "Get Code" button';
        }
    }
    
    newCouponCodeInput.addEventListener('input', updateNewCouponType);
    newCouponCodeInput.addEventListener('blur', updateNewCouponType);
}
</script>

               <div class="block col-md-12">
                 <label><?php echo _TABLEFIELDSTATUS; ?></label>

                 <select class="custom-select form-control" name="coupon_status" required="">
                  <option value="1" selected=""><?php echo _ENABLED; ?></option>
                  <option value="2"><?php echo _DISABLED; ?></option>
                  <option value="3"><?php echo _PENDING; ?></option>
                </select>

              </div>

              <div class="block col-md-12">
                <label><?php echo _TABLEFIELDIMAGE; ?></label>

                <div class="new-image" id="image-preview">
                  <label for="image-upload" id="image-label"><?php echo _CHOOSEFILE; ?></label>
                  <input type="file" name="coupon_image" id="image-upload" />
                </div>

                <span class="text-danger recomendedsize"><?php echo _RECOMMENDEDSIZE; ?> <b>650 x 350</b> </span>
                <br/>
              </div>

              <button class="btn btn-primary" type="submit" name="save"><?php echo _SAVECHANGES; ?></button>

            </div>
          </div>

        </form>
      </div>
    </div>
  </div>
  </div>
</div>
</div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle affiliate section for new coupons
    const toggleBtn = document.getElementById('toggle-coupon-affiliate-section');
    const affiliateSection = document.getElementById('coupon-affiliate-section');
    
    if (toggleBtn && affiliateSection) {
        toggleBtn.addEventListener('click', function() {
            if (affiliateSection.style.display === 'none') {
                affiliateSection.style.display = 'block';
                toggleBtn.innerHTML = '<i class="fa fa-link"></i> Hide Affiliate Link Generation';
            } else {
                affiliateSection.style.display = 'none';
                toggleBtn.innerHTML = '<i class="fa fa-link"></i> Show Affiliate Link Generation';
            }
        });
    }

    const generateBtn = document.getElementById('generate-coupon-affiliate-link');
    const couponLinkInput = document.getElementById('coupon-link-input');
    const programSelect = document.getElementById('coupon-affiliate-program-select');

    if (generateBtn) {
        generateBtn.addEventListener('click', function() {
            const couponUrl = couponLinkInput.value.trim();
            const program = programSelect.value;

            if (!couponUrl) {
                alert('Please enter a Coupon URL first');
                return;
            }

            if (!program) {
                alert('Please select an Affiliate Program');
                return;
            }

            // Validate URL
            try {
                new URL(couponUrl);
            } catch (e) {
                alert('Please enter a valid URL (e.g., https://example.com)');
                return;
            }

            // Show loading state
            generateBtn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Generating...';
            generateBtn.disabled = true;

            // Make AJAX request to generate affiliate link
            fetch('../controller/affiliate_link_generator.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `action=generate&program=${encodeURIComponent(program)}&url=${encodeURIComponent(couponUrl)}`
            })
            .then(response => response.json())
            .then(data => {
                 if (data.success) {
                     couponLinkInput.value = data.affiliate_url;
                     alert('Affiliate link generated successfully! You can edit it manually if needed.');
                 } else {
                     alert('Error: ' + data.message);
                 }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error generating affiliate link. Please try again.');
            })
            .finally(() => {
                // Reset button state
                generateBtn.innerHTML = '<i class="fa fa-link"></i> Generate Affiliate Link';
                generateBtn.disabled = false;
            });
        });
    }
});

// Dynamic coupon type display for new coupon
const newCouponCodeInput = document.getElementById('new-coupon-code-input');
const newCouponTypeDisplay = document.getElementById('new-coupon-type-display');

if (newCouponCodeInput && newCouponTypeDisplay) {
    function updateNewCouponType() {
        const codeValue = newCouponCodeInput.value.trim();
        if (codeValue === '') {
            newCouponTypeDisplay.innerHTML = '<span class="badge badge-warning">OFFER</span> - Will show "Get Offer" button';
        } else {
            newCouponTypeDisplay.innerHTML = '<span class="badge badge-success">COUPON</span> - Will show "Get Code" button';
        }
    }
    
    newCouponCodeInput.addEventListener('input', updateNewCouponType);
    newCouponCodeInput.addEventListener('blur', updateNewCouponType);
}
</script>