<section>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="section-title">
                    <h2>Import / Export</h2>
                </div>
            </div>
        </div>

        <?php if (isset($message)): ?>
        <div class="row">
            <div class="col-12">
                <div class="alert alert-info">
                    <?php echo $message; ?>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <div class="row">
            <!-- Export Section -->
            <div class="col-md-6">
                <div class="block">
                    <div class="block-heading">
                        <h3>Export Data</h3>
                    </div>
                    <div class="block-content">
                        <p>Export your data to CSV format for backup or migration purposes.</p>
                        
                        <div class="form-group">
                            <label>Export Type:</label>
                            <select class="form-control" id="export_type">
                                <option value="coupons">Coupons</option>
                                <option value="stores">Stores</option>
                            </select>
                        </div>
                        
                        <button type="button" class="btn btn-primary" onclick="exportData()">
                            <i class="fas fa-download"></i> Export CSV
                        </button>
                    </div>
                </div>
            </div>

            <!-- Import Section -->
            <div class="col-md-6">
                <div class="block">
                    <div class="block-heading">
                        <h3>Import Data</h3>
                    </div>
                    <div class="block-content">
                        <p>Import data from CSV file. Make sure your CSV matches the expected format.</p>
                        
                        <form method="post" enctype="multipart/form-data">
                            <div class="form-group">
                                <label>Import Type:</label>
                                <select class="form-control" name="import_type" required>
                                    <option value="coupons">Coupons</option>
                                    <option value="stores">Stores</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label>CSV File:</label>
                                <input type="file" class="form-control" name="csv_file" accept=".csv" required>
                            </div>
                            
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-upload"></i> Import CSV
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Store Image Import Section -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="block">
                    <div class="block-heading">
                        <h3>Store Image Import from URLs</h3>
                    </div>
                    <div class="block-content">
                        <p>Import store images directly from URLs. You can import single images or bulk import from CSV.</p>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Single Image Import</h5>
                                <form method="post" action="../controller/store_image_import.php">
                                    <input type="hidden" name="action" value="import_single">
                                    
                                    <div class="form-group">
                                        <label>Store ID:</label>
                                        <input type="number" class="form-control" name="store_id" placeholder="Enter store ID" required>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>Image URL:</label>
                                        <input type="url" class="form-control" name="image_url" placeholder="https://example.com/store-logo.png" required>
                                    </div>
                                    
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-download"></i> Import Image
                                    </button>
                                </form>
                            </div>
                            
                            <div class="col-md-6">
                                <h5>Bulk Image Import</h5>
                                <form method="post" action="../controller/store_image_import.php">
                                    <input type="hidden" name="action" value="import_bulk">
                                    
                                    <div class="form-group">
                                        <label>CSV Data (store_id,image_url):</label>
                                        <textarea class="form-control" name="bulk_data" rows="4" 
                                                  placeholder="1,https://example.com/store1-logo.png&#10;2,https://example.com/store2-logo.png&#10;3,https://example.com/store3-logo.png" required></textarea>
                                    </div>
                                    
                                    <button type="submit" class="btn btn-success">
                                        <i class="fas fa-upload"></i> Bulk Import
                                    </button>
                                </form>
                            </div>
                        </div>
                        
                        <div class="alert alert-info mt-3">
                            <strong>Supported Formats:</strong> JPG, PNG, GIF, WebP<br>
                            <strong>Format:</strong> store_id,image_url (one per line for bulk import)
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sample Templates -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="block">
                    <div class="block-heading">
                        <h3>Sample CSV Templates</h3>
                    </div>
                    <div class="block-content">
                        <p>Download sample CSV templates to understand the required format:</p>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Coupons Template</h5>
                                <p>Format: ID, Title, Description, Code, Store, Category, Subcategory, Featured, Exclusive, Verified, Status, Start Date, Expire Date, Created</p>
                                <button type="button" class="btn btn-outline-primary btn-sm" onclick="downloadTemplate('coupons')">
                                    <i class="fas fa-download"></i> Download Template
                                </button>
                            </div>
                            
                            <div class="col-md-6">
                                <h5>Stores Template</h5>
                                <p>Format: ID, Title, Description, SEO Title, SEO Description, Featured, Status, Slug, Image, Affiliate URL, Created</p>
                                <button type="button" class="btn btn-outline-primary btn-sm" onclick="downloadTemplate('stores')">
                                    <i class="fas fa-download"></i> Download Template
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Instructions -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="block">
                    <div class="block-heading">
                        <h3>Instructions</h3>
                    </div>
                    <div class="block-content">
                        <h5>Export:</h5>
                        <ul>
                            <li>Select the data type you want to export</li>
                            <li>Click "Export CSV" to download the file</li>
                            <li>The file will contain all current data in CSV format</li>
                        </ul>
                        
                        <h5>Import:</h5>
                        <ul>
                            <li>Download the appropriate template first</li>
                            <li>Fill in your data following the template format</li>
                            <li>Select the import type and upload your CSV file</li>
                            <li>Make sure store names and category names match existing ones</li>
                        </ul>
                        
                        <div class="alert alert-warning">
                            <strong>Note:</strong> Import will add new records. It will not update existing ones. 
                            Make sure your data doesn't conflict with existing records.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
function exportData() {
    var type = document.getElementById('export_type').value;
    window.location.href = '?action=export&type=' + type;
}

function downloadTemplate(type) {
    var csvContent = '';
    
    if (type === 'coupons') {
        csvContent = 'ID,Title,Description,Code,Store,Category,Subcategory,Featured,Exclusive,Verified,Status,Start Date,Expire Date,Created\n';
        csvContent += '1,Sample Coupon,Get 20% off,SAVE20,Amazon,Electronics,Gadgets,1,0,1,1,2024-01-01 00:00:00,2024-12-31 23:59:59,2024-01-01 00:00:00';
    } else if (type === 'stores') {
        csvContent = 'ID,Title,Description,SEO Title,SEO Description,Featured,Status,Slug,Image,Affiliate URL,Created\n';
        csvContent += '1,Sample Store,Best deals online,Sample Store - Best Deals,Find the best deals at Sample Store,1,1,sample-store,store-image.jpg,https://example.com/affiliate,2024-01-01 00:00:00';
    }
    
    var blob = new Blob([csvContent], { type: 'text/csv' });
    var url = window.URL.createObjectURL(blob);
    var a = document.createElement('a');
    a.href = url;
    a.download = type + '_template.csv';
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    window.URL.revokeObjectURL(url);
}
</script>
