<?php

/*--------------------*/
// Description: Couponza - Coupons & Discounts Php Script
// Author: Wicombit
// Author URI: https://www.wicombit.com
/*--------------------*/

session_start();
if (isset($_SESSION['user_email'])){

require '../../config.php';
require '../functions.php';

$connect = connect();

// Check if user is admin or agent
if (isAdmin($connect) || isAgent($connect)){

// Handle CSV Export
if (isset($_GET['action']) && $_GET['action'] == 'export') {
    $type = $_GET['type'] ?? 'coupons';
    
    if ($type == 'coupons') {
        // Export Coupons
        $filename = 'coupons_export_' . date('Y-m-d_H-i-s') . '.csv';
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        
        $output = fopen('php://output', 'w');
        
        // CSV Headers
        fputcsv($output, array(
            'ID', 'Title', 'Description', 'Code', 'Store', 'Store URL', 'Store Affiliate URL', 'Store Image', 
            'Category', 'Subcategory', 'Featured', 'Exclusive', 'Verified', 'Status', 'Start Date', 'Expire Date', 'Created'
        ));
        
        // Get coupons data
        $stmt = $connect->query("
            SELECT c.*, s.store_title, s.store_url, s.store_affiliate_url, s.store_image, 
                   cat.category_title, sub.subcategory_title 
            FROM coupons c 
            LEFT JOIN stores s ON c.coupon_store = s.store_id 
            LEFT JOIN categories cat ON c.coupon_category = cat.category_id 
            LEFT JOIN subcategories sub ON c.coupon_subcategory = sub.subcategory_id 
            ORDER BY c.coupon_id DESC
        ");
        
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            fputcsv($output, array(
                $row['coupon_id'],
                $row['coupon_title'],
                $row['coupon_description'],
                $row['coupon_code'],
                $row['store_title'],
                $row['store_url'] ?? '',
                $row['store_affiliate_url'] ?? '',
                $row['store_image'] ?? '',
                $row['category_title'],
                $row['subcategory_title'],
                $row['coupon_featured'],
                $row['coupon_exclusive'],
                $row['coupon_verify'],
                $row['coupon_status'],
                $row['coupon_start'],
                $row['coupon_expire'],
                $row['coupon_created'],
                $row['coupon_image'] ?? ''
            ));
        }
        
        fclose($output);
        exit;
        
    } elseif ($type == 'stores') {
        // Export Stores
        $filename = 'stores_export_' . date('Y-m-d_H-i-s') . '.csv';
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        
        $output = fopen('php://output', 'w');
        
        // CSV Headers
        fputcsv($output, array(
            'ID', 'Title', 'Description', 'SEO Title', 'SEO Description', 
            'Featured', 'Status', 'Slug', 'Image', 'Affiliate URL', 'Created'
        ));
        
        // Get stores data
        $stmt = $connect->query("SELECT * FROM stores ORDER BY store_id DESC");
        
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            fputcsv($output, array(
                $row['store_id'],
                $row['store_title'],
                $row['store_description'],
                $row['store_seotitle'],
                $row['store_seodescription'],
                $row['store_featured'],
                $row['store_status'],
                $row['store_slug'],
                $row['store_image'],
                $row['store_affiliate_url'] ?? '',
                $row['store_created']
            ));
        }
        
        fclose($output);
        exit;
    }
}

// Handle CSV Import
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['csv_file'])) {
    $type = $_POST['import_type'] ?? 'coupons';
    $file = $_FILES['csv_file'];
    
    if ($file['error'] == 0) {
        $handle = fopen($file['tmp_name'], 'r');
        $header = fgetcsv($handle); // Skip header row
        
        $imported = 0;
        $errors = 0;
        
        if ($type == 'coupons') {
            while (($data = fgetcsv($handle)) !== FALSE) {
                try {
                    // Get store ID by name
                    $store_stmt = $connect->prepare("SELECT store_id FROM stores WHERE store_title = ? LIMIT 1");
                    $store_stmt->execute([$data[4]]);
                    $store_id = $store_stmt->fetchColumn() ?: 1;
                    
                    // Get category ID by name
                    $cat_stmt = $connect->prepare("SELECT category_id FROM categories WHERE category_title = ? LIMIT 1");
                    $cat_stmt->execute([$data[5]]);
                    $cat_id = $cat_stmt->fetchColumn() ?: 1;
                    
                    // Get subcategory ID by name
                    $subcat_id = null;
                    if (!empty($data[6])) {
                        $subcat_stmt = $connect->prepare("SELECT subcategory_id FROM subcategories WHERE subcategory_title = ? LIMIT 1");
                        $subcat_stmt->execute([$data[6]]);
                        $subcat_id = $subcat_stmt->fetchColumn();
                    }
                    
                    $stmt = $connect->prepare("
                        INSERT INTO coupons (
                            coupon_title, coupon_description, coupon_code, coupon_store, 
                            coupon_category, coupon_subcategory, coupon_featured, 
                            coupon_exclusive, coupon_verify, coupon_status, 
                            coupon_start, coupon_expire, coupon_author
                        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                    ");
                    
                    $stmt->execute([
                        $data[1], $data[2], $data[3], $store_id, $cat_id, $subcat_id,
                        $data[7] ?? 0, $data[8] ?? 0, $data[9] ?? 0, $data[10] ?? 1,
                        $data[11] ?? date('Y-m-d H:i:s'), $data[12], $_SESSION['user_id'] ?? 1
                    ]);
                    
                    $imported++;
                } catch (Exception $e) {
                    $errors++;
                }
            }
        } elseif ($type == 'stores') {
            while (($data = fgetcsv($handle)) !== FALSE) {
                try {
                    $stmt = $connect->prepare("
                        INSERT INTO stores (
                            store_title, store_description, store_seotitle, 
                            store_seodescription, store_featured, store_status, 
                            store_slug, store_image, store_affiliate_url
                        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
                    ");
                    
                    $stmt->execute([
                        $data[1], $data[2], $data[3], $data[4], 
                        $data[5] ?? 0, $data[6] ?? 1, $data[7], 
                        $data[8] ?? '', $data[9] ?? ''
                    ]);
                    
                    $imported++;
                } catch (Exception $e) {
                    $errors++;
                }
            }
        }
        
        fclose($handle);
        
        $message = "Import completed! Imported: $imported, Errors: $errors";
    } else {
        $message = "Error uploading file.";
    }
}

require '../views/header.view.php';
require '../views/import_export.view.php';
require '../views/footer.view.php';

}else{

    header('Location: ./login.php');

}

}else{

    header('Location: ./login.php');

}

?>
