<?php

/*--------------------*/
// Description: Couponza - Coupons & Discounts Php Script
// Author: Wicombit
// Author URI: https://www.wicombit.com
/*--------------------*/

session_start();
if (isset($_SESSION['user_email'])){

require '../../config.php';
require '../functions.php';

$connect = connect();

// Check if user is admin or agent
if (isAdmin($connect) || isAgent($connect)){

/**
 * Generate affiliate link for a specific program
 */
function generateAffiliateLink($connect, $program_name, $original_url, $store_id = null) {
    // Get program settings
    $stmt = $connect->prepare("SELECT * FROM affiliate_programs WHERE program_name = ? AND status = 1");
    $stmt->execute([$program_name]);
    $program = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$program || empty($program['api_key'])) {
        return $original_url; // Return original URL if program not configured
    }
    
    $affiliate_url = $original_url;
    
    // Generate affiliate URL based on program
    switch ($program_name) {
        case 'Cuelinks':
            $affiliate_url = generateCuelinksLink($original_url, $program['api_key']);
            break;
            
        case 'INR Deals':
            $affiliate_url = generateINRDealsLink($original_url, $program['api_key']);
            break;
            
        case 'Admitad':
            $affiliate_url = generateAdmitadLink($original_url, $program['api_key'], $program['api_secret']);
            break;
            
        case 'Commission Junction (CJ)':
            $affiliate_url = generateCJLink($original_url, $program['api_key'], $program['api_secret']);
            break;
    }
    
    // Store the affiliate link in database
    if ($store_id) {
        $stmt = $connect->prepare("
            INSERT INTO affiliate_links (store_id, program_name, original_url, affiliate_url) 
            VALUES (?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE affiliate_url = VALUES(affiliate_url)
        ");
        $stmt->execute([$store_id, $program_name, $original_url, $affiliate_url]);
    }
    
    return $affiliate_url;
}

/**
 * Generate Cuelinks affiliate link
 */
function generateCuelinksLink($url, $api_key) {
    // Cuelinks API integration
    $api_url = "https://api.cuelinks.com/v1/links";
    
    $data = [
        'url' => $url,
        'api_key' => $api_key
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $api_key,
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['short_url'])) {
            return $result['short_url'];
        } elseif (isset($result['affiliate_url'])) {
            return $result['affiliate_url'];
        }
    }
    
    // Fallback: Simple URL modification for Cuelinks
    return "https://cuelinks.com/redirect?url=" . urlencode($url) . "&key=" . $api_key;
}

/**
 * Generate INR Deals affiliate link
 */
function generateINRDealsLink($url, $api_key) {
    // INR Deals API integration
    $api_url = "https://api.inrdeals.com/v1/affiliate";
    
    $data = [
        'url' => $url,
        'api_key' => $api_key
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $api_key,
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['affiliate_url'])) {
            return $result['affiliate_url'];
        } elseif (isset($result['short_url'])) {
            return $result['short_url'];
        }
    }
    
    // Fallback: Simple URL modification for INR Deals
    return "https://inrdeals.com/redirect?url=" . urlencode($url) . "&ref=" . $api_key;
}

/**
 * Generate Admitad affiliate link
 */
function generateAdmitadLink($url, $api_key, $api_secret = '') {
    // Admitad API integration with Base64 authentication
    $api_url = "https://api.admitad.com/links/";
    
    // Create Base64 encoded credentials
    $credentials = base64_encode($api_key . ':' . $api_secret);
    
    $data = [
        'url' => $url,
        'campaign_id' => $api_key // Using api_key as campaign_id
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Basic ' . $credentials
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['link'])) {
            return $result['link'];
        }
    }
    
    // Fallback: Simple URL modification for Admitad
    return "https://ad.admitad.com/g/redirect?url=" . urlencode($url) . "&key=" . $api_key;
}

/**
 * Generate Commission Junction affiliate link
 */
function generateCJLink($url, $api_key, $publisher_id = '') {
    // CJ API integration
    $api_url = "https://linksearch.api.cj.com/v3/link-search";
    
    $params = [
        'website-id' => $publisher_id,
        'url' => $url,
        'format' => 'json'
    ];
    
    $api_url .= '?' . http_build_query($params);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $api_key,
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['links'][0]['clickUrl'])) {
            return $result['links'][0]['clickUrl'];
        } elseif (isset($result['link'])) {
            return $result['link'];
        }
    }
    
    // Fallback: Simple URL modification for CJ
    return "https://www.anrdoezrs.net/links/redirect?url=" . urlencode($url) . "&key=" . $api_key;
}

// Handle AJAX requests for link generation
if (isset($_POST['action']) && $_POST['action'] == 'generate_link') {
    $program_name = $_POST['program_name'];
    $original_url = $_POST['original_url'];
    $store_id = $_POST['store_id'] ?? null;
    
    // Validate URL
    if (!filter_var($original_url, FILTER_VALIDATE_URL)) {
        header('Content-Type: application/json');
        echo json_encode([
            'success' => false,
            'message' => 'Invalid URL format'
        ]);
        exit;
    }
    
    $affiliate_url = generateAffiliateLink($connect, $program_name, $original_url, $store_id);
    
    header('Content-Type: application/json');
    echo json_encode([
        'success' => true,
        'affiliate_url' => $affiliate_url,
        'original_url' => $original_url,
        'program_name' => $program_name
    ]);
    exit;
}

}else{

    header('Location: ./login.php');

}

}else{

    header('Location: ./login.php');

}

?>

/*--------------------*/
// Description: Couponza - Coupons & Discounts Php Script
// Author: Wicombit
// Author URI: https://www.wicombit.com
/*--------------------*/

session_start();
if (isset($_SESSION['user_email'])){

require '../../config.php';
require '../functions.php';

$connect = connect();

// Check if user is admin or agent
if (isAdmin($connect) || isAgent($connect)){

/**
 * Generate affiliate link for a specific program
 */
function generateAffiliateLink($connect, $program_name, $original_url, $store_id = null) {
    // Get program settings
    $stmt = $connect->prepare("SELECT * FROM affiliate_programs WHERE program_name = ? AND status = 1");
    $stmt->execute([$program_name]);
    $program = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$program || empty($program['api_key'])) {
        return $original_url; // Return original URL if program not configured
    }
    
    $affiliate_url = $original_url;
    
    // Generate affiliate URL based on program
    switch ($program_name) {
        case 'Cuelinks':
            $affiliate_url = generateCuelinksLink($original_url, $program['api_key']);
            break;
            
        case 'INR Deals':
            $affiliate_url = generateINRDealsLink($original_url, $program['api_key']);
            break;
            
        case 'Admitad':
            $affiliate_url = generateAdmitadLink($original_url, $program['api_key'], $program['api_secret']);
            break;
            
        case 'Commission Junction (CJ)':
            $affiliate_url = generateCJLink($original_url, $program['api_key'], $program['api_secret']);
            break;
    }
    
    // Store the affiliate link in database
    if ($store_id) {
        $stmt = $connect->prepare("
            INSERT INTO affiliate_links (store_id, program_name, original_url, affiliate_url) 
            VALUES (?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE affiliate_url = VALUES(affiliate_url)
        ");
        $stmt->execute([$store_id, $program_name, $original_url, $affiliate_url]);
    }
    
    return $affiliate_url;
}

/**
 * Generate Cuelinks affiliate link
 */
function generateCuelinksLink($url, $api_key) {
    // Cuelinks API integration
    $api_url = "https://api.cuelinks.com/v1/links";
    
    $data = [
        'url' => $url,
        'api_key' => $api_key
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $api_key,
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['short_url'])) {
            return $result['short_url'];
        } elseif (isset($result['affiliate_url'])) {
            return $result['affiliate_url'];
        }
    }
    
    // Fallback: Simple URL modification for Cuelinks
    return "https://cuelinks.com/redirect?url=" . urlencode($url) . "&key=" . $api_key;
}

/**
 * Generate INR Deals affiliate link
 */
function generateINRDealsLink($url, $api_key) {
    // INR Deals API integration
    $api_url = "https://api.inrdeals.com/v1/affiliate";
    
    $data = [
        'url' => $url,
        'api_key' => $api_key
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $api_key,
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['affiliate_url'])) {
            return $result['affiliate_url'];
        } elseif (isset($result['short_url'])) {
            return $result['short_url'];
        }
    }
    
    // Fallback: Simple URL modification for INR Deals
    return "https://inrdeals.com/redirect?url=" . urlencode($url) . "&ref=" . $api_key;
}

/**
 * Generate Admitad affiliate link
 */
function generateAdmitadLink($url, $api_key, $api_secret = '') {
    // Admitad API integration with Base64 authentication
    $api_url = "https://api.admitad.com/links/";
    
    // Create Base64 encoded credentials
    $credentials = base64_encode($api_key . ':' . $api_secret);
    
    $data = [
        'url' => $url,
        'campaign_id' => $api_key // Using api_key as campaign_id
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Basic ' . $credentials
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['link'])) {
            return $result['link'];
        }
    }
    
    // Fallback: Simple URL modification for Admitad
    return "https://ad.admitad.com/g/redirect?url=" . urlencode($url) . "&key=" . $api_key;
}

/**
 * Generate Commission Junction affiliate link
 */
function generateCJLink($url, $api_key, $publisher_id = '') {
    // CJ API integration
    $api_url = "https://linksearch.api.cj.com/v3/link-search";
    
    $params = [
        'website-id' => $publisher_id,
        'url' => $url,
        'format' => 'json'
    ];
    
    $api_url .= '?' . http_build_query($params);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $api_key,
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['links'][0]['clickUrl'])) {
            return $result['links'][0]['clickUrl'];
        } elseif (isset($result['link'])) {
            return $result['link'];
        }
    }
    
    // Fallback: Simple URL modification for CJ
    return "https://www.anrdoezrs.net/links/redirect?url=" . urlencode($url) . "&key=" . $api_key;
}

// Handle AJAX requests for link generation
if (isset($_POST['action']) && $_POST['action'] == 'generate_link') {
    $program_name = $_POST['program_name'];
    $original_url = $_POST['original_url'];
    $store_id = $_POST['store_id'] ?? null;
    
    // Validate URL
    if (!filter_var($original_url, FILTER_VALIDATE_URL)) {
        header('Content-Type: application/json');
        echo json_encode([
            'success' => false,
            'message' => 'Invalid URL format'
        ]);
        exit;
    }
    
    $affiliate_url = generateAffiliateLink($connect, $program_name, $original_url, $store_id);
    
    header('Content-Type: application/json');
    echo json_encode([
        'success' => true,
        'affiliate_url' => $affiliate_url,
        'original_url' => $original_url,
        'program_name' => $program_name
    ]);
    exit;
}

}else{

    header('Location: ./login.php');

}

}else{

    header('Location: ./login.php');

}

?>

/*--------------------*/
// Description: Couponza - Coupons & Discounts Php Script
// Author: Wicombit
// Author URI: https://www.wicombit.com
/*--------------------*/

session_start();
if (isset($_SESSION['user_email'])){

require '../../config.php';
require '../functions.php';

$connect = connect();

// Check if user is admin or agent
if (isAdmin($connect) || isAgent($connect)){

/**
 * Generate affiliate link for a specific program
 */
function generateAffiliateLink($connect, $program_name, $original_url, $store_id = null) {
    // Get program settings
    $stmt = $connect->prepare("SELECT * FROM affiliate_programs WHERE program_name = ? AND status = 1");
    $stmt->execute([$program_name]);
    $program = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$program || empty($program['api_key'])) {
        return $original_url; // Return original URL if program not configured
    }
    
    $affiliate_url = $original_url;
    
    // Generate affiliate URL based on program
    switch ($program_name) {
        case 'Cuelinks':
            $affiliate_url = generateCuelinksLink($original_url, $program['api_key']);
            break;
            
        case 'INR Deals':
            $affiliate_url = generateINRDealsLink($original_url, $program['api_key']);
            break;
            
        case 'Admitad':
            $affiliate_url = generateAdmitadLink($original_url, $program['api_key'], $program['api_secret']);
            break;
            
        case 'Commission Junction (CJ)':
            $affiliate_url = generateCJLink($original_url, $program['api_key'], $program['api_secret']);
            break;
    }
    
    // Store the affiliate link in database
    if ($store_id) {
        $stmt = $connect->prepare("
            INSERT INTO affiliate_links (store_id, program_name, original_url, affiliate_url) 
            VALUES (?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE affiliate_url = VALUES(affiliate_url)
        ");
        $stmt->execute([$store_id, $program_name, $original_url, $affiliate_url]);
    }
    
    return $affiliate_url;
}

/**
 * Generate Cuelinks affiliate link
 */
function generateCuelinksLink($url, $api_key) {
    // Cuelinks API integration
    $api_url = "https://api.cuelinks.com/v1/links";
    
    $data = [
        'url' => $url,
        'api_key' => $api_key
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $api_key,
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['short_url'])) {
            return $result['short_url'];
        } elseif (isset($result['affiliate_url'])) {
            return $result['affiliate_url'];
        }
    }
    
    // Fallback: Simple URL modification for Cuelinks
    return "https://cuelinks.com/redirect?url=" . urlencode($url) . "&key=" . $api_key;
}

/**
 * Generate INR Deals affiliate link
 */
function generateINRDealsLink($url, $api_key) {
    // INR Deals API integration
    $api_url = "https://api.inrdeals.com/v1/affiliate";
    
    $data = [
        'url' => $url,
        'api_key' => $api_key
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $api_key,
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['affiliate_url'])) {
            return $result['affiliate_url'];
        } elseif (isset($result['short_url'])) {
            return $result['short_url'];
        }
    }
    
    // Fallback: Simple URL modification for INR Deals
    return "https://inrdeals.com/redirect?url=" . urlencode($url) . "&ref=" . $api_key;
}

/**
 * Generate Admitad affiliate link
 */
function generateAdmitadLink($url, $api_key, $api_secret = '') {
    // Admitad API integration with Base64 authentication
    $api_url = "https://api.admitad.com/links/";
    
    // Create Base64 encoded credentials
    $credentials = base64_encode($api_key . ':' . $api_secret);
    
    $data = [
        'url' => $url,
        'campaign_id' => $api_key // Using api_key as campaign_id
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Basic ' . $credentials
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['link'])) {
            return $result['link'];
        }
    }
    
    // Fallback: Simple URL modification for Admitad
    return "https://ad.admitad.com/g/redirect?url=" . urlencode($url) . "&key=" . $api_key;
}

/**
 * Generate Commission Junction affiliate link
 */
function generateCJLink($url, $api_key, $publisher_id = '') {
    // CJ API integration
    $api_url = "https://linksearch.api.cj.com/v3/link-search";
    
    $params = [
        'website-id' => $publisher_id,
        'url' => $url,
        'format' => 'json'
    ];
    
    $api_url .= '?' . http_build_query($params);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $api_key,
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['links'][0]['clickUrl'])) {
            return $result['links'][0]['clickUrl'];
        } elseif (isset($result['link'])) {
            return $result['link'];
        }
    }
    
    // Fallback: Simple URL modification for CJ
    return "https://www.anrdoezrs.net/links/redirect?url=" . urlencode($url) . "&key=" . $api_key;
}

// Handle AJAX requests for link generation
if (isset($_POST['action']) && $_POST['action'] == 'generate_link') {
    $program_name = $_POST['program_name'];
    $original_url = $_POST['original_url'];
    $store_id = $_POST['store_id'] ?? null;
    
    // Validate URL
    if (!filter_var($original_url, FILTER_VALIDATE_URL)) {
        header('Content-Type: application/json');
        echo json_encode([
            'success' => false,
            'message' => 'Invalid URL format'
        ]);
        exit;
    }
    
    $affiliate_url = generateAffiliateLink($connect, $program_name, $original_url, $store_id);
    
    header('Content-Type: application/json');
    echo json_encode([
        'success' => true,
        'affiliate_url' => $affiliate_url,
        'original_url' => $original_url,
        'program_name' => $program_name
    ]);
    exit;
}

}else{

    header('Location: ./login.php');

}

}else{

    header('Location: ./login.php');

}

?>

/*--------------------*/
// Description: Couponza - Coupons & Discounts Php Script
// Author: Wicombit
// Author URI: https://www.wicombit.com
/*--------------------*/

session_start();
if (isset($_SESSION['user_email'])){

require '../../config.php';
require '../functions.php';

$connect = connect();

// Check if user is admin or agent
if (isAdmin($connect) || isAgent($connect)){

/**
 * Generate affiliate link for a specific program
 */
function generateAffiliateLink($connect, $program_name, $original_url, $store_id = null) {
    // Get program settings
    $stmt = $connect->prepare("SELECT * FROM affiliate_programs WHERE program_name = ? AND status = 1");
    $stmt->execute([$program_name]);
    $program = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$program || empty($program['api_key'])) {
        return $original_url; // Return original URL if program not configured
    }
    
    $affiliate_url = $original_url;
    
    // Generate affiliate URL based on program
    switch ($program_name) {
        case 'Cuelinks':
            $affiliate_url = generateCuelinksLink($original_url, $program['api_key']);
            break;
            
        case 'INR Deals':
            $affiliate_url = generateINRDealsLink($original_url, $program['api_key']);
            break;
            
        case 'Admitad':
            $affiliate_url = generateAdmitadLink($original_url, $program['api_key'], $program['api_secret']);
            break;
            
        case 'Commission Junction (CJ)':
            $affiliate_url = generateCJLink($original_url, $program['api_key'], $program['api_secret']);
            break;
    }
    
    // Store the affiliate link in database
    if ($store_id) {
        $stmt = $connect->prepare("
            INSERT INTO affiliate_links (store_id, program_name, original_url, affiliate_url) 
            VALUES (?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE affiliate_url = VALUES(affiliate_url)
        ");
        $stmt->execute([$store_id, $program_name, $original_url, $affiliate_url]);
    }
    
    return $affiliate_url;
}

/**
 * Generate Cuelinks affiliate link
 */
function generateCuelinksLink($url, $api_key) {
    // Cuelinks API integration
    $api_url = "https://api.cuelinks.com/v1/links";
    
    $data = [
        'url' => $url,
        'api_key' => $api_key
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $api_key,
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['short_url'])) {
            return $result['short_url'];
        } elseif (isset($result['affiliate_url'])) {
            return $result['affiliate_url'];
        }
    }
    
    // Fallback: Simple URL modification for Cuelinks
    return "https://cuelinks.com/redirect?url=" . urlencode($url) . "&key=" . $api_key;
}

/**
 * Generate INR Deals affiliate link
 */
function generateINRDealsLink($url, $api_key) {
    // INR Deals API integration
    $api_url = "https://api.inrdeals.com/v1/affiliate";
    
    $data = [
        'url' => $url,
        'api_key' => $api_key
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $api_key,
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['affiliate_url'])) {
            return $result['affiliate_url'];
        } elseif (isset($result['short_url'])) {
            return $result['short_url'];
        }
    }
    
    // Fallback: Simple URL modification for INR Deals
    return "https://inrdeals.com/redirect?url=" . urlencode($url) . "&ref=" . $api_key;
}

/**
 * Generate Admitad affiliate link
 */
function generateAdmitadLink($url, $api_key, $api_secret = '') {
    // Admitad API integration with Base64 authentication
    $api_url = "https://api.admitad.com/links/";
    
    // Create Base64 encoded credentials
    $credentials = base64_encode($api_key . ':' . $api_secret);
    
    $data = [
        'url' => $url,
        'campaign_id' => $api_key // Using api_key as campaign_id
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Basic ' . $credentials
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['link'])) {
            return $result['link'];
        }
    }
    
    // Fallback: Simple URL modification for Admitad
    return "https://ad.admitad.com/g/redirect?url=" . urlencode($url) . "&key=" . $api_key;
}

/**
 * Generate Commission Junction affiliate link
 */
function generateCJLink($url, $api_key, $publisher_id = '') {
    // CJ API integration
    $api_url = "https://linksearch.api.cj.com/v3/link-search";
    
    $params = [
        'website-id' => $publisher_id,
        'url' => $url,
        'format' => 'json'
    ];
    
    $api_url .= '?' . http_build_query($params);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $api_key,
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        if (isset($result['links'][0]['clickUrl'])) {
            return $result['links'][0]['clickUrl'];
        } elseif (isset($result['link'])) {
            return $result['link'];
        }
    }
    
    // Fallback: Simple URL modification for CJ
    return "https://www.anrdoezrs.net/links/redirect?url=" . urlencode($url) . "&key=" . $api_key;
}

// Handle AJAX requests for link generation
if (isset($_POST['action']) && $_POST['action'] == 'generate_link') {
    $program_name = $_POST['program_name'];
    $original_url = $_POST['original_url'];
    $store_id = $_POST['store_id'] ?? null;
    
    // Validate URL
    if (!filter_var($original_url, FILTER_VALIDATE_URL)) {
        header('Content-Type: application/json');
        echo json_encode([
            'success' => false,
            'message' => 'Invalid URL format'
        ]);
        exit;
    }
    
    $affiliate_url = generateAffiliateLink($connect, $program_name, $original_url, $store_id);
    
    header('Content-Type: application/json');
    echo json_encode([
        'success' => true,
        'affiliate_url' => $affiliate_url,
        'original_url' => $original_url,
        'program_name' => $program_name
    ]);
    exit;
}

}else{

    header('Location: ./login.php');

}

}else{

    header('Location: ./login.php');

}

?>
